/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.clevertap.android.sdk.CleverTapAPI;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import java.util.HashMap;

final class ManifestMetaData {
    private static HashMap<String, String> cachedMeta = new HashMap();

    ManifestMetaData() {
    }

    public static String getMetaData(Context context, String name) throws CleverTapMetaDataNotFoundException {
        if (name.equals("CLEVERTAP_ACCOUNT_ID") && CleverTapAPI.localAccountID != null) {
            return CleverTapAPI.localAccountID;
        }
        if (name.equals("CLEVERTAP_TOKEN") && CleverTapAPI.localToken != null) {
            return CleverTapAPI.localToken;
        }
        String meta = cachedMeta.get(name);
        if (meta != null) {
            return meta;
        }
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            Bundle metaData = ai.metaData;
            if (metaData == null) {
                throw new PackageManager.NameNotFoundException();
            }
            Object o = metaData.get(name);
            if (o == null) {
                throw new Exception();
            }
            cachedMeta.put(name, o.toString());
            return o.toString();
        }
        catch (Throwable t) {
            Logger.logFine("Requested meta data entry not found: " + name);
            throw new CleverTapMetaDataNotFoundException("Required meta data entry " + name + " is not specified");
        }
    }
}

