/*
 * Decompiled with CFR 0.152.
 */
package com.clevertap.android.sdk;

import android.accounts.Account;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.location.Location;
import android.location.LocationManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.NotificationCompat;
import com.clevertap.android.sdk.BuildInfo;
import com.clevertap.android.sdk.CommsManager;
import com.clevertap.android.sdk.DataHandler;
import com.clevertap.android.sdk.DeviceInfo;
import com.clevertap.android.sdk.EventHandler;
import com.clevertap.android.sdk.GcmManager;
import com.clevertap.android.sdk.InAppManager;
import com.clevertap.android.sdk.LocalDataStore;
import com.clevertap.android.sdk.Logger;
import com.clevertap.android.sdk.ManifestMetaData;
import com.clevertap.android.sdk.NotificationInfo;
import com.clevertap.android.sdk.ParseUtils;
import com.clevertap.android.sdk.ProfileHandler;
import com.clevertap.android.sdk.QueueManager;
import com.clevertap.android.sdk.SessionHandler;
import com.clevertap.android.sdk.SessionManager;
import com.clevertap.android.sdk.StorageHelper;
import com.clevertap.android.sdk.SyncListener;
import com.clevertap.android.sdk.UriHelper;
import com.clevertap.android.sdk.Utils;
import com.clevertap.android.sdk.ValidationResult;
import com.clevertap.android.sdk.Validator;
import com.clevertap.android.sdk.exceptions.CleverTapMetaDataNotFoundException;
import com.clevertap.android.sdk.exceptions.CleverTapPermissionsNotSatisfied;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.iid.InstanceID;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public final class CleverTapAPI {
    public static final String CHARGED_EVENT = "Charged";
    public static final String NOTIFICATION_TAG = "wzrk_pn";
    private static final String PROPERTY_APP_VERSION = "appVersionCode";
    private static final Handler handlerUsingMainLooper = new Handler(Looper.getMainLooper());
    private static final ExecutorService es = Executors.newFixedThreadPool(1);
    private static int debugLevel = 0;
    private static boolean appForeground = false;
    private static CleverTapAPI ourInstance = null;
    static Runnable pendingInappRunnable = null;
    static String localAccountID = null;
    static String localToken = null;
    private static int lastLocationPingTime = 0;
    private static boolean usingParse = false;
    static int activityCount = 0;
    private static ArrayList<ValidationResult> pendingValidationResults = new ArrayList();
    private static final Boolean pendingValidationResultsLock = true;
    static Activity currentActivity;
    private static String parseInstallationId;
    private static String googleAdID;
    public final EventHandler event;
    public final DataHandler data;
    public final ProfileHandler profile;
    public final SessionHandler session;
    private Runnable sessionTimeoutRunnable = null;
    private final Context context;
    private long appLastSeen;
    private SyncListener syncListener = null;
    private Location locationFromUser = null;
    private boolean pushedGcmId = false;
    private boolean pushedProfileDefaults = false;
    private final String PREFS_LAST_DAILY_PUSHED_EVENTS_DATE = "lastDailyEventsPushedDate";
    private static HashSet<String> inappActivityExclude;
    private final String APP_VERSION_CODE_TAG = "avc";
    private static int gcmSleepFactor;
    private static final HashMap<String, Integer> installReferrerMap;

    static boolean isUsingParse() {
        return usingParse;
    }

    static String getParseInstallationId() {
        return parseInstallationId;
    }

    static String getGoogleAdID() {
        return googleAdID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ValidationResult popValidationResult() {
        ValidationResult vr = null;
        Boolean bl = pendingValidationResultsLock;
        synchronized (bl) {
            try {
                if (!pendingValidationResults.isEmpty()) {
                    vr = pendingValidationResults.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pushValidationResult(ValidationResult vr) {
        Boolean bl = pendingValidationResultsLock;
        synchronized (bl) {
            try {
                int len = pendingValidationResults.size();
                if (len > 50) {
                    ArrayList<ValidationResult> trimmed = new ArrayList<ValidationResult>();
                    for (int i = 10; i < len; ++i) {
                        trimmed.add(pendingValidationResults.get(i));
                    }
                    trimmed.add(vr);
                    pendingValidationResults = trimmed;
                } else {
                    pendingValidationResults.add(vr);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static Handler getHandlerUsingMainLooper() {
        return handlerUsingMainLooper;
    }

    static void postAsyncSafely(final String name, final Runnable runnable) {
        try {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Logger.logFine("Executor service: Starting task - " + name);
                        long start = System.currentTimeMillis();
                        runnable.run();
                        long time = System.currentTimeMillis() - start;
                        Logger.logFine("Executor service: Task completed successfully in " + time + "ms (" + name + ")");
                    }
                    catch (Throwable t) {
                        Logger.logFine("Executor service: Failed to complete the scheduled task", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.logFine("Failed to submit task to the executor service", t);
        }
    }

    static boolean isAppForeground() {
        return appForeground;
    }

    public static void setAppForeground(boolean appForeground) {
        CleverTapAPI.appForeground = appForeground;
    }

    public void setSyncListener(SyncListener syncListener) {
        this.syncListener = syncListener;
    }

    public SyncListener getSyncListener() {
        return this.syncListener;
    }

    public static synchronized CleverTapAPI getInstance(Context context) throws CleverTapMetaDataNotFoundException, CleverTapPermissionsNotSatisfied {
        if (ourInstance == null && context != null) {
            LocalDataStore.initializeWithContext(context);
            CleverTapAPI.updateAdvertisingID(context);
            try {
                boolean bl = usingParse = ManifestMetaData.getMetaData(context, "CLEVERTAP_PARSE") != null;
                if (usingParse) {
                    CleverTapAPI.retrieveIdentifierForParse(context);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            DeviceInfo.updateDeviceIdIfRequired(context.getApplicationContext());
            ourInstance = new CleverTapAPI(context.getApplicationContext());
        }
        return ourInstance;
    }

    private CleverTapAPI(Context context) throws CleverTapMetaDataNotFoundException, CleverTapPermissionsNotSatisfied {
        this.context = context;
        this.event = new EventHandler(context);
        this.profile = new ProfileHandler(context);
        this.data = new DataHandler(context);
        this.session = new SessionHandler(context);
        DeviceInfo.testPermission(context, "android.permission.INTERNET");
        ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
        ManifestMetaData.getMetaData(context, "CLEVERTAP_TOKEN");
        Logger.logFine("New instance of CleverTapAPI created");
        this.initPushHandling();
    }

    void notifyUserProfileInitialized() {
        if (this.syncListener != null) {
            String cleverTapID = this.getCleverTapID();
            if (cleverTapID == null) {
                return;
            }
            try {
                Logger.logFine("Notifying UserProfileInitialized with CleverTapId " + cleverTapID);
                this.syncListener.profileDidInitialize(cleverTapID);
            }
            catch (Throwable t) {
                Logger.error("Execution of sync listener failed", t);
            }
        }
    }

    private static void retrieveIdentifierForParse(final Context context) {
        CleverTapAPI.postAsyncSafely("parse-id-retriever", new Runnable(){

            @Override
            public void run() {
                String installationId = ParseUtils.getParseInstallationId(context);
                if (installationId != null) {
                    try {
                        installationId = "_p" + installationId.replace("-", "");
                        Logger.logFine("Setting Parse installation ID " + installationId);
                        parseInstallationId = installationId;
                    }
                    catch (Exception e) {
                        Logger.logFine("Error reading Parse installation ID: " + e.toString());
                    }
                }
            }
        });
    }

    public static void changeCredentials(String accountID, String token) {
        localAccountID = accountID;
        localToken = token;
    }

    static String getAccountID(Context context) {
        if (localAccountID == null) {
            try {
                localAccountID = ManifestMetaData.getMetaData(context, "CLEVERTAP_ACCOUNT_ID");
            }
            catch (Exception e) {
                Logger.logFine("Error reading accountID: " + e.toString());
            }
        }
        return localAccountID;
    }

    private JSONObject getProfileDefaults() {
        JSONObject defaults = new JSONObject();
        String name = null;
        Account account = this.profile.getGoogleAccount();
        if (account != null && account.name != null) {
            try {
                ValidationResult vr = Validator.cleanObjectValue(account.name, false, false);
                String email = vr.getObject().toString();
                String[] parts = email.split("\\@");
                name = parts[0];
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (name != null) {
            try {
                defaults.put("Name", name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return defaults;
    }

    void pushProfileDefaults() {
        CleverTapAPI.postAsyncSafely("CleverTapAPI#pushProfileDefaultsAsync", new Runnable(){

            @Override
            public void run() {
                if (CleverTapAPI.this.pushedProfileDefaults) {
                    return;
                }
                CleverTapAPI.this.pushedProfileDefaults = true;
                try {
                    JSONObject defaults = CleverTapAPI.this.getProfileDefaults();
                    if (defaults.length() > 0) {
                        CleverTapAPI.this.profile.pushProfileDefaults(CleverTapAPI.this.context, defaults);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Daily profile sync failed", t);
                }
            }
        });
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void pushDailyEventsAsync() {
        CleverTapAPI.postAsyncSafely("CleverTapAPI#pushDailyEventsAsync", new Runnable(){

            @Override
            public void run() {
                try {
                    Date d = new Date();
                    SharedPreferences prefs = StorageHelper.getPreferences(CleverTapAPI.this.context);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    if (CleverTapAPI.this.hasAppVersionChanged() || prefs.getInt("lastDailyEventsPushedDate", 0) != cal.get(5)) {
                        Logger.logFine("Queuing daily events");
                        CleverTapAPI.this.profile.pushBasicProfile(null);
                        if (!CleverTapAPI.this.pushedGcmId) {
                            String gcmRegId = CleverTapAPI.this.getRegistrationId();
                            if (gcmRegId != null && !gcmRegId.equals("")) {
                                CleverTapAPI.this.data.pushGcmRegistrationId(gcmRegId, GcmManager.isGcmEnabled(CleverTapAPI.this.context));
                            }
                        } else {
                            Logger.logFine("Skipped push of the GCM ID. Somebody already sent it.");
                        }
                        CleverTapAPI.this.pushedGcmId = true;
                    }
                    SharedPreferences.Editor editor = prefs.edit().putInt("lastDailyEventsPushedDate", cal.get(5));
                    StorageHelper.persist(editor);
                    CleverTapAPI.this.updateAppVersionInPrefs();
                }
                catch (Throwable t) {
                    Logger.error("Daily profile sync failed", t);
                }
            }
        });
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public void activityPaused(Activity activity) {
        CleverTapAPI.setAppForeground(false);
        currentActivity = activity;
        this.appLastSeen = System.currentTimeMillis();
        if (this.sessionTimeoutRunnable == null) {
            this.sessionTimeoutRunnable = new Runnable(){

                @Override
                public void run() {
                    long now = System.currentTimeMillis();
                    if (!CleverTapAPI.isAppForeground() && now - CleverTapAPI.this.appLastSeen > 1200000L) {
                        Logger.logFine("Session timeout reached");
                        SessionManager.destroySession();
                        Logger.logFine("Current activity set to null");
                        currentActivity = null;
                    }
                }
            };
        }
        CleverTapAPI.getHandlerUsingMainLooper().removeCallbacks(this.sessionTimeoutRunnable);
        CleverTapAPI.getHandlerUsingMainLooper().postDelayed(this.sessionTimeoutRunnable, 1200000L);
        Logger.logFine("Foreground activity gone to background");
    }

    private void notifyActivityChanged(Activity activity) {
        currentActivity = activity;
        ++activityCount;
        if (activity != null) {
            Logger.logFine("Activity changed: " + activity.getLocalClassName());
        }
        if (inappActivityExclude == null) {
            inappActivityExclude = new HashSet();
            try {
                String activities = ManifestMetaData.getMetaData(this.context, "CLEVERTAP_INAPP_EXCLUDE");
                if (activities != null) {
                    String[] split;
                    for (String a : split = activities.split(",")) {
                        inappActivityExclude.add(a.trim());
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            Logger.log("In-app notifications will not be shown on " + Arrays.toString(inappActivityExclude.toArray()));
        }
        boolean activityBlacklisted = false;
        for (String blacklistedActivity : inappActivityExclude) {
            if (currentActivity == null || !currentActivity.getLocalClassName().contains(blacklistedActivity)) continue;
            activityBlacklisted = true;
            break;
        }
        if (!activityBlacklisted) {
            if (pendingInappRunnable != null) {
                Logger.logFine("Found a pending inapp runnable. Scheduling it");
                CleverTapAPI.getHandlerUsingMainLooper().postDelayed(pendingInappRunnable, 200L);
                pendingInappRunnable = null;
            } else {
                InAppManager.showNotificationIfAvailable(this.context);
            }
        } else {
            Logger.log("In-app notifications will not be shown for this activity (" + (activity != null ? activity.getLocalClassName() : "") + ")");
        }
        this.pushDailyEventsAsync();
        this.event.pushDeviceDetails();
        SessionManager.activityChanged(this.getCurrentActivityName());
    }

    public void activityResumed(Activity activity) {
        boolean newLaunch;
        CleverTapAPI.setAppForeground(true);
        boolean bl = newLaunch = currentActivity == null;
        if (currentActivity == null || !currentActivity.getLocalClassName().equals(activity.getLocalClassName())) {
            this.notifyActivityChanged(activity);
        }
        Logger.logFine("Background activity in foreground");
        if (newLaunch) {
            CleverTapAPI.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                @Override
                public void run() {
                    CleverTapAPI.this.pushAppLaunchedEvent("delayed generic handler");
                }
            }, 500L);
        }
    }

    private static void updateAdvertisingID(final Context context) {
        CleverTapAPI.postAsyncSafely("CleverTapAPI#updateAdvertisingID", new Runnable(){

            @Override
            public void run() {
                String advertisingID = CleverTapAPI.getAdvertisingIDSafelySync(context);
                if (advertisingID != null) {
                    googleAdID = advertisingID;
                } else {
                    Logger.logFine("Failed to update advertising ID");
                }
            }
        });
    }

    private static String getAdvertisingIDSafelySync(Context context) {
        try {
            AdvertisingIdClient.Info adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)context);
            String id = adInfo.getId();
            boolean dontTrack = adInfo.isLimitAdTrackingEnabled();
            if (dontTrack) {
                return null;
            }
            return id;
        }
        catch (Throwable t) {
            return null;
        }
    }

    JSONObject getAppLaunchedFields() {
        try {
            JSONObject evtData = new JSONObject();
            PackageInfo pInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            evtData.put("Build", (Object)(pInfo.versionCode + ""));
            evtData.put("Version", (Object)pInfo.versionName);
            evtData.put("OS Version", (Object)Build.VERSION.RELEASE);
            evtData.put("SDK Version", BuildInfo.SDK_SVN_REVISION);
            Location loc = this.getLocation();
            if (loc != null) {
                evtData.put("Latitude", loc.getLatitude());
                evtData.put("Longitude", loc.getLongitude());
            }
            if (parseInstallationId != null) {
                evtData.put("prg", (Object)parseInstallationId);
            }
            if (googleAdID != null) {
                evtData.put("GoogleAdID", (Object)googleAdID);
            }
            try {
                String make = Build.MANUFACTURER;
                String model = Build.MODEL;
                model = model.replace(make, "");
                evtData.put("Make", (Object)make.trim());
                evtData.put("Model", (Object)model.trim());
            }
            catch (Throwable t) {
                // empty catch block
            }
            return evtData;
        }
        catch (Throwable t) {
            Logger.logFine("Failed to construct App Launched event", t);
            return new JSONObject();
        }
    }

    synchronized void pushAppLaunchedEvent(String source) {
        if (SessionManager.isAppLaunchedBeenPushed()) {
            Logger.logFine("App Launched has already been triggered. Will not trigger it; source = " + source);
            return;
        }
        Logger.logFine("Firing App Launched event; source = " + source);
        SessionManager.setAppLaunchedBeenPushed(true);
        JSONObject event = new JSONObject();
        try {
            event.put("evtName", (Object)"App Launched");
            event.put("evtData", (Object)this.getAppLaunchedFields());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        QueueManager.addToQueue(this.context, event, 4);
    }

    public void flush() {
        new CommsManager().drainQueueAsync(this.context);
    }

    private boolean checkPlayServices() {
        int resultCode;
        try {
            resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.context);
        }
        catch (Throwable e) {
            resultCode = -1;
        }
        Logger.logFine("Google Play services availability: " + (resultCode == 0));
        return resultCode == 0;
    }

    void initPushHandling() {
        String senderID;
        try {
            senderID = ManifestMetaData.getMetaData(this.context, "GCM_SENDER_ID");
            if (senderID != null) {
                senderID = senderID.replace("id:", "");
            }
        }
        catch (CleverTapMetaDataNotFoundException e) {
            return;
        }
        catch (Throwable t) {
            Logger.error("Failed to automatically register to GCM", t);
            return;
        }
        Logger.log("Requesting a GCM registration ID for project ID(s) - " + senderID);
        if (this.checkPlayServices()) {
            Logger.logFine("Google Play services available. Fetching GCM token");
            this.doGcmRegistration(senderID);
        }
    }

    public String getRegistrationId() {
        SharedPreferences prefs = this.getPreferences(this.context);
        String registrationId = prefs.getString("registration_id", "");
        if (registrationId.equals("")) {
            if (CleverTapAPI.getDebugLevel() >= 1277182231) {
                Logger.logFine("GCM registration ID not found");
            }
            return "";
        }
        return registrationId;
    }

    private SharedPreferences getPreferences(Context context) {
        return StorageHelper.getPreferences(context);
    }

    private int getAppVersion() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (Throwable ignore) {
            return 0;
        }
    }

    private boolean hasAppVersionChanged() {
        SharedPreferences prefs;
        int prefsVer;
        int currentVer = this.getAppVersion();
        return currentVer != (prefsVer = (prefs = this.getPreferences(this.context)).getInt("avc", -1));
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void updateAppVersionInPrefs() {
        int currentVer = this.getAppVersion();
        SharedPreferences prefs = this.getPreferences(this.context);
        SharedPreferences.Editor editor = prefs.edit().putInt("avc", currentVer);
        StorageHelper.persist(editor);
    }

    private void doGcmRegistration(final String senderId) {
        CleverTapAPI.postAsyncSafely("CleverTapAPI#doGcmRegistration", new Runnable(){

            @Override
            public void run() {
                String existingGcmKey = CleverTapAPI.this.getRegistrationId();
                try {
                    Logger.logFine("Fetching GCM token...");
                    String gcmRegId = InstanceID.getInstance((Context)CleverTapAPI.this.context).getToken(senderId, "GCM", null);
                    if (!existingGcmKey.equals(gcmRegId)) {
                        Logger.logFine("Processing new GCM token");
                        CleverTapAPI.this.data.pushGcmRegistrationId(gcmRegId, true);
                        CleverTapAPI.this.pushedGcmId = true;
                        CleverTapAPI.this.storeRegistrationId(gcmRegId);
                    } else {
                        Logger.logFine("GCM Token unchanged");
                    }
                }
                catch (Throwable ex) {
                    Logger.logFine("Exception while registering with GCM servers: " + ex.toString());
                    ex.printStackTrace();
                }
                CleverTapAPI.getHandlerUsingMainLooper().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CleverTapAPI.this.doGcmRegistration(senderId);
                    }
                }, (long)(10000 * gcmSleepFactor));
                gcmSleepFactor = gcmSleepFactor * 2;
            }
        });
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void storeRegistrationId(String regId) {
        SharedPreferences prefs = this.getPreferences(this.context);
        int appVersion = this.getAppVersion();
        if (CleverTapAPI.getDebugLevel() > 1277182231) {
            Logger.logFine("Saving GCM registration ID on app version " + appVersion);
        }
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("registration_id", regId);
        editor.putInt(PROPERTY_APP_VERSION, appVersion);
        StorageHelper.persist(editor);
    }

    String getCurrentActivityName() {
        if (currentActivity != null) {
            return currentActivity.getLocalClassName();
        }
        return null;
    }

    public static NotificationInfo getNotificationInfo(Bundle extras) {
        if (extras == null) {
            return new NotificationInfo(false, false);
        }
        boolean fromCleverTap = extras.containsKey(NOTIFICATION_TAG);
        boolean shouldRender = fromCleverTap && extras.containsKey("nm");
        return new NotificationInfo(fromCleverTap, shouldRender);
    }

    public static void createNotification(final Context context, final Bundle extras) {
        if (extras == null || extras.get(NOTIFICATION_TAG) == null) {
            return;
        }
        try {
            CleverTapAPI.postAsyncSafely("CleverTapAPI#createNotification", new Runnable(){

                @Override
                public void run() {
                    try {
                        int smallIcon;
                        NotificationCompat.BigTextStyle style;
                        if (extras.containsKey("d") && "y".equals(extras.getString("d"))) {
                            int r = (int)(Math.random() * 10.0);
                            if (r != 8) {
                                return;
                            }
                            JSONObject event = new JSONObject();
                            try {
                                JSONObject actions = new JSONObject();
                                for (String x : extras.keySet()) {
                                    Object value = extras.get(x);
                                    actions.put(x, value);
                                }
                                event.put("evtName", (Object)"wzrk_d");
                                event.put("evtData", (Object)actions);
                                QueueManager.addToQueue(context, event, 4);
                            }
                            catch (JSONException ignored) {
                                // empty catch block
                            }
                            return;
                        }
                        String notifTitle = extras.getString("nt");
                        notifTitle = notifTitle != null ? notifTitle : context.getApplicationInfo().name;
                        String notifMessage = extras.getString("nm");
                        if (notifMessage == null) {
                            return;
                        }
                        String icoPath = extras.getString("ico");
                        Intent launchIntent = extras.containsKey("wzrk_dl") ? new Intent("android.intent.action.VIEW", Uri.parse((String)extras.getString("wzrk_dl"))) : context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
                        launchIntent.putExtras(extras);
                        launchIntent.putExtra("wzrk_rts", System.currentTimeMillis());
                        launchIntent.setFlags(0x24000000);
                        PendingIntent pIntent = PendingIntent.getActivity((Context)context, (int)((int)System.currentTimeMillis()), (Intent)launchIntent, (int)0x8000000);
                        String bigPictureUrl = extras.getString("wzrk_bp");
                        if (bigPictureUrl != null && bigPictureUrl.startsWith("http")) {
                            try {
                                Bitmap bpMap = Utils.getNotificationBitmap(bigPictureUrl, false, context);
                                if (bpMap == null) {
                                    throw new Exception("Failed to fetch big picture!");
                                }
                                style = new NotificationCompat.BigPictureStyle().setSummaryText((CharSequence)notifMessage).bigPicture(bpMap);
                            }
                            catch (Throwable t) {
                                style = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                                Logger.error("Falling back to big text notification, couldn't fetch big picture", t);
                            }
                        } else {
                            style = new NotificationCompat.BigTextStyle().bigText((CharSequence)notifMessage);
                        }
                        try {
                            String x = ManifestMetaData.getMetaData(context, "CLEVERTAP_NOTIFICATION_ICON");
                            smallIcon = context.getResources().getIdentifier(x, "drawable", context.getPackageName());
                            if (smallIcon == 0) {
                                throw new IllegalArgumentException();
                            }
                        }
                        catch (Throwable t) {
                            smallIcon = DeviceInfo.getAppIconAsIntId(context);
                        }
                        NotificationCompat.Builder nb = new NotificationCompat.Builder(context).setContentTitle((CharSequence)notifTitle).setContentText((CharSequence)notifMessage).setLargeIcon(Utils.getNotificationBitmap(icoPath, true, context)).setContentIntent(pIntent).setAutoCancel(true).setStyle((NotificationCompat.Style)style).setSmallIcon(smallIcon);
                        try {
                            Object o;
                            if (extras.containsKey("wzrk_sound") && ((o = extras.get("wzrk_sound")) instanceof String && o.equals("true") || o instanceof Boolean && ((Boolean)o).booleanValue())) {
                                Uri defaultSoundUri = RingtoneManager.getDefaultUri((int)2);
                                nb.setSound(defaultSoundUri);
                            }
                        }
                        catch (Throwable t) {
                            Logger.error("Could not process sound parameter", t);
                        }
                        Notification n = nb.build();
                        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                        notificationManager.notify((int)(Math.random() * 100.0), n);
                    }
                    catch (Throwable t) {
                        Logger.error("Couldn't render notification!", t);
                    }
                }
            });
        }
        catch (Throwable t) {
            Logger.error("Failed to process GCM notification", t);
        }
    }

    public void pushDeepLink(Uri uri) {
        this.pushDeepLink(uri, false);
    }

    synchronized void pushDeepLink(Uri uri, boolean install) {
        if (uri == null) {
            return;
        }
        try {
            JSONObject referrer = UriHelper.getUrchinFromUri(this.context, uri);
            referrer.put("referrer", (Object)uri.toString());
            if (install) {
                referrer.put("install", true);
            }
            this.event.pushDeviceDetailsWithExtras(referrer);
        }
        catch (Throwable t) {
            Logger.error("Failed to push deep link", t);
        }
    }

    public synchronized void pushInstallReferrer(String source, String medium, String campaign) {
        if (source == null && medium == null && campaign == null) {
            return;
        }
        try {
            int status = StorageHelper.getInt(this.context, "app_install_status", 0);
            if (status != 0) {
                Logger.log("Install referrer has already been set. Will not override it");
                return;
            }
            StorageHelper.putInt(this.context, "app_install_status", 1);
            if (source != null) {
                source = Uri.encode((String)source);
            }
            if (medium != null) {
                medium = Uri.encode((String)medium);
            }
            if (campaign != null) {
                campaign = Uri.encode((String)campaign);
            }
            String uriStr = "wzrk://track?install=true";
            if (source != null) {
                uriStr = uriStr + "&utm_source=" + source;
            }
            if (medium != null) {
                uriStr = uriStr + "&utm_medium=" + medium;
            }
            if (campaign != null) {
                uriStr = uriStr + "&utm_campaign=" + campaign;
            }
            Uri uri = Uri.parse((String)uriStr);
            this.pushDeepLink(uri, true);
        }
        catch (Throwable t) {
            Logger.error("Failed to push install referrer", t);
        }
    }

    public void enablePersonalization() {
        LocalDataStore.setPersonalisationEnabled(this.context, true);
    }

    public void disablePersonalization() {
        LocalDataStore.setPersonalisationEnabled(this.context, false);
    }

    public void pushInstallReferrer(Intent intent) {
        try {
            String url;
            Bundle extras = intent.getExtras();
            if (extras == null || !extras.containsKey("referrer")) {
                return;
            }
            try {
                url = URLDecoder.decode(extras.getString("referrer"), "UTF-8");
                Logger.logFine("Referrer received: " + url);
            }
            catch (Throwable e) {
                return;
            }
            if (url == null) {
                return;
            }
            int now = (int)(System.currentTimeMillis() / 1000L);
            if (installReferrerMap.containsKey(url) && now - installReferrerMap.get(url) < 10) {
                Logger.logFine("Skipping install referrer due to duplicate within 10 seconds");
                return;
            }
            installReferrerMap.put(url, now);
            Uri uri = Uri.parse((String)("wzrk://track?install=true&" + url));
            this.pushDeepLink(uri, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateLocation(Location location) {
        this.locationFromUser = location;
        Logger.logFine("Location updated (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        if (!CleverTapAPI.isAppForeground()) {
            return;
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (now > lastLocationPingTime + 10) {
            QueueManager.addToQueue(this.context, new JSONObject(), 2);
            lastLocationPingTime = now;
            Logger.logFine("Queuing location ping event for location (" + location.getLatitude() + ", " + location.getLongitude() + ")");
        }
    }

    private Location getLocation() {
        if (this.locationFromUser != null) {
            return this.locationFromUser;
        }
        boolean tryLocation = true;
        try {
            String value = ManifestMetaData.getMetaData(this.context, "CLEVERTAP_PRIVACY_MODE");
            if (value.contains("DL")) {
                tryLocation = false;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!tryLocation) {
            return null;
        }
        try {
            LocationManager lm = (LocationManager)this.context.getSystemService("location");
            List providers = lm.getProviders(true);
            Location bestLocation = null;
            for (String provider : providers) {
                Location l = lm.getLastKnownLocation(provider);
                if (l == null || bestLocation != null && !(l.getAccuracy() < bestLocation.getAccuracy())) continue;
                bestLocation = l;
            }
            return bestLocation;
        }
        catch (Throwable t) {
            Logger.logFine("Couldn't get user's location", t);
            return null;
        }
    }

    Context getContext() {
        return this.context;
    }

    public String getCleverTapID() {
        return DeviceInfo.getDeviceID(this.context);
    }

    static {
        parseInstallationId = null;
        googleAdID = null;
        inappActivityExclude = null;
        gcmSleepFactor = 1;
        installReferrerMap = new HashMap(8);
    }
}

