/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Provides methods to manage the GCM preferences.
 */
public final class GcmManager {
    /**
     * Enables or disables the GCM push notifications.
     *
     * @param context Android context
     * @param enable  True to enable, and false to disable
     */
    public static void enableGcmPushNotifications(Context context, boolean enable) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        SharedPreferences.Editor editor = prefs.edit().putBoolean(Constants.GCM_ENABLE, enable);
        StorageHelper.persist(editor);
    }

    public static boolean isGcmEnabled(Context context) {
        SharedPreferences prefs = StorageHelper.getPreferences(context);
        return prefs.getBoolean(Constants.GCM_ENABLE, false);
    }
}
