/*
 * Author: Jude Pereira
 * Copyright (c) 2014
 */

package com.clevertap.android.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.widget.ImageView;

import java.io.IOException;
import java.io.InputStream;

/**
 * Represents the close button.
 */
final class CloseImageView extends ImageView {
    public CloseImageView(Context context) {
        super(context);
        setId(199272);
    }

    public CloseImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        setId(199272);
    }

    public CloseImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        setId(199272);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        // The image view is fixed in dip on all devices
        setMeasuredDimension(canvasSize, canvasSize);
    }

    @SuppressLint("DrawAllocation")
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        InputStream is = null;
        try {
            is = getClass().getClassLoader()
                    .getResourceAsStream("com/clevertap/android/sdk/images/close.png");
            Bitmap closeBitmap = BitmapFactory.decodeStream(is);
            Bitmap scaledCloseBitmap = Bitmap.createScaledBitmap(closeBitmap,
                    canvasSize, canvasSize, true);
            canvas.drawBitmap(scaledCloseBitmap, 0, 0, new Paint());
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
            } catch (IOException e) {
                // ignore
            }
        }
    }

    private final int canvasSize = getScaledPixels(Constants.INAPP_CLOSE_IV_WIDTH);

    private int getScaledPixels(int raw) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,
                raw, getResources().getDisplayMetrics());
    }
}
