/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization.utils;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.Method;

public class SystemPropertiesProxy {
    private static final String TAG = "SystemPropertiesProxy";

    public static Boolean getBoolean(Context context, String key, boolean def) throws IllegalArgumentException {
        return SystemPropertiesProxy.getBoolean(context.getClassLoader(), key, def);
    }

    public static Boolean getBoolean(ClassLoader cl, String key, boolean def) throws IllegalArgumentException {
        Boolean ret = def;
        try {
            Class<?> SystemProperties = cl.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class, Boolean.TYPE};
            Method getBoolean = SystemProperties.getMethod("getBoolean", paramTypes);
            Object[] params = new Object[]{new String(key), def};
            ret = (Boolean)getBoolean.invoke(SystemProperties, params);
        }
        catch (IllegalArgumentException iAE) {
            throw iAE;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getBoolean(context, key: " + key + ", def:" + def + ")"), (Throwable)e);
            ret = def;
        }
        return ret;
    }
}

