/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.audiofx.Visualizer;
import android.support.annotation.NonNull;
import com.cleveroad.audiovisualization.Utils;
import com.cleveroad.audiovisualization.utils.TunnelPlayerWorkaround;

class VisualizerWrapper {
    private static final long WAIT_UNTIL_HACK = 500L;
    private Visualizer visualizer;
    private MediaPlayer mSilentPlayer;
    private Visualizer.OnDataCaptureListener captureListener;
    private int captureRate;
    private long lastZeroArrayTimestamp;

    public VisualizerWrapper(@NonNull Context context, int audioSessionId, final @NonNull OnFftDataCaptureListener onFftDataCaptureListener) {
        this.initTunnelPlayerWorkaround(context);
        this.visualizer = new Visualizer(audioSessionId);
        this.visualizer.setEnabled(false);
        this.visualizer.setCaptureSize(Visualizer.getCaptureSizeRange()[1]);
        this.captureRate = Visualizer.getMaxCaptureRate();
        this.captureListener = new Visualizer.OnDataCaptureListener(){

            public void onWaveFormDataCapture(Visualizer visualizer, byte[] waveform, int samplingRate) {
            }

            public void onFftDataCapture(Visualizer visualizer, byte[] fft, int samplingRate) {
                boolean allZero = Utils.allElementsAreZero(fft);
                if (VisualizerWrapper.this.lastZeroArrayTimestamp == 0L) {
                    if (allZero) {
                        VisualizerWrapper.this.lastZeroArrayTimestamp = System.currentTimeMillis();
                    }
                } else if (!allZero) {
                    VisualizerWrapper.this.lastZeroArrayTimestamp = 0L;
                } else if (System.currentTimeMillis() - VisualizerWrapper.this.lastZeroArrayTimestamp >= 500L) {
                    VisualizerWrapper.this.setEnabled(true);
                    VisualizerWrapper.this.lastZeroArrayTimestamp = 0L;
                }
                onFftDataCaptureListener.onFftDataCapture(fft);
            }
        };
        this.visualizer.setEnabled(true);
    }

    private void initTunnelPlayerWorkaround(@NonNull Context context) {
        if (TunnelPlayerWorkaround.isTunnelDecodeEnabled(context)) {
            this.mSilentPlayer = TunnelPlayerWorkaround.createSilentMediaPlayer(context);
        }
    }

    public void release() {
        this.visualizer.setEnabled(false);
        this.visualizer.release();
        this.visualizer = null;
        if (this.mSilentPlayer != null) {
            this.mSilentPlayer.release();
            this.mSilentPlayer = null;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.visualizer == null) {
            return;
        }
        this.visualizer.setEnabled(false);
        if (enabled) {
            this.visualizer.setDataCaptureListener(this.captureListener, this.captureRate, false, true);
        } else {
            this.visualizer.setDataCaptureListener(null, this.captureRate, false, false);
        }
        this.visualizer.setEnabled(true);
    }

    public static interface OnFftDataCaptureListener {
        public void onFftDataCapture(byte[] var1);
    }
}

