/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import com.cleveroad.audiovisualization.GLAudioVisualizationView;
import com.cleveroad.audiovisualization.GLBubble;
import com.cleveroad.audiovisualization.GLRectangle;
import com.cleveroad.audiovisualization.GLShape;
import com.cleveroad.audiovisualization.GLWave;
import com.cleveroad.audiovisualization.Utils;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

class GLWaveLayer {
    private final GLAudioVisualizationView.Configuration configuration;
    private final GLWave[] waves;
    private final GLRectangle rectangle;
    private final Random random;
    private final float bubbleFromY;
    private final float bubbleToY;
    private float amplitude;
    private final Set<GLBubble> usedBubbles;
    private final Queue<GLBubble> unusedBubbles;
    private final Set<GLBubble> producedBubbles;
    private boolean isCalmedDown;
    private final GLBubble[] allBubbles;

    public GLWaveLayer(GLAudioVisualizationView.Configuration configuration, float[] color2, float fromY, float toY, Random random) {
        this.configuration = configuration;
        this.random = random;
        this.waves = new GLWave[configuration.wavesCount];
        float footerToY = fromY + configuration.footerHeight / (configuration.footerHeight + configuration.waveHeight * 2.0f) * (toY - fromY);
        this.rectangle = new GLRectangle(color2, -1.0f, 1.0f, fromY, footerToY);
        float waveWidth = 2.0f / (float)configuration.wavesCount;
        float[] points = GLWaveLayer.randomPoints(this.random, configuration.wavesCount, waveWidth, 0.15f);
        this.bubbleFromY = footerToY;
        this.bubbleToY = toY;
        for (int i = 0; i < configuration.wavesCount; ++i) {
            byte direction = i % 2 == 0 ? (byte)0 : 1;
            this.waves[i] = new GLWave(color2, points[i], points[i + 1], footerToY, toY, direction, random);
        }
        this.usedBubbles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.producedBubbles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.unusedBubbles = new ConcurrentLinkedQueue<GLBubble>();
        this.allBubbles = this.generateBubbles(color2, configuration.bubblesPerLayer);
        Collections.addAll(this.unusedBubbles, this.allBubbles);
    }

    private static float[] randomPoints(Random random, int wavesCount, float width, float shiftCoef) {
        float[] points = new float[wavesCount + 1];
        for (int i = 0; i < points.length; ++i) {
            if (i == 0) {
                points[i] = -1.0f;
                continue;
            }
            if (i == points.length - 1) {
                points[i] = 1.0f;
                continue;
            }
            float shift = random.nextFloat() * shiftCoef * width;
            points[i] = -1.0f + (float)i * width + (shift *= random.nextBoolean() ? 1.0f : -1.0f);
        }
        return points;
    }

    public void update(long dt, float dAngle, float ratioY) {
        float d = (float)dt * dAngle;
        this.isCalmedDown = true;
        for (GLWave wave : this.waves) {
            wave.update(d);
            this.isCalmedDown &= wave.isCalmedDown();
        }
        this.usedBubbles.addAll(this.producedBubbles);
        this.producedBubbles.clear();
        Iterator<GLBubble> iterator = this.usedBubbles.iterator();
        while (iterator.hasNext()) {
            GLBubble bubble = iterator.next();
            bubble.update(dt, ratioY);
            if (!bubble.isOffScreen()) continue;
            this.unusedBubbles.add(bubble);
            iterator.remove();
        }
    }

    public boolean isCalmedDown() {
        return this.isCalmedDown;
    }

    public void draw() {
        for (GLWave wave : this.waves) {
            wave.draw();
        }
        this.rectangle.draw();
        for (GLBubble bubble : this.usedBubbles) {
            bubble.draw();
        }
    }

    public void updateData(float heightCoefficient, float amplitude) {
        for (GLWave wave : this.waves) {
            wave.setCoefficient(Utils.randomize(heightCoefficient, this.random));
        }
        if (amplitude > this.amplitude) {
            this.amplitude = amplitude;
            if (heightCoefficient > 0.25f) {
                this.produceBubbles();
            }
        } else {
            this.amplitude = Utils.smooth(this.amplitude, amplitude, 0.8f);
        }
    }

    private void produceBubbles() {
        int bubblesCount = this.random.nextInt(3);
        for (int i = 0; i < bubblesCount; ++i) {
            GLBubble bubble = this.unusedBubbles.poll();
            if (bubble == null) continue;
            float shift = this.random.nextFloat() * 0.1f * (float)(this.random.nextBoolean() ? 1 : -1);
            float size = this.configuration.bubbleSize;
            if (this.configuration.randomizeBubbleSize) {
                size *= 0.5f + this.random.nextFloat() * 0.8f;
            }
            bubble.update(-1.0f + this.random.nextFloat() * 2.0f, this.bubbleFromY + shift, this.bubbleToY, size);
            this.producedBubbles.add(bubble);
        }
    }

    private GLBubble[] generateBubbles(float[] color2, int count) {
        GLBubble[] bubbles = new GLBubble[count];
        for (int i = 0; i < count; ++i) {
            float size = this.configuration.bubbleSize;
            if (this.configuration.randomizeBubbleSize) {
                size *= 0.5f + this.random.nextFloat() * 0.8f;
            }
            float shift = this.random.nextFloat() * 0.1f * (float)(this.random.nextBoolean() ? 1 : -1);
            float[] col = new float[color2.length];
            System.arraycopy(color2, 0, col, 0, col.length);
            bubbles[i] = new GLBubble(col, -1.0f + this.random.nextFloat() * 2.0f, this.bubbleFromY + shift, this.bubbleToY, size, this.random);
        }
        return bubbles;
    }

    public void setColor(float[] color2) {
        this.rectangle.setColor(color2);
        for (GLWave gLWave : this.waves) {
            gLWave.setColor(color2);
        }
        for (GLShape gLShape : this.allBubbles) {
            gLShape.setColor(color2);
        }
    }
}

