/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.opengl.GLES20;
import com.cleveroad.audiovisualization.GLRenderer;

abstract class GLShape {
    protected static final String VERTEX_POSITION = "vPosition";
    protected static final String VERTEX_COLOR = "vColor";
    private static final String VERTEX_SHADER_CODE = "attribute vec4 vPosition;void main() {  gl_Position = vPosition;}";
    private static final String FRAGMENT_SHADER_CODE = "precision mediump float;uniform vec4 vColor;void main() {  gl_FragColor = vColor;}";
    protected static final int COORDS_PER_VERTEX = 3;
    protected static final int SIZE_OF_FLOAT = 4;
    protected static final int SIZE_OF_SHORT = 2;
    private final float[] color;
    private final int program;

    public GLShape(float[] color2) {
        this.color = color2;
        int vertexShader = GLRenderer.loadShader(35633, VERTEX_SHADER_CODE);
        int fragmentShader = GLRenderer.loadShader(35632, FRAGMENT_SHADER_CODE);
        this.program = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.program, (int)vertexShader);
        GLES20.glAttachShader((int)this.program, (int)fragmentShader);
        GLES20.glLinkProgram((int)this.program);
    }

    protected float[] getColor() {
        return this.color;
    }

    protected int getProgram() {
        return this.program;
    }

    public void setColor(float[] color2) {
        System.arraycopy(color2, 0, this.color, 0, this.color.length);
    }
}

