/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.content.Context;
import android.opengl.GLES20;
import android.support.annotation.NonNull;
import com.cleveroad.audiovisualization.GLAudioVisualizationView;
import com.cleveroad.audiovisualization.GLWaveLayer;
import com.cleveroad.audiovisualization.InnerAudioVisualization;
import java.util.Random;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class GLRenderer
implements GLAudioVisualizationView.AudioVisualizationRenderer {
    private static final long ANIMATION_TIME = 400L;
    private static final float D_ANGLE = 0.015707964f;
    private final GLAudioVisualizationView.Configuration configuration;
    private GLWaveLayer[] layers;
    private long startTime;
    private final float height;
    private final Random random;
    private float ratioY = 1.0f;
    private InnerAudioVisualization.CalmDownListener calmDownListener;
    boolean bgUpdated;

    public GLRenderer(@NonNull Context context, GLAudioVisualizationView.Configuration configuration) {
        this.configuration = configuration;
        this.random = new Random();
        this.startTime = System.currentTimeMillis();
        this.height = context.getResources().getDisplayMetrics().heightPixels;
    }

    public GLRenderer calmDownListener(InnerAudioVisualization.CalmDownListener calmDownListener) {
        this.calmDownListener = calmDownListener;
        return this;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        float[] backgroundColor = this.configuration.backgroundColor;
        GLES20.glClearColor((float)backgroundColor[0], (float)backgroundColor[1], (float)backgroundColor[2], (float)backgroundColor[3]);
        this.layers = new GLWaveLayer[this.configuration.layersCount];
        float layerHeightPerc = (this.configuration.footerHeight + this.configuration.waveHeight) / this.height;
        float waveHeightPerc = this.configuration.waveHeight / this.height * 2.0f;
        for (int i = 0; i < this.layers.length; ++i) {
            int reverseI = this.layers.length - i - 1;
            float fromY = -1.0f + (float)reverseI * waveHeightPerc * 2.0f;
            float toY = fromY + layerHeightPerc * 2.0f;
            this.layers[i] = new GLWaveLayer(this.configuration, this.configuration.layerColors[i], fromY, toY, this.random);
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        this.ratioY = (float)width / (float)height;
    }

    public void onDrawFrame(GL10 gl) {
        if (this.bgUpdated) {
            float[] backgroundColor = this.configuration.backgroundColor;
            GLES20.glClearColor((float)backgroundColor[0], (float)backgroundColor[1], (float)backgroundColor[2], (float)backgroundColor[3]);
            this.bgUpdated = false;
        } else {
            GLES20.glClear((int)16640);
        }
        long endTime = System.currentTimeMillis();
        long dt = endTime - this.startTime;
        this.startTime = endTime;
        int i = 0;
        boolean isCalmedDown = true;
        for (GLWaveLayer layer : this.layers) {
            float speedCoef = 1.0f - 1.0f * (float)i / (float)this.layers.length * 0.8f;
            layer.update(dt, 0.015707964f * speedCoef, this.ratioY);
            isCalmedDown &= layer.isCalmedDown();
            ++i;
        }
        for (GLWaveLayer layer : this.layers) {
            layer.draw();
        }
        if (isCalmedDown && this.calmDownListener != null) {
            this.calmDownListener.onCalmedDown();
        }
    }

    public final void onDataReceived(float[] dBmArray, float[] ampsArray) {
        if (this.layers == null) {
            return;
        }
        for (int i = 0; i < this.layers.length; ++i) {
            if (this.layers[i] == null) {
                return;
            }
            this.layers[i].updateData(dBmArray[i], ampsArray[i]);
        }
    }

    public static int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        GLES20.glShaderSource((int)shader, (String)shaderCode);
        GLES20.glCompileShader((int)shader);
        return shader;
    }

    @Override
    public void updateConfiguration(@NonNull GLAudioVisualizationView.ColorsBuilder builder) {
        float[] bgColor = this.configuration.backgroundColor;
        float[] backgroundColor = builder.backgroundColor();
        this.bgUpdated = false;
        for (int i = 0; i < 4; ++i) {
            this.bgUpdated |= Float.compare(bgColor[i], backgroundColor[i]) != 0;
        }
        if (this.bgUpdated) {
            this.configuration.backgroundColor = builder.backgroundColor();
        }
        if (this.layers == null) {
            return;
        }
        float[][] colors = builder.layerColors();
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i].setColor(colors[i]);
        }
    }
}

