/*
 * Decompiled with CFR 0.152.
 */
package com.cleveroad.audiovisualization;

import android.opengl.GLES20;
import com.cleveroad.audiovisualization.GLShape;
import com.cleveroad.audiovisualization.Utils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Random;

class GLBubble
extends GLShape {
    private static final long BUBBLE_ANIMATION_DURATION = 1000L;
    private static final float BUBBLE_D_ANGLE = 0.0062831854f;
    private static final int POINTS_PER_CIRCLE = 40;
    private static final float TOP_Y = 1.0f;
    private final FloatBuffer vertexBuffer;
    private final ShortBuffer shortBuffer;
    private final Random random;
    private float fromY;
    private float size;
    private float speed;
    private float virtualSpeed;
    private float centerY = -1.0f;
    private float startX;
    private float angle;

    public GLBubble(float[] color2, float startX, float fromY, float toY, float size, Random random) {
        super(color2);
        int i;
        this.random = random;
        this.update(startX, fromY, toY, size);
        float[] vertices = new float[123];
        short[] indices = new short[120];
        for (i = 0; i < indices.length / 3 - 1; ++i) {
            indices[3 * i] = 0;
            indices[3 * i + 1] = (short)(i + 1);
            indices[3 * i + 2] = (short)(i + 2);
        }
        indices[3 * i] = 0;
        indices[3 * i + 1] = (short)(i + 1);
        indices[3 * i + 2] = 1;
        ByteBuffer verticesByteBuffer = ByteBuffer.allocateDirect(vertices.length * 4);
        verticesByteBuffer.order(ByteOrder.nativeOrder());
        this.vertexBuffer = verticesByteBuffer.asFloatBuffer();
        this.vertexBuffer.put(vertices);
        this.vertexBuffer.position(0);
        ByteBuffer indicesByteBuffer = ByteBuffer.allocateDirect(indices.length * 2);
        indicesByteBuffer.order(ByteOrder.nativeOrder());
        this.shortBuffer = indicesByteBuffer.asShortBuffer();
        this.shortBuffer.put(indices);
        this.shortBuffer.position(0);
        this.angle = (float)((double)(random.nextFloat() * 2.0f) * Math.PI);
    }

    public void update(long dt, float ratioY) {
        double step = 0.15707963267948966;
        this.angle += (float)dt * 0.0062831854f;
        float fromX = this.startX + (float)((double)0.05f * Math.sin(this.angle));
        float toX = fromX + this.size;
        float fromY = this.fromY + (float)dt * this.speed;
        float toY = fromY + this.size;
        this.centerY += (float)dt * this.virtualSpeed;
        this.getColor()[3] = 1.0f - this.centerY / 1.0f;
        this.vertexBuffer.put(0, Utils.normalizeGl(0.0f, fromX, toX));
        this.vertexBuffer.put(1, Utils.normalizeGl(this.centerY * ratioY, fromY, toY));
        for (int i = 1; i <= 40; ++i) {
            this.vertexBuffer.put(3 * i, Utils.normalizeGl((float)Math.sin(-Math.PI + step * (double)i), fromX, toX));
            this.vertexBuffer.put(3 * i + 1, Utils.normalizeGl((float)Math.cos(-Math.PI + step * (double)i) * ratioY, fromY, toY));
        }
        this.fromY = fromY;
    }

    public void draw() {
        GLES20.glUseProgram((int)this.getProgram());
        int positionHandle = GLES20.glGetAttribLocation((int)this.getProgram(), (String)"vPosition");
        GLES20.glEnableVertexAttribArray((int)positionHandle);
        GLES20.glVertexAttribPointer((int)positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.vertexBuffer);
        int colorHandle = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vColor");
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        GLES20.glUniform4fv((int)colorHandle, (int)1, (float[])this.getColor(), (int)0);
        GLES20.glDrawElements((int)6, (int)this.shortBuffer.capacity(), (int)5123, (Buffer)this.shortBuffer);
        GLES20.glDisableVertexAttribArray((int)positionHandle);
        GLES20.glDisable((int)3042);
    }

    public boolean isOffScreen() {
        return this.centerY > 1.0f;
    }

    public void update(float startX, float fromY, float toY, float size) {
        this.fromY = fromY;
        this.size = size;
        this.startX = startX;
        this.centerY = -1.0f;
        float coef = 0.4f + this.random.nextFloat() * 0.8f;
        this.speed = (toY - fromY) / 1000.0f * coef;
        this.virtualSpeed = 0.002f * coef;
        this.getColor()[3] = 1.0f;
    }
}

