/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.frequency;

import com.clearspring.analytics.stream.frequency.FrequencyMergeException;
import com.clearspring.analytics.stream.frequency.IFrequency;
import com.clearspring.analytics.stream.membership.Filter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class CountMinSketch
implements IFrequency,
Serializable {
    public static final long PRIME_MODULUS = Integer.MAX_VALUE;
    private static final long serialVersionUID = -5084982213094657923L;
    int depth;
    int width;
    long[][] table;
    long[] hashA;
    long size;
    double eps;
    double confidence;

    CountMinSketch() {
    }

    public CountMinSketch(int depth, int width, int seed) {
        this.depth = depth;
        this.width = width;
        this.eps = 2.0 / (double)width;
        this.confidence = 1.0 - 1.0 / Math.pow(2.0, depth);
        this.initTablesWith(depth, width, seed);
    }

    public CountMinSketch(double epsOfTotalCount, double confidence, int seed) {
        this.eps = epsOfTotalCount;
        this.confidence = confidence;
        this.width = (int)Math.ceil(2.0 / epsOfTotalCount);
        this.depth = (int)Math.ceil(-Math.log(1.0 - confidence) / Math.log(2.0));
        this.initTablesWith(this.depth, this.width, seed);
    }

    CountMinSketch(int depth, int width, int size, long[] hashA, long[][] table) {
        this.depth = depth;
        this.width = width;
        this.eps = 2.0 / (double)width;
        this.confidence = 1.0 - 1.0 / Math.pow(2.0, depth);
        this.hashA = hashA;
        this.table = table;
        this.size = size;
    }

    private void initTablesWith(int depth, int width, int seed) {
        this.table = new long[depth][width];
        this.hashA = new long[depth];
        Random r = new Random(seed);
        for (int i = 0; i < depth; ++i) {
            this.hashA[i] = r.nextInt(Integer.MAX_VALUE);
        }
    }

    public double getRelativeError() {
        return this.eps;
    }

    public double getConfidence() {
        return this.confidence;
    }

    int hash(long item, int i) {
        long hash = this.hashA[i] * item;
        hash += hash >> 32;
        return (int)(hash &= Integer.MAX_VALUE) % this.width;
    }

    @Override
    public void add(long item, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        for (int i = 0; i < this.depth; ++i) {
            long[] lArray = this.table[i];
            int n = this.hash(item, i);
            lArray[n] = lArray[n] + count;
        }
        this.size += count;
    }

    @Override
    public void add(String item, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("Negative increments not implemented");
        }
        int[] buckets = Filter.getHashBuckets(item, this.depth, this.width);
        for (int i = 0; i < this.depth; ++i) {
            long[] lArray = this.table[i];
            int n = buckets[i];
            lArray[n] = lArray[n] + count;
        }
        this.size += count;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long estimateCount(long item) {
        long res = Long.MAX_VALUE;
        for (int i = 0; i < this.depth; ++i) {
            res = Math.min(res, this.table[i][this.hash(item, i)]);
        }
        return res;
    }

    @Override
    public long estimateCount(String item) {
        long res = Long.MAX_VALUE;
        int[] buckets = Filter.getHashBuckets(item, this.depth, this.width);
        for (int i = 0; i < this.depth; ++i) {
            res = Math.min(res, this.table[i][buckets[i]]);
        }
        return res;
    }

    public static CountMinSketch merge(CountMinSketch ... estimators) throws CMSMergeException {
        CountMinSketch merged = null;
        if (estimators != null && estimators.length > 0) {
            int depth = estimators[0].depth;
            int width = estimators[0].width;
            long[] hashA = Arrays.copyOf(estimators[0].hashA, estimators[0].hashA.length);
            long[][] table = new long[depth][width];
            int size = 0;
            for (CountMinSketch estimator : estimators) {
                if (estimator.depth != depth) {
                    throw new CMSMergeException("Cannot merge estimators of different depth");
                }
                if (estimator.width != width) {
                    throw new CMSMergeException("Cannot merge estimators of different width");
                }
                if (!Arrays.equals(estimator.hashA, hashA)) {
                    throw new CMSMergeException("Cannot merge estimators of different seed");
                }
                for (int i = 0; i < table.length; ++i) {
                    for (int j = 0; j < table[i].length; ++j) {
                        long[] lArray = table[i];
                        int n = j;
                        lArray[n] = lArray[n] + estimator.table[i][j];
                    }
                }
                size = (int)((long)size + estimator.size);
            }
            merged = new CountMinSketch(depth, width, size, hashA, table);
        }
        return merged;
    }

    public static byte[] serialize(CountMinSketch sketch) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream s = new DataOutputStream(bos);
        try {
            s.writeLong(sketch.size);
            s.writeInt(sketch.depth);
            s.writeInt(sketch.width);
            for (int i = 0; i < sketch.depth; ++i) {
                s.writeLong(sketch.hashA[i]);
                for (int j = 0; j < sketch.width; ++j) {
                    s.writeLong(sketch.table[i][j]);
                }
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CountMinSketch deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream s = new DataInputStream(bis);
        try {
            CountMinSketch sketch = new CountMinSketch();
            sketch.size = s.readLong();
            sketch.depth = s.readInt();
            sketch.width = s.readInt();
            sketch.eps = 2.0 / (double)sketch.width;
            sketch.confidence = 1.0 - 1.0 / Math.pow(2.0, sketch.depth);
            sketch.hashA = new long[sketch.depth];
            sketch.table = new long[sketch.depth][sketch.width];
            for (int i = 0; i < sketch.depth; ++i) {
                sketch.hashA[i] = s.readLong();
                for (int j = 0; j < sketch.width; ++j) {
                    sketch.table[i][j] = s.readLong();
                }
            }
            return sketch;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class CMSMergeException
    extends FrequencyMergeException {
        public CMSMergeException(String message) {
            super(message);
        }
    }
}

