/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.quantile;

import com.clearspring.analytics.stream.quantile.IQuantileEstimator;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class QDigest
implements IQuantileEstimator {
    private static final Comparator<long[]> RANGES_COMPARATOR = new Comparator<long[]>(){

        @Override
        public int compare(long[] ra, long[] rb) {
            long rightA = ra[1];
            long rightB = rb[1];
            long sizeA = ra[1] - ra[0];
            long sizeB = rb[1] - rb[0];
            if (rightA < rightB) {
                return -1;
            }
            if (rightA > rightB) {
                return 1;
            }
            if (sizeA < sizeB) {
                return -1;
            }
            if (sizeA > sizeB) {
                return 1;
            }
            return 0;
        }
    };
    private static final int MAP_INITIAL_SIZE = 16;
    private static final float MAP_LOAD_FACTOR = 0.25f;
    private long size;
    private long capacity = 1L;
    private double compressionFactor;
    private Long2LongOpenHashMap node2count = new Long2LongOpenHashMap(16, 0.25f);

    public QDigest(double compressionFactor) {
        this.compressionFactor = compressionFactor;
    }

    private long value2leaf(long x) {
        return this.capacity + x;
    }

    private long leaf2value(long id) {
        return id - this.capacity;
    }

    private boolean isRoot(long id) {
        return id == 1L;
    }

    private boolean isLeaf(long id) {
        return id >= this.capacity;
    }

    private long sibling(long id) {
        return id % 2L == 0L ? id + 1L : id - 1L;
    }

    private long parent(long id) {
        return id / 2L;
    }

    private long leftChild(long id) {
        return 2L * id;
    }

    private long rightChild(long id) {
        return 2L * id + 1L;
    }

    private long rangeLeft(long id) {
        while (!this.isLeaf(id)) {
            id = this.leftChild(id);
        }
        return this.leaf2value(id);
    }

    private long rangeRight(long id) {
        while (!this.isLeaf(id)) {
            id = this.rightChild(id);
        }
        return this.leaf2value(id);
    }

    @Override
    public void offer(long value) {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Can only accept values in the range 0..4611686018427387903, got " + value);
        }
        if (value >= this.capacity) {
            this.rebuildToCapacity(Long.highestOneBit(value) << 1);
        }
        long leaf = this.value2leaf(value);
        this.node2count.addTo(leaf, 1L);
        ++this.size;
        this.compressUpward(leaf);
        if ((double)this.node2count.size() > 3.0 * this.compressionFactor) {
            this.compressFully();
        }
    }

    public static QDigest unionOf(QDigest a, QDigest b) {
        long k;
        if (a.compressionFactor != b.compressionFactor) {
            throw new IllegalArgumentException("Compression factors must be the same: left is " + a.compressionFactor + ", " + "right is " + b.compressionFactor);
        }
        if (a.capacity > b.capacity) {
            return QDigest.unionOf(b, a);
        }
        QDigest res = new QDigest(a.compressionFactor);
        res.capacity = a.capacity;
        res.size = a.size + b.size;
        Iterator i$ = a.node2count.keySet().iterator();
        while (i$.hasNext()) {
            k = (Long)i$.next();
            res.node2count.put(k, a.node2count.get(k));
        }
        if (b.capacity > res.capacity) {
            res.rebuildToCapacity(b.capacity);
        }
        i$ = b.node2count.keySet().iterator();
        while (i$.hasNext()) {
            k = (Long)i$.next();
            res.node2count.put(k, b.get(k) + res.get(k));
        }
        res.compressFully();
        return res;
    }

    private void rebuildToCapacity(long newCapacity) {
        Long2LongOpenHashMap newNode2count = new Long2LongOpenHashMap(16, 0.25f);
        long scaleR = newCapacity / this.capacity - 1L;
        Object[] keys = (Long[])this.node2count.keySet().toArray((Object[])new Long[this.node2count.size()]);
        Arrays.sort(keys);
        long scaleL = 1L;
        Object[] arr$ = keys;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long k = (Long)arr$[i$];
            while (scaleL <= k / 2L) {
                scaleL <<= 1;
            }
            newNode2count.put(k + scaleL * scaleR, this.node2count.get(k));
        }
        this.node2count = newNode2count;
        this.capacity = newCapacity;
        this.compressFully();
    }

    private void compressFully() {
        Long[] allNodes;
        Long[] arr$ = allNodes = (Long[])this.node2count.keySet().toArray((Object[])new Long[this.node2count.size()]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long node = arr$[i$];
            this.compressDownward(node);
        }
    }

    private void compressUpward(long node) {
        long atParent;
        long atSibling;
        double threshold = Math.floor((double)this.size / this.compressionFactor);
        long atNode = this.get(node);
        while (!(this.isRoot(node) || (double)atNode > threshold || (double)(atNode + (atSibling = this.get(this.sibling(node)))) > threshold || (double)(atNode + atSibling + (atParent = this.get(this.parent(node)))) > threshold)) {
            this.node2count.addTo(this.parent(node), atNode + atSibling);
            this.node2count.remove(node);
            if (atSibling > 0L) {
                this.node2count.remove(this.sibling(node));
            }
            node = this.parent(node);
            atNode = atParent + atNode + atSibling;
        }
    }

    private void compressDownward(long seedNode) {
        double threshold = Math.floor((double)this.size / this.compressionFactor);
        LongArrayFIFOQueue q = new LongArrayFIFOQueue();
        q.enqueue(seedNode);
        while (!q.isEmpty()) {
            long atParent;
            long node = q.dequeueLong();
            long atNode = this.get(node);
            long atSibling = this.get(this.sibling(node));
            if (atNode == 0L && atSibling == 0L || (double)((atParent = this.get(this.parent(node))) + atNode + atSibling) > threshold) continue;
            this.node2count.addTo(this.parent(node), atNode + atSibling);
            this.node2count.remove(node);
            this.node2count.remove(this.sibling(node));
            if (this.isLeaf(node)) continue;
            q.enqueue(this.leftChild(node));
            q.enqueue(this.leftChild(this.sibling(node)));
        }
    }

    private long get(long node) {
        return this.node2count.get(node);
    }

    @Override
    public long getQuantile(double q) {
        List<long[]> ranges = this.toAscRanges();
        long s = 0L;
        for (long[] r : ranges) {
            if (!((double)(s += r[2]) > q * (double)this.size)) continue;
            return r[1];
        }
        return ranges.get(ranges.size() - 1)[1];
    }

    public List<long[]> toAscRanges() {
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        Iterator i$ = this.node2count.keySet().iterator();
        while (i$.hasNext()) {
            long key = (Long)i$.next();
            ranges.add(new long[]{this.rangeLeft(key), this.rangeRight(key), this.node2count.get(key)});
        }
        Collections.sort(ranges, RANGES_COMPARATOR);
        return ranges;
    }

    public static byte[] serialize(QDigest d) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream s = new DataOutputStream(bos);
        try {
            s.writeLong(d.size);
            s.writeDouble(d.compressionFactor);
            s.writeLong(d.capacity);
            s.writeInt(d.node2count.size());
            Iterator i$ = d.node2count.keySet().iterator();
            while (i$.hasNext()) {
                long k = (Long)i$.next();
                s.writeLong(k);
                s.writeLong(d.node2count.get(k));
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static QDigest deserialize(byte[] b) {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        DataInputStream s = new DataInputStream(bis);
        try {
            long size = s.readLong();
            double compressionFactor = s.readLong();
            long capacity = s.readLong();
            int count = s.readInt();
            QDigest d = new QDigest(compressionFactor);
            d.size = size;
            d.capacity = capacity;
            for (int i = 0; i < count; ++i) {
                long k = s.readLong();
                long n = s.readLong();
                d.node2count.put(k, n);
            }
            return d;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

