/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.hash;

public class MurmurHash {
    public static int hash(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Long) {
            return MurmurHash.hashLong((Long)o);
        }
        if (o instanceof Integer) {
            return MurmurHash.hashLong(((Integer)o).intValue());
        }
        if (o instanceof Double) {
            return MurmurHash.hashLong(Double.doubleToRawLongBits((Double)o));
        }
        if (o instanceof Float) {
            return MurmurHash.hashLong(Float.floatToRawIntBits(((Float)o).floatValue()));
        }
        if (o instanceof String) {
            return MurmurHash.hash(((String)o).getBytes());
        }
        return MurmurHash.hash(o.toString());
    }

    public static int hash(byte[] data) {
        return MurmurHash.hash(data, data.length, -1);
    }

    public static int hash(byte[] data, int seed) {
        return MurmurHash.hash(data, data.length, seed);
    }

    public static int hash(byte[] data, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[length - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static int hashLong(long data) {
        int m = 1540483477;
        int r = 24;
        int h = 0;
        int k = (int)data * m;
        k ^= k >>> r;
        h ^= k * m;
        k = (int)(data >> 32) * m;
        k ^= k >>> r;
        h *= m;
        h ^= k * m;
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }
}

