/*
 * Decompiled with CFR 0.152.
 */
package com.classic.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.classic.common.R;

public class MultipleStatusView
extends RelativeLayout {
    public static final int STATUS_CONTENT = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_EMPTY = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_NO_NETWORK = 4;
    private static final int NULL_RESOURCE_ID = -1;
    private View emptyView;
    private View errorView;
    private View loadingView;
    private View noNetworkView;
    private View contentView;
    private View emptyRetryView;
    private View errorRetryView;
    private View noNetworkRetryView;
    private int emptyViewResId;
    private int errorViewResId;
    private int loadingViewResId;
    private int noNetworkViewResId;
    private int contentViewResId;
    private int viewStatus;
    private LayoutInflater inflater;
    private View.OnClickListener onRetryClickListener;
    private final ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);

    public MultipleStatusView(Context context) {
        this(context, null);
    }

    public MultipleStatusView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultipleStatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MultipleStatusView, defStyleAttr, 0);
        this.emptyViewResId = a.getResourceId(R.styleable.MultipleStatusView_emptyView, R.layout.empty_view);
        this.errorViewResId = a.getResourceId(R.styleable.MultipleStatusView_errorView, R.layout.error_view);
        this.loadingViewResId = a.getResourceId(R.styleable.MultipleStatusView_loadingView, R.layout.loading_view);
        this.noNetworkViewResId = a.getResourceId(R.styleable.MultipleStatusView_noNetworkView, R.layout.no_network_view);
        this.contentViewResId = a.getResourceId(R.styleable.MultipleStatusView_contentView, -1);
        a.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.inflater = LayoutInflater.from((Context)this.getContext());
        this.showContent();
    }

    public int getViewStatus() {
        return this.viewStatus;
    }

    public void setOnRetryClickListener(View.OnClickListener onRetryClickListener) {
        this.onRetryClickListener = onRetryClickListener;
    }

    public final void showEmpty() {
        this.viewStatus = 2;
        if (null == this.emptyView) {
            this.emptyView = this.inflater.inflate(this.emptyViewResId, null);
            this.emptyRetryView = this.emptyView.findViewById(R.id.empty_retry_view);
            if (null != this.onRetryClickListener && null != this.emptyRetryView) {
                this.emptyRetryView.setOnClickListener(this.onRetryClickListener);
            }
            this.addView(this.emptyView, 0, this.layoutParams);
        }
        this.showViewByStatus(this.viewStatus);
    }

    public final void showError() {
        this.viewStatus = 3;
        if (null == this.errorView) {
            this.errorView = this.inflater.inflate(this.errorViewResId, null);
            this.errorRetryView = this.errorView.findViewById(R.id.error_retry_view);
            if (null != this.onRetryClickListener && null != this.errorRetryView) {
                this.errorRetryView.setOnClickListener(this.onRetryClickListener);
            }
            this.addView(this.errorView, 0, this.layoutParams);
        }
        this.showViewByStatus(this.viewStatus);
    }

    public final void showLoading() {
        this.viewStatus = 1;
        if (null == this.loadingView) {
            this.loadingView = this.inflater.inflate(this.loadingViewResId, null);
            this.addView(this.loadingView, 0, this.layoutParams);
        }
        this.showViewByStatus(this.viewStatus);
    }

    public final void showNoNetwork() {
        this.viewStatus = 4;
        if (null == this.noNetworkView) {
            this.noNetworkView = this.inflater.inflate(this.noNetworkViewResId, null);
            this.noNetworkRetryView = this.noNetworkView.findViewById(R.id.no_network_retry_view);
            if (null != this.onRetryClickListener && null != this.noNetworkRetryView) {
                this.noNetworkRetryView.setOnClickListener(this.onRetryClickListener);
            }
            this.addView(this.noNetworkView, 0, this.layoutParams);
        }
        this.showViewByStatus(this.viewStatus);
    }

    public final void showContent() {
        this.viewStatus = 0;
        if (null == this.contentView) {
            if (this.contentViewResId != -1) {
                this.contentView = this.inflater.inflate(this.contentViewResId, null);
                this.addView(this.contentView, 0, this.layoutParams);
            } else {
                this.contentView = this.findViewById(R.id.content_view);
            }
        }
        this.showViewByStatus(this.viewStatus);
    }

    private final void showViewByStatus(int viewStatus) {
        if (null != this.loadingView) {
            this.loadingView.setVisibility(viewStatus == 1 ? 0 : 8);
        }
        if (null != this.emptyView) {
            this.emptyView.setVisibility(viewStatus == 2 ? 0 : 8);
        }
        if (null != this.errorView) {
            this.errorView.setVisibility(viewStatus == 3 ? 0 : 8);
        }
        if (null != this.noNetworkView) {
            this.noNetworkView.setVisibility(viewStatus == 4 ? 0 : 8);
        }
        if (null != this.contentView) {
            this.contentView.setVisibility(viewStatus == 0 ? 0 : 8);
        }
    }
}

