/*
 * Decompiled with CFR 0.152.
 */
package com.classic.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.classic.common.R;

public class MultipleStatusView
extends RelativeLayout {
    public static final int STATUS_CONTENT = 0;
    public static final int STATUS_LOADING = 1;
    public static final int STATUS_EMPTY = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_NO_NETWORK = 4;
    private static final int NULL_RESOURCE_ID = -1;
    private View emptyRetryView;
    private View errorRetryView;
    private View noNetworkRetryView;
    private int emptyViewResId;
    private int errorViewResId;
    private int loadingViewResId;
    private int noNetworkViewResId;
    private int contentViewResId;
    private int viewStatus;
    private final LayoutInflater inflater;

    public MultipleStatusView(Context context) {
        this(context, null);
    }

    public MultipleStatusView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultipleStatusView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MultipleStatusView, defStyleAttr, 0);
        this.inflater = LayoutInflater.from((Context)context);
        try {
            this.emptyViewResId = a.getResourceId(R.styleable.MultipleStatusView_emptyView, R.layout.empty_view);
            this.errorViewResId = a.getResourceId(R.styleable.MultipleStatusView_errorView, R.layout.error_view);
            this.loadingViewResId = a.getResourceId(R.styleable.MultipleStatusView_loadingView, R.layout.loading_view);
            this.noNetworkViewResId = a.getResourceId(R.styleable.MultipleStatusView_noNetworkView, R.layout.no_network_view);
            this.contentViewResId = a.getResourceId(R.styleable.MultipleStatusView_contentView, -1);
            this.inflater.inflate(this.emptyViewResId, (ViewGroup)this, true);
            this.inflater.inflate(this.errorViewResId, (ViewGroup)this, true);
            this.inflater.inflate(this.loadingViewResId, (ViewGroup)this, true);
            this.inflater.inflate(this.noNetworkViewResId, (ViewGroup)this, true);
            if (this.contentViewResId != -1) {
                this.inflater.inflate(this.contentViewResId, (ViewGroup)this, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            a.recycle();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initRetryView();
        this.showContent();
    }

    private void initRetryView() {
        this.emptyRetryView = this.findViewById(R.id.empty_retry_view);
        this.errorRetryView = this.findViewById(R.id.error_retry_view);
        this.noNetworkRetryView = this.findViewById(R.id.no_network_retry_view);
    }

    public int getViewStatus() {
        return this.viewStatus;
    }

    public void setOnRetryClickListener(View.OnClickListener onRetryClickListener) {
        if (null == onRetryClickListener) {
            return;
        }
        if (null != this.emptyRetryView) {
            this.emptyRetryView.setOnClickListener(onRetryClickListener);
        }
        if (null != this.errorRetryView) {
            this.errorRetryView.setOnClickListener(onRetryClickListener);
        }
        if (null != this.noNetworkRetryView) {
            this.noNetworkRetryView.setOnClickListener(onRetryClickListener);
        }
    }

    public final View showEmpty() {
        this.viewStatus = 2;
        return this.showViewById(R.id.empty_view);
    }

    public final View showError() {
        this.viewStatus = 3;
        return this.showViewById(R.id.error_view);
    }

    public final View showLoading() {
        this.viewStatus = 1;
        return this.showViewById(R.id.loading_view);
    }

    public final View showNoNetwork() {
        this.viewStatus = 4;
        return this.showViewById(R.id.no_network_view);
    }

    public final View showContent() {
        this.viewStatus = 0;
        return this.showViewById(R.id.content_view);
    }

    private final View showViewById(int viewId) {
        View view = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child;
            child.setVisibility((child = this.getChildAt(i)).getId() == viewId ? 0 : 8);
            if (child.getId() != viewId) continue;
            view = child;
        }
        return view;
    }
}

