/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.classic.adapter.BaseAdapterHelper;
import com.classic.adapter.interfaces.IAdapter;
import com.classic.adapter.interfaces.IData;
import com.classic.adapter.interfaces.IScrollHideListener;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonRecyclerAdapter<T>
extends RecyclerView.Adapter<RecyclerViewHolder>
implements IAdapter<T>,
IData<T> {
    private final Context mContext;
    private final int mLayoutResId;
    private final List<T> mData;
    private OnItemClickListener mItemClickListener;
    private OnItemLongClickListener mItemLongClickListener;

    public CommonRecyclerAdapter(@NonNull Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public CommonRecyclerAdapter(@NonNull Context context, int layoutResId, List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
        this.mLayoutResId = layoutResId;
    }

    public RecyclerViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseAdapterHelper helper = BaseAdapterHelper.get(this.mContext, null, parent, viewType, -1);
        return new RecyclerViewHolder(helper);
    }

    public void onBindViewHolder(RecyclerViewHolder holder, int position) {
        BaseAdapterHelper helper = holder.mAdapterHelper;
        helper.setAssociatedObject(this.getItem(position));
        this.onUpdate(helper, this.getItem(position), position);
    }

    public void onBindViewHolder(RecyclerViewHolder holder, int position, List<Object> payloads) {
        if (null != payloads && payloads.size() > 0) {
            BaseAdapterHelper helper = holder.mAdapterHelper;
            helper.setAssociatedObject(this.getItem(position));
            this.onItemContentChanged(helper, payloads);
        } else {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        }
    }

    public int getItemViewType(int position) {
        return this.getLayoutResId(this.getItem(position), position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    @Override
    public int getLayoutResId(T item, int position) {
        return this.mLayoutResId;
    }

    @Override
    public List<T> getData() {
        return this.mData;
    }

    @Override
    public void add(@NonNull T item) {
        this.mData.add(item);
        this.notifyItemInserted(this.mData.size());
    }

    @Override
    public void addAll(@NonNull List<T> list) {
        this.mData.addAll(list);
        this.notifyItemRangeInserted(this.mData.size() - list.size(), list.size());
    }

    @Override
    public void set(@NonNull T oldItem, @NonNull T newItem) {
        this.set(this.mData.indexOf(oldItem), newItem);
    }

    @Override
    public void set(int index, @NonNull T item) {
        if (index >= 0 && index < this.getItemCount()) {
            this.mData.set(index, item);
            this.notifyItemChanged(index);
        }
    }

    @Override
    public void remove(@NonNull T item) {
        this.remove(this.mData.indexOf(item));
    }

    @Override
    public void remove(int index) {
        if (index >= 0 && index < this.getItemCount()) {
            this.mData.remove(index);
            this.notifyItemRemoved(index);
        }
    }

    @Override
    public void replaceAll(@NonNull List<T> item) {
        this.replaceAll(item, true);
    }

    @Override
    public boolean contains(@NonNull T item) {
        return this.mData.contains(item);
    }

    @Override
    public void clear() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public void replaceAll(@NonNull List<T> elem, boolean notifyDataSetChanged) {
        this.mData.clear();
        this.mData.addAll(elem);
        if (notifyDataSetChanged) {
            this.notifyDataSetChanged();
        }
    }

    public void onItemContentChanged(@NonNull BaseAdapterHelper helper, @NonNull List<Object> payloads) {
    }

    public T getItem(int position) {
        return position < 0 || position >= this.mData.size() ? null : (T)this.mData.get(position);
    }

    public void setOnItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener itemLongClickListener) {
        this.mItemLongClickListener = itemLongClickListener;
    }

    public static abstract class AbsScrollControl
    extends RecyclerView.OnScrollListener
    implements IScrollHideListener {
        private static final int DEFAULT_SCROLL_HIDE_OFFSET = 20;
        private int mCurrentScrollOffset;
        private boolean isControlVisible;

        protected int getFirstVisibleItemPositions() {
            return 0;
        }

        protected int getScrollHideOffset() {
            return 20;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            int firstVisibleItemPosition = this.findFirstVisibleItemPosition(recyclerView.getLayoutManager());
            if (firstVisibleItemPosition == 0 && !this.isControlVisible) {
                this.onShow();
                this.isControlVisible = true;
            } else if (firstVisibleItemPosition != 0 && this.mCurrentScrollOffset > this.getScrollHideOffset() && this.isControlVisible) {
                this.onHide();
                this.isControlVisible = false;
                this.mCurrentScrollOffset = 0;
            } else if (firstVisibleItemPosition != 0 && this.mCurrentScrollOffset < -this.getScrollHideOffset() && !this.isControlVisible) {
                this.onShow();
                this.isControlVisible = true;
                this.mCurrentScrollOffset = 0;
            }
            if (this.isControlVisible && dy > 0 || !this.isControlVisible && dy < 0) {
                this.mCurrentScrollOffset += dy;
            }
        }

        private int findFirstVisibleItemPosition(RecyclerView.LayoutManager layoutManager) {
            if (layoutManager instanceof GridLayoutManager) {
                return ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
            }
            if (layoutManager instanceof LinearLayoutManager) {
                return ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            }
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                return ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null)[0];
            }
            return this.getFirstVisibleItemPositions();
        }
    }

    protected final class RecyclerViewHolder
    extends RecyclerView.ViewHolder {
        BaseAdapterHelper mAdapterHelper;

        public RecyclerViewHolder(BaseAdapterHelper adapterHelper) {
            super(adapterHelper.getView());
            this.mAdapterHelper = adapterHelper;
            if (null != CommonRecyclerAdapter.this.mItemClickListener) {
                this.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CommonRecyclerAdapter.this.mItemClickListener.onItemClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                    }
                });
            }
            if (null != CommonRecyclerAdapter.this.mItemLongClickListener) {
                this.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        CommonRecyclerAdapter.this.mItemLongClickListener.onItemLongClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                        return true;
                    }
                });
            }
        }
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }
}

