/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.classic.adapter.Adapter;
import com.classic.adapter.interfaces.ImageLoad;

public class BaseAdapterHelper {
    private final SparseArray<View> mViews;
    private final Context mContext;
    private View mConvertView;
    private int mPosition;
    private int mLayoutId;
    private ImageLoad mImageLoad;
    Object mAssociatedObject;

    protected BaseAdapterHelper(Context context, ViewGroup parent, int layoutId, int position) {
        this.mContext = context;
        this.mPosition = position;
        this.mLayoutId = layoutId;
        this.mViews = new SparseArray();
        this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        this.mConvertView.setTag((Object)this);
        if (null != Adapter.singleton && null != Adapter.singleton.getImageLoad()) {
            this.mImageLoad = Adapter.singleton.getImageLoad();
        }
    }

    public static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent, int layoutId) {
        return BaseAdapterHelper.get(context, convertView, parent, layoutId, -1);
    }

    static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent, int layoutId, int position) {
        if (convertView == null) {
            return new BaseAdapterHelper(context, parent, layoutId, position);
        }
        BaseAdapterHelper existingHelper = (BaseAdapterHelper)convertView.getTag();
        if (existingHelper.mLayoutId != layoutId) {
            return new BaseAdapterHelper(context, parent, layoutId, position);
        }
        existingHelper.mPosition = position;
        return existingHelper;
    }

    public View getView() {
        return this.mConvertView;
    }

    public <T extends View> T getView(@IdRes int viewId) {
        return this.retrieveView(viewId);
    }

    public int getPosition() {
        if (this.mPosition == -1) {
            throw new IllegalStateException("Use BaseAdapterHelper constructor with mPosition if you need to retrieve the mPosition.");
        }
        return this.mPosition;
    }

    public Object getAssociatedObject() {
        return this.mAssociatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.mAssociatedObject = associatedObject;
    }

    @RequiresApi(api=16)
    public BaseAdapterHelper setBackground(@IdRes int viewId, @NonNull Drawable drawable) {
        this.retrieveView(viewId).setBackground(drawable);
        return this;
    }

    public BaseAdapterHelper setBackgroundColor(@IdRes int viewId, @ColorInt int color) {
        this.retrieveView(viewId).setBackgroundColor(color);
        return this;
    }

    public BaseAdapterHelper setBackgroundRes(@IdRes int viewId, @DrawableRes int backgroundRes) {
        this.retrieveView(viewId).setBackgroundResource(backgroundRes);
        return this;
    }

    public BaseAdapterHelper setText(@IdRes int viewId, CharSequence value) {
        ((TextView)this.retrieveView(viewId)).setText(value);
        return this;
    }

    public BaseAdapterHelper setTextRes(@IdRes int viewId, @StringRes int resId) {
        ((TextView)this.retrieveView(viewId)).setText(resId);
        return this;
    }

    public BaseAdapterHelper setTextColor(@IdRes int viewId, @ColorInt int textColor) {
        ((TextView)this.retrieveView(viewId)).setTextColor(textColor);
        return this;
    }

    public BaseAdapterHelper setTextColorRes(@IdRes int viewId, @ColorRes int textColorRes) {
        ((TextView)this.retrieveView(viewId)).setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    @TargetApi(value=23)
    public BaseAdapterHelper setTextColorRes(@IdRes int viewId, @ColorRes int textColorRes, @Nullable Resources.Theme theme) {
        ((TextView)this.retrieveView(viewId)).setTextColor(this.mContext.getResources().getColor(textColorRes, theme));
        return this;
    }

    @RequiresApi(api=23)
    public BaseAdapterHelper setImageIcon(@IdRes int viewId, @NonNull Icon icon) {
        ((ImageView)this.retrieveView(viewId)).setImageIcon(icon);
        return this;
    }

    public BaseAdapterHelper setImageResource(@IdRes int viewId, @DrawableRes int imageResId) {
        ((ImageView)this.retrieveView(viewId)).setImageResource(imageResId);
        return this;
    }

    public BaseAdapterHelper setImageDrawable(@IdRes int viewId, @NonNull Drawable drawable) {
        ((ImageView)this.retrieveView(viewId)).setImageDrawable(drawable);
        return this;
    }

    public BaseAdapterHelper setImageUrl(@IdRes int viewId, @NonNull String imageUrl) {
        if (null != this.mImageLoad) {
            ImageView view = (ImageView)this.retrieveView(viewId);
            this.mImageLoad.load(this.mContext, view, imageUrl);
        }
        return this;
    }

    public BaseAdapterHelper setImageLoad(@NonNull ImageLoad imageLoad) {
        this.mImageLoad = imageLoad;
        return this;
    }

    public BaseAdapterHelper setImageBitmap(@IdRes int viewId, @NonNull Bitmap bitmap) {
        ((ImageView)this.retrieveView(viewId)).setImageBitmap(bitmap);
        return this;
    }

    public BaseAdapterHelper setAlpha(@IdRes int viewId, @FloatRange(from=0.0, to=1.0) float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public BaseAdapterHelper setVisible(@IdRes int viewId, boolean visible) {
        this.retrieveView(viewId).setVisibility(visible ? 0 : 8);
        return this;
    }

    public BaseAdapterHelper setVisible(@IdRes int viewId, int visibility) {
        this.retrieveView(viewId).setVisibility(visibility);
        return this;
    }

    public BaseAdapterHelper setEnabled(@IdRes int viewId, boolean enabled) {
        this.retrieveView(viewId).setEnabled(enabled);
        return this;
    }

    public BaseAdapterHelper setFocusable(@IdRes int viewId, boolean focusable) {
        this.retrieveView(viewId).setFocusable(focusable);
        return this;
    }

    public BaseAdapterHelper setFocusableInTouchMode(@IdRes int viewId, boolean focusableInTouchMode) {
        this.retrieveView(viewId).setFocusableInTouchMode(focusableInTouchMode);
        return this;
    }

    public BaseAdapterHelper addAllLinks(@IdRes int viewId) {
        this.addLinks(viewId, 15);
        return this;
    }

    public BaseAdapterHelper addLinks(@IdRes int viewId, int mask) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)mask);
        return this;
    }

    public BaseAdapterHelper setTypeface(@IdRes int viewId, @NonNull Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public BaseAdapterHelper setTypeface(@NonNull Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public BaseAdapterHelper setProgress(@IdRes int viewId, int progress) {
        ((ProgressBar)this.retrieveView(viewId)).setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setProgress(@IdRes int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setMax(@IdRes int viewId, int max) {
        ((ProgressBar)this.retrieveView(viewId)).setMax(max);
        return this;
    }

    public BaseAdapterHelper setRating(@IdRes int viewId, float rating) {
        ((RatingBar)this.retrieveView(viewId)).setRating(rating);
        return this;
    }

    public BaseAdapterHelper setRating(@IdRes int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setTag(@IdRes int viewId, @NonNull Object tag) {
        this.retrieveView(viewId).setTag(tag);
        return this;
    }

    public BaseAdapterHelper setTag(@IdRes int viewId, int key, @NonNull Object tag) {
        this.retrieveView(viewId).setTag(key, tag);
        return this;
    }

    public BaseAdapterHelper setChecked(@IdRes int viewId, boolean checked) {
        Object view = this.retrieveView(viewId);
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setChecked(checked);
        } else if (view instanceof CheckedTextView) {
            ((CheckedTextView)view).setChecked(checked);
        }
        return this;
    }

    public BaseAdapterHelper setAdapter(@IdRes int viewId, @NonNull android.widget.Adapter adapter) {
        ((AdapterView)this.retrieveView(viewId)).setAdapter(adapter);
        return this;
    }

    public BaseAdapterHelper setOnClickListener(@IdRes int viewId, @NonNull View.OnClickListener listener) {
        this.retrieveView(viewId).setOnClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnTouchListener(@IdRes int viewId, @NonNull View.OnTouchListener listener) {
        this.retrieveView(viewId).setOnTouchListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnLongClickListener(@IdRes int viewId, @NonNull View.OnLongClickListener listener) {
        this.retrieveView(viewId).setOnLongClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemClickListener(@IdRes int viewId, @NonNull AdapterView.OnItemClickListener listener) {
        ((AdapterView)this.retrieveView(viewId)).setOnItemClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemLongClickListener(@IdRes int viewId, @NonNull AdapterView.OnItemLongClickListener listener) {
        ((AdapterView)this.retrieveView(viewId)).setOnItemLongClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemSelectedClickListener(@IdRes int viewId, @NonNull AdapterView.OnItemSelectedListener listener) {
        ((AdapterView)this.retrieveView(viewId)).setOnItemSelectedListener(listener);
        return this;
    }

    private <T extends View> T retrieveView(@IdRes int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }
}

