/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.classic.adapter.BaseAdapterHelper;
import com.classic.adapter.interfaces.IAdapter;
import com.classic.adapter.interfaces.IData;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonAdapter<T>
extends BaseAdapter
implements IData<T>,
IAdapter<T> {
    private final Context mContext;
    private final int mLayoutResId;
    private final List<T> mData;

    public CommonAdapter(@NonNull Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public CommonAdapter(@NonNull Context context, int layoutResId, List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
        this.mLayoutResId = layoutResId;
    }

    @Override
    public List<T> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData.size();
    }

    public T getItem(int position) {
        return position >= this.mData.size() ? null : (T)this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getLayoutResId(T item, int position) {
        return this.mLayoutResId;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        T item = this.getItem(position);
        BaseAdapterHelper helper = BaseAdapterHelper.get(this.mContext, convertView, parent, this.getLayoutResId(item, position), position);
        this.onUpdate(helper, item, position);
        helper.setAssociatedObject(item);
        return helper.getView();
    }

    public boolean isEnabled(int position) {
        return position < this.mData.size();
    }

    @Override
    public void add(@NonNull T item) {
        this.mData.add(item);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAll(@NonNull List<T> list) {
        this.mData.addAll(list);
        this.notifyDataSetChanged();
    }

    @Override
    public void set(@NonNull T oldItem, @NonNull T newItem) {
        this.set(this.mData.indexOf(oldItem), newItem);
    }

    @Override
    public void set(int index, @NonNull T item) {
        if (index >= 0 && index < this.getCount()) {
            this.mData.set(index, item);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void remove(@NonNull T item) {
        this.mData.remove(item);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(int index) {
        if (index >= 0 && index < this.getCount()) {
            this.mData.remove(index);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void replaceAll(@NonNull List<T> item) {
        this.mData.clear();
        this.mData.addAll(item);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(@NonNull T item) {
        return this.mData.contains(item);
    }

    @Override
    public void clear() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }
}

