/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.content.Context;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.classic.adapter.BaseAdapterHelper;
import com.classic.adapter.interfaces.IAdapter;
import com.classic.adapter.interfaces.IData;
import com.classic.adapter.interfaces.IScrollHideListener;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonRecyclerAdapter<T>
extends RecyclerView.Adapter
implements IAdapter<T>,
IData<T> {
    private final Context mContext;
    private final int mLayoutResId;
    private final List<T> mData;
    private OnItemClickListener mItemClickListener;
    private OnItemLongClickListener mItemLongClickListener;

    public CommonRecyclerAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public CommonRecyclerAdapter(Context context, int layoutResId, List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
        this.mLayoutResId = layoutResId;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseAdapterHelper helper = BaseAdapterHelper.get(this.mContext, null, parent, viewType, -1);
        return new RecyclerViewHolder(helper.getView(), helper);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        BaseAdapterHelper helper = ((RecyclerViewHolder)holder).mAdapterHelper;
        helper.setAssociatedObject(this.getItem(position));
        this.onUpdate(helper, this.getItem(position), position);
    }

    public int getItemViewType(int position) {
        return this.getLayoutResId(this.getItem(position), position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    @Override
    public int getLayoutResId(T item, int position) {
        return this.mLayoutResId;
    }

    @Override
    public List<T> getData() {
        return this.mData;
    }

    @Override
    public void add(T elem) {
        this.mData.add(elem);
        this.notifyItemInserted(this.mData.size());
    }

    @Override
    public void addAll(List<T> elem) {
        this.mData.addAll(elem);
        this.notifyItemRangeInserted(this.mData.size() - elem.size(), elem.size());
    }

    @Override
    public void set(T oldElem, T newElem) {
        this.set(this.mData.indexOf(oldElem), newElem);
    }

    @Override
    public void set(int index, T elem) {
        this.mData.set(index, elem);
        this.notifyItemChanged(index);
    }

    @Override
    public void remove(T elem) {
        int position = this.mData.indexOf(elem);
        this.mData.remove(elem);
        this.notifyItemRemoved(position);
    }

    @Override
    public void remove(int index) {
        this.mData.remove(index);
        this.notifyItemRemoved(index);
    }

    public void replaceAll(List<T> elem, DiffUtil.Callback callback) {
        this.mData.clear();
        this.mData.addAll(elem);
        DiffUtil.calculateDiff((DiffUtil.Callback)callback, (boolean)true).dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    @Override
    @Deprecated
    public void replaceAll(List<T> elem) {
        this.mData.clear();
        this.mData.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T elem) {
        return this.mData.contains(elem);
    }

    @Override
    public void clear() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public T getItem(int position) {
        return position >= this.mData.size() ? null : (T)this.mData.get(position);
    }

    public void setOnItemClickListener(OnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener itemLongClickListener) {
        this.mItemLongClickListener = itemLongClickListener;
    }

    public static abstract class AbsScrollControl
    extends RecyclerView.OnScrollListener
    implements IScrollHideListener {
        private static final int DEFAULT_SCROLL_HIDE_OFFSET = 20;
        private int mCurrentScrollOffset;
        private boolean isControlVisible;

        protected int getFirstVisibleItemPositions() {
            return 0;
        }

        protected int getScrollHideOffset() {
            return 20;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            int firstVisibleItemPosition = this.findFirstVisibleItemPosition(recyclerView.getLayoutManager());
            if (firstVisibleItemPosition == 0 && !this.isControlVisible) {
                this.onShow();
                this.isControlVisible = true;
            } else if (firstVisibleItemPosition != 0 && this.mCurrentScrollOffset > this.getScrollHideOffset() && this.isControlVisible) {
                this.onHide();
                this.isControlVisible = false;
                this.mCurrentScrollOffset = 0;
            } else if (firstVisibleItemPosition != 0 && this.mCurrentScrollOffset < -this.getScrollHideOffset() && !this.isControlVisible) {
                this.onShow();
                this.isControlVisible = true;
                this.mCurrentScrollOffset = 0;
            }
            if (this.isControlVisible && dy > 0 || !this.isControlVisible && dy < 0) {
                this.mCurrentScrollOffset += dy;
            }
        }

        private int findFirstVisibleItemPosition(RecyclerView.LayoutManager layoutManager) {
            if (layoutManager instanceof GridLayoutManager) {
                return ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
            }
            if (layoutManager instanceof LinearLayoutManager) {
                return ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            }
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                return ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null)[0];
            }
            return this.getFirstVisibleItemPositions();
        }
    }

    private final class RecyclerViewHolder
    extends RecyclerView.ViewHolder {
        BaseAdapterHelper mAdapterHelper;

        public RecyclerViewHolder(View itemView, BaseAdapterHelper adapterHelper) {
            super(itemView);
            this.mAdapterHelper = adapterHelper;
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != CommonRecyclerAdapter.this.mItemClickListener) {
                        CommonRecyclerAdapter.this.mItemClickListener.onItemClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                    }
                }
            });
            itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (null != CommonRecyclerAdapter.this.mItemLongClickListener) {
                        CommonRecyclerAdapter.this.mItemLongClickListener.onItemLongClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }
}

