/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.classic.adapter.Adapter;
import com.classic.adapter.interfaces.ImageLoad;

public class BaseAdapterHelper {
    private final SparseArray<View> mViews;
    private final Context mContext;
    private View mConvertView;
    private int mPosition;
    private int mLayoutId;
    private ImageLoad mImageLoad;
    Object mAssociatedObject;

    protected BaseAdapterHelper(Context context, ViewGroup parent, int layoutId, int position) {
        this.mContext = context;
        this.mPosition = position;
        this.mLayoutId = layoutId;
        this.mViews = new SparseArray();
        this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        this.mConvertView.setTag((Object)this);
        if (null != Adapter.singleton && null != Adapter.singleton.getImageLoad()) {
            this.mImageLoad = Adapter.singleton.getImageLoad();
        }
    }

    public static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent, int layoutId) {
        return BaseAdapterHelper.get(context, convertView, parent, layoutId, -1);
    }

    static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent, int layoutId, int position) {
        if (convertView == null) {
            return new BaseAdapterHelper(context, parent, layoutId, position);
        }
        BaseAdapterHelper existingHelper = (BaseAdapterHelper)convertView.getTag();
        if (existingHelper.mLayoutId != layoutId) {
            return new BaseAdapterHelper(context, parent, layoutId, position);
        }
        existingHelper.mPosition = position;
        return existingHelper;
    }

    public <T extends View> T getView(@IdRes int viewId) {
        return this.retrieveView(viewId);
    }

    @RequiresApi(api=16)
    public BaseAdapterHelper setBackground(@IdRes int viewId, @NonNull Drawable drawable) {
        Object view = this.retrieveView(viewId);
        view.setBackground(drawable);
        return this;
    }

    public BaseAdapterHelper setBackgroundColor(@IdRes int viewId, @ColorInt int color) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public BaseAdapterHelper setBackgroundRes(@IdRes int viewId, @DrawableRes int backgroundRes) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public BaseAdapterHelper setText(@IdRes int viewId, CharSequence value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText(value);
        return this;
    }

    public BaseAdapterHelper setTextRes(@IdRes int viewId, @StringRes int resId) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText(resId);
        return this;
    }

    public BaseAdapterHelper setTextColor(@IdRes int viewId, @ColorInt int textColor) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public BaseAdapterHelper setTextColorRes(@IdRes int viewId, @ColorRes int textColorRes) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    @TargetApi(value=23)
    public BaseAdapterHelper setTextColorRes(@IdRes int viewId, @ColorRes int textColorRes, @Nullable Resources.Theme theme) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes, theme));
        return this;
    }

    @RequiresApi(api=23)
    public BaseAdapterHelper setImageIcon(@IdRes int viewId, @NonNull Icon icon) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageIcon(icon);
        return this;
    }

    public BaseAdapterHelper setImageResource(@IdRes int viewId, @DrawableRes int imageResId) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public BaseAdapterHelper setImageDrawable(@IdRes int viewId, @NonNull Drawable drawable) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public BaseAdapterHelper setImageUrl(@IdRes int viewId, @NonNull String imageUrl) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        if (null != this.mImageLoad) {
            this.mImageLoad.load(this.mContext, view, imageUrl);
        }
        return this;
    }

    public BaseAdapterHelper setImageLoad(@NonNull ImageLoad imageLoad) {
        this.mImageLoad = imageLoad;
        return this;
    }

    public BaseAdapterHelper setImageBitmap(@IdRes int viewId, @NonNull Bitmap bitmap) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public BaseAdapterHelper setAlpha(@IdRes int viewId, @FloatRange(from=0.0, to=1.0) float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public BaseAdapterHelper setVisible(@IdRes int viewId, boolean visible) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public BaseAdapterHelper setVisible(@IdRes int viewId, int visibility) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visibility);
        return this;
    }

    public BaseAdapterHelper setEnabled(@IdRes int viewId, boolean enabled) {
        Object view = this.retrieveView(viewId);
        view.setEnabled(enabled);
        return this;
    }

    public BaseAdapterHelper setFocusable(@IdRes int viewId, boolean focusable) {
        Object view = this.retrieveView(viewId);
        view.setFocusable(focusable);
        return this;
    }

    public BaseAdapterHelper setFocusableInTouchMode(@IdRes int viewId, boolean focusableInTouchMode) {
        Object view = this.retrieveView(viewId);
        view.setFocusableInTouchMode(focusableInTouchMode);
        return this;
    }

    public BaseAdapterHelper linkify(@IdRes int viewId) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public BaseAdapterHelper addLinks(@IdRes int viewId, int mask) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)mask);
        return this;
    }

    public BaseAdapterHelper setTypeface(@IdRes int viewId, @NonNull Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public BaseAdapterHelper setTypeface(@NonNull Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public BaseAdapterHelper setProgress(@IdRes int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setProgress(@IdRes int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setMax(@IdRes int viewId, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        return this;
    }

    public BaseAdapterHelper setRating(@IdRes int viewId, float rating) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setRating(@IdRes int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setOnClickListener(@IdRes int viewId, @NonNull View.OnClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnTouchListener(@IdRes int viewId, @NonNull View.OnTouchListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnLongClickListener(@IdRes int viewId, @NonNull View.OnLongClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemClickListener(@IdRes int viewId, @NonNull AdapterView.OnItemClickListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemLongClickListener(@IdRes int viewId, @NonNull AdapterView.OnItemLongClickListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemLongClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemSelectedClickListener(@IdRes int viewId, @NonNull AdapterView.OnItemSelectedListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemSelectedListener(listener);
        return this;
    }

    public BaseAdapterHelper setTag(@IdRes int viewId, @NonNull Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(tag);
        return this;
    }

    public BaseAdapterHelper setTag(@IdRes int viewId, int key, @NonNull Object tag) {
        Object view = this.retrieveView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public BaseAdapterHelper setChecked(@IdRes int viewId, boolean checked) {
        Object view = this.retrieveView(viewId);
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setChecked(checked);
        } else if (view instanceof CheckedTextView) {
            ((CheckedTextView)view).setChecked(checked);
        }
        return this;
    }

    public BaseAdapterHelper setAdapter(@IdRes int viewId, @NonNull android.widget.Adapter adapter) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    public View getView() {
        return this.mConvertView;
    }

    public int getPosition() {
        if (this.mPosition == -1) {
            throw new IllegalStateException("Use BaseAdapterHelper constructor with mPosition if you need to retrieve the mPosition.");
        }
        return this.mPosition;
    }

    protected <T extends View> T retrieveView(@IdRes int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public Object getAssociatedObject() {
        return this.mAssociatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.mAssociatedObject = associatedObject;
    }
}

