/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.classic.adapter.BaseAdapterHelper;
import com.classic.adapter.interfaces.IAdapter;
import com.classic.adapter.interfaces.IData;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonRecyclerAdapter<T>
extends RecyclerView.Adapter
implements IAdapter<T>,
IData<T> {
    protected final Context mContext;
    protected final int mLayoutResId;
    protected final List<T> mData;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;

    public CommonRecyclerAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public CommonRecyclerAdapter(Context context, int layoutResId, List<T> data) {
        this.mData = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.mContext = context;
        this.mLayoutResId = layoutResId;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseAdapterHelper helper = BaseAdapterHelper.get(this.mContext, null, parent, viewType, -1);
        return new RecyclerViewHolder(helper.getView(), helper);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        BaseAdapterHelper helper = ((RecyclerViewHolder)holder).adapterHelper;
        helper.setAssociatedObject(this.getItem(position));
        this.onUpdate(helper, this.getItem(position), position);
    }

    public int getItemViewType(int position) {
        return this.getLayoutResId(this.getItem(position), position);
    }

    public long getItemId(int position) {
        return position;
    }

    public T getItem(int position) {
        return position >= this.mData.size() ? null : (T)this.mData.get(position);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    @Override
    public int getLayoutResId(T item, int position) {
        return this.mLayoutResId;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    @Override
    public void add(T elem) {
        this.mData.add(elem);
        this.notifyItemInserted(this.mData.size());
    }

    @Override
    public void addAll(List<T> elem) {
        this.mData.addAll(elem);
        this.notifyItemRangeInserted(this.mData.size() - elem.size(), elem.size());
    }

    @Override
    public void set(T oldElem, T newElem) {
        this.set(this.mData.indexOf(oldElem), newElem);
    }

    @Override
    public void set(int index, T elem) {
        this.mData.set(index, elem);
        this.notifyItemChanged(index);
    }

    @Override
    public void remove(T elem) {
        int position = this.mData.indexOf(elem);
        this.mData.remove(elem);
        this.notifyItemRemoved(position);
    }

    @Override
    public void remove(int index) {
        this.mData.remove(index);
        this.notifyItemRemoved(index);
    }

    @Override
    public void replaceAll(List<T> elem) {
        this.mData.clear();
        this.mData.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T elem) {
        return this.mData.contains(elem);
    }

    @Override
    public void clear() {
        this.mData.clear();
        this.notifyDataSetChanged();
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }

    public class RecyclerViewHolder
    extends RecyclerView.ViewHolder {
        BaseAdapterHelper adapterHelper;

        public RecyclerViewHolder(View itemView, BaseAdapterHelper adapterHelper) {
            super(itemView);
            this.adapterHelper = adapterHelper;
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != CommonRecyclerAdapter.this.onItemClickListener) {
                        CommonRecyclerAdapter.this.onItemClickListener.onItemClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                    }
                }
            });
            itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (null != CommonRecyclerAdapter.this.onItemLongClickListener) {
                        CommonRecyclerAdapter.this.onItemLongClickListener.onItemLongClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                        return true;
                    }
                    return false;
                }
            });
        }
    }
}

