/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.classic.adapter.interfaces.ImageLoad;

public class BaseAdapterHelper {
    private final SparseArray<View> mViews;
    private final Context mContext;
    private View mConvertView;
    private int mPosition;
    private int mLayoutId;
    private ImageLoad mImageLoad;
    Object mAssociatedObject;

    protected BaseAdapterHelper(Context context, ViewGroup parent, int layoutId, int position) {
        this.mContext = context;
        this.mPosition = position;
        this.mLayoutId = layoutId;
        this.mViews = new SparseArray();
        this.mConvertView = LayoutInflater.from((Context)context).inflate(layoutId, parent, false);
        this.mConvertView.setTag((Object)this);
    }

    public static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent, int layoutId) {
        return BaseAdapterHelper.get(context, convertView, parent, layoutId, -1);
    }

    static BaseAdapterHelper get(Context context, View convertView, ViewGroup parent, int layoutId, int position) {
        if (convertView == null) {
            return new BaseAdapterHelper(context, parent, layoutId, position);
        }
        BaseAdapterHelper existingHelper = (BaseAdapterHelper)convertView.getTag();
        if (existingHelper.mLayoutId != layoutId) {
            return new BaseAdapterHelper(context, parent, layoutId, position);
        }
        existingHelper.mPosition = position;
        return existingHelper;
    }

    public <T extends View> T getView(int viewId) {
        return this.retrieveView(viewId);
    }

    public BaseAdapterHelper setText(int viewId, String value) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setText((CharSequence)this.replaceEmpty(value));
        return this;
    }

    public BaseAdapterHelper setImageResource(int viewId, int imageResId) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public BaseAdapterHelper setBackgroundColor(int viewId, int color) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public BaseAdapterHelper setBackgroundRes(int viewId, int backgroundRes) {
        Object view = this.retrieveView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public BaseAdapterHelper setTextColor(int viewId, int textColor) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public BaseAdapterHelper setTextColorRes(int viewId, int textColorRes) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes));
        return this;
    }

    @TargetApi(value=23)
    public BaseAdapterHelper setTextColorRes(int viewId, int textColorRes, @Nullable Resources.Theme theme) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTextColor(this.mContext.getResources().getColor(textColorRes, theme));
        return this;
    }

    public BaseAdapterHelper setImageDrawable(int viewId, Drawable drawable) {
        if (null != drawable) {
            ImageView view = (ImageView)this.retrieveView(viewId);
            view.setImageDrawable(drawable);
        }
        return this;
    }

    public BaseAdapterHelper setImageUrl(int viewId, String imageUrl) {
        ImageView view = (ImageView)this.retrieveView(viewId);
        if (null != this.mImageLoad) {
            this.mImageLoad.load(this.mContext, view, imageUrl);
        }
        return this;
    }

    public BaseAdapterHelper setImageLoad(ImageLoad imageLoad) {
        this.mImageLoad = imageLoad;
        return this;
    }

    public BaseAdapterHelper setImageBitmap(int viewId, Bitmap bitmap) {
        if (null != bitmap) {
            ImageView view = (ImageView)this.retrieveView(viewId);
            view.setImageBitmap(bitmap);
        }
        return this;
    }

    public BaseAdapterHelper setAlpha(int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.retrieveView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.retrieveView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public BaseAdapterHelper setVisible(int viewId, boolean visible) {
        Object view = this.retrieveView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public BaseAdapterHelper linkify(int viewId) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public BaseAdapterHelper addLinks(int viewId, int mask) {
        TextView view = (TextView)this.retrieveView(viewId);
        Linkify.addLinks((TextView)view, (int)mask);
        return this;
    }

    public BaseAdapterHelper setTypeface(int viewId, Typeface typeface) {
        TextView view = (TextView)this.retrieveView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public BaseAdapterHelper setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.retrieveView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public BaseAdapterHelper setProgress(int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setProgress(int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public BaseAdapterHelper setMax(int viewId, int max) {
        ProgressBar view = (ProgressBar)this.retrieveView(viewId);
        view.setMax(max);
        return this;
    }

    public BaseAdapterHelper setRating(int viewId, float rating) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setRating(int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.retrieveView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public BaseAdapterHelper setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnTouchListener(int viewId, View.OnTouchListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnLongClickListener(int viewId, View.OnLongClickListener listener) {
        Object view = this.retrieveView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemClickListener(int viewId, AdapterView.OnItemClickListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemLongClickListener(int viewId, AdapterView.OnItemLongClickListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemLongClickListener(listener);
        return this;
    }

    public BaseAdapterHelper setOnItemSelectedClickListener(int viewId, AdapterView.OnItemSelectedListener listener) {
        AdapterView view = (AdapterView)this.retrieveView(viewId);
        view.setOnItemSelectedListener(listener);
        return this;
    }

    public BaseAdapterHelper setTag(int viewId, Object tag) {
        if (null != tag) {
            Object view = this.retrieveView(viewId);
            view.setTag(tag);
        }
        return this;
    }

    public BaseAdapterHelper setTag(int viewId, int key, Object tag) {
        if (null != tag) {
            Object view = this.retrieveView(viewId);
            view.setTag(key, tag);
        }
        return this;
    }

    public BaseAdapterHelper setChecked(int viewId, boolean checked) {
        Object view = this.retrieveView(viewId);
        if (view instanceof CompoundButton) {
            ((CompoundButton)view).setChecked(checked);
        } else if (view instanceof CheckedTextView) {
            ((CheckedTextView)view).setChecked(checked);
        }
        return this;
    }

    public BaseAdapterHelper setAdapter(int viewId, Adapter adapter) {
        if (null != adapter) {
            AdapterView view = (AdapterView)this.retrieveView(viewId);
            view.setAdapter(adapter);
        }
        return this;
    }

    public View getView() {
        return this.mConvertView;
    }

    public int getPosition() {
        if (this.mPosition == -1) {
            throw new IllegalStateException("Use BaseAdapterHelper constructor with mPosition if you need to retrieve the mPosition.");
        }
        return this.mPosition;
    }

    protected <T extends View> T retrieveView(int viewId) {
        View view = (View)this.mViews.get(viewId);
        if (view == null) {
            view = this.mConvertView.findViewById(viewId);
            this.mViews.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public Object getAssociatedObject() {
        return this.mAssociatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.mAssociatedObject = associatedObject;
    }

    private String replaceEmpty(String params) {
        return TextUtils.isEmpty((CharSequence)params) ? "" : params;
    }
}

