/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.classic.adapter.BaseAdapterHelper;
import com.classic.adapter.interfaces.IAdapter;
import com.classic.adapter.interfaces.IData;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonRecyclerAdapter<T>
extends RecyclerView.Adapter
implements IAdapter<T>,
IData<T> {
    protected final Context context;
    protected final int layoutResId;
    protected final List<T> data;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;

    public CommonRecyclerAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public CommonRecyclerAdapter(Context context, int layoutResId, List<T> data) {
        this.data = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.context = context;
        this.layoutResId = layoutResId;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseAdapterHelper helper = BaseAdapterHelper.get(this.context, null, parent, viewType, -1);
        return new RecyclerViewHolder(helper.getView(), helper);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        BaseAdapterHelper helper = ((RecyclerViewHolder)holder).adapterHelper;
        helper.setAssociatedObject(this.getItem(position));
        this.onUpdate(helper, this.getItem(position));
    }

    public int getItemViewType(int position) {
        return this.getLayoutResId(this.getItem(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public T getItem(int position) {
        return position >= this.data.size() ? null : (T)this.data.get(position);
    }

    public int getItemCount() {
        return this.data.size();
    }

    @Override
    public int getLayoutResId(T item) {
        return this.layoutResId;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyItemInserted(this.data.size());
    }

    @Override
    public void addAll(List<T> elem) {
        this.data.addAll(elem);
        this.notifyItemRangeInserted(this.data.size() - elem.size(), elem.size());
    }

    @Override
    public void set(T oldElem, T newElem) {
        this.set(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void set(int index, T elem) {
        this.data.set(index, elem);
        this.notifyItemChanged(index);
    }

    @Override
    public void remove(T elem) {
        int position = this.data.indexOf(elem);
        this.data.remove(elem);
        this.notifyItemRemoved(position);
    }

    @Override
    public void remove(int index) {
        this.data.remove(index);
        this.notifyItemRemoved(index);
    }

    @Override
    public void replaceAll(List<T> elem) {
        this.data.clear();
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.notifyDataSetChanged();
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView.ViewHolder var1, View var2, int var3);
    }

    public class RecyclerViewHolder
    extends RecyclerView.ViewHolder {
        BaseAdapterHelper adapterHelper;

        public RecyclerViewHolder(View itemView, BaseAdapterHelper adapterHelper) {
            super(itemView);
            this.adapterHelper = adapterHelper;
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != CommonRecyclerAdapter.this.onItemClickListener) {
                        CommonRecyclerAdapter.this.onItemClickListener.onItemClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                    }
                }
            });
            itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (null != CommonRecyclerAdapter.this.onItemLongClickListener) {
                        CommonRecyclerAdapter.this.onItemLongClickListener.onItemLongClick(RecyclerViewHolder.this, v, RecyclerViewHolder.this.getAdapterPosition());
                        return true;
                    }
                    return false;
                }
            });
        }
    }
}

