/*
 * Decompiled with CFR 0.152.
 */
package com.classic.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.classic.adapter.BaseAdapterHelper;
import com.classic.adapter.interfaces.IAdapter;
import com.classic.adapter.interfaces.IData;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonAdapter<T>
extends BaseAdapter
implements IData<T>,
IAdapter<T> {
    protected final Context context;
    protected final int layoutResId;
    protected final List<T> data;

    public CommonAdapter(Context context, int layoutResId) {
        this(context, layoutResId, null);
    }

    public CommonAdapter(Context context, int layoutResId, List<T> data) {
        this.data = data == null ? new ArrayList<T>() : new ArrayList<T>(data);
        this.context = context;
        this.layoutResId = layoutResId;
    }

    public int getCount() {
        return this.data.size();
    }

    public T getItem(int position) {
        return position >= this.data.size() ? null : (T)this.data.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getLayoutResId(T item) {
        return this.layoutResId;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        T item = this.getItem(position);
        BaseAdapterHelper helper = BaseAdapterHelper.get(this.context, convertView, parent, this.getLayoutResId(item), position);
        this.onUpdate(helper, item);
        helper.setAssociatedObject(item);
        return helper.getView();
    }

    public boolean isEnabled(int position) {
        return position < this.data.size();
    }

    @Override
    public void add(T elem) {
        this.data.add(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void addAll(List<T> elem) {
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void set(T oldElem, T newElem) {
        this.set(this.data.indexOf(oldElem), newElem);
    }

    @Override
    public void set(int index, T elem) {
        this.data.set(index, elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(T elem) {
        this.data.remove(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public void remove(int index) {
        this.data.remove(index);
        this.notifyDataSetChanged();
    }

    @Override
    public void replaceAll(List<T> elem) {
        this.data.clear();
        this.data.addAll(elem);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(T elem) {
        return this.data.contains(elem);
    }

    @Override
    public void clear() {
        this.data.clear();
        this.notifyDataSetChanged();
    }
}

