/*
 * Decompiled with CFR 0.152.
 */
package com.cjj;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import com.cjj.Util;

public class PerseiLayout
extends FrameLayout {
    public static final String Tag = "cjj_log";
    protected FrameLayout mHeadLayout;
    protected int DEFAULT_HEIGHT = 120;
    protected float mHeadHeight;
    protected boolean isOpenMenu;
    private View mChildView;
    private float mTouchY;
    private float mCurrentY;
    private DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator(10.0f);

    public PerseiLayout(Context context) {
        this(context, null, 0);
    }

    public PerseiLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PerseiLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.getChildCount() > 1) {
            throw new RuntimeException("can only have one child widget");
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Context context = this.getContext();
        FrameLayout headViewLayout = new FrameLayout(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, 0);
        layoutParams.gravity = 48;
        headViewLayout.setBackgroundColor(Color.rgb((int)51, (int)51, (int)76));
        headViewLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mHeadLayout = headViewLayout;
        this.addView((View)this.mHeadLayout);
        this.mChildView = this.getChildAt(0);
        this.mHeadHeight = Util.dip2px(this.getContext(), this.DEFAULT_HEIGHT);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mCurrentY = this.mTouchY = ev.getY();
                break;
            }
            case 2: {
                float currentY = ev.getY();
                float dy = currentY - this.mTouchY;
                if (!(dy > 0.0f) || this.canChildScrollUp()) break;
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.isOpenMenu) {
            return super.onTouchEvent(e);
        }
        switch (e.getAction()) {
            case 2: {
                this.mCurrentY = e.getY();
                float dy = this.mCurrentY - this.mTouchY;
                dy = Math.min(this.mHeadHeight * 2.0f, dy);
                dy = Math.max(0.0f, dy);
                if (this.mChildView != null) {
                    float offsetY = this.decelerateInterpolator.getInterpolation(dy / this.mHeadHeight / 2.0f) * dy / 2.0f;
                    float fraction = offsetY / this.mHeadHeight;
                    this.mHeadLayout.getLayoutParams().height = (int)offsetY;
                    this.mHeadLayout.requestLayout();
                    ViewCompat.setRotationX((View)this.mHeadLayout, (float)(90.0f * (1.0f - fraction)));
                    ViewCompat.setTranslationY((View)this.mChildView, (float)offsetY);
                    this.mHeadLayout.setPivotX((float)(this.mHeadLayout.getWidth() / 2));
                    this.mHeadLayout.setPivotY(offsetY);
                }
                return true;
            }
            case 1: 
            case 3: {
                if (this.mChildView != null) {
                    if (ViewCompat.getTranslationY((View)this.mChildView) >= this.mHeadHeight) {
                        this.createAnimatorTranslationY(this.mChildView, this.mHeadHeight, this.mHeadLayout);
                        this.isOpenMenu = true;
                    } else {
                        this.createAnimatorToHeadView((View)this.mHeadLayout, ViewCompat.getRotationX((View)this.mHeadLayout));
                        this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                PerseiLayout.this.createAnimatorTranslationY(PerseiLayout.this.mChildView, 0.0f, PerseiLayout.this.mHeadLayout);
                            }
                        }, 50L);
                    }
                }
                return true;
            }
        }
        return super.onTouchEvent(e);
    }

    public void createAnimatorToHeadView(View v, float angle) {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)v);
        viewPropertyAnimatorCompat.setDuration(200L);
        viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
        viewPropertyAnimatorCompat.rotationX(90.0f);
        viewPropertyAnimatorCompat.start();
        viewPropertyAnimatorCompat.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

            public void onAnimationUpdate(View view) {
                float height = ViewCompat.getTranslationY((View)PerseiLayout.this.mChildView);
                PerseiLayout.this.mHeadLayout.setPivotX((float)(PerseiLayout.this.mHeadLayout.getWidth() / 2));
                PerseiLayout.this.mHeadLayout.setPivotY(height);
            }
        });
    }

    public void createAnimatorTranslationY(final View v, float h, final FrameLayout fl) {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)v);
        viewPropertyAnimatorCompat.setDuration(200L);
        viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
        viewPropertyAnimatorCompat.translationY(h);
        viewPropertyAnimatorCompat.start();
        viewPropertyAnimatorCompat.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

            public void onAnimationUpdate(View view) {
                float height = ViewCompat.getTranslationY((View)v);
                fl.getLayoutParams().height = (int)height;
                fl.requestLayout();
            }
        });
    }

    public void closeMenu() {
        this.createAnimatorToHeadView((View)this.mHeadLayout, ViewCompat.getRotationX((View)this.mHeadLayout));
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                PerseiLayout.this.finishRefreshing();
            }
        }, 200L);
    }

    private void finishRefreshing() {
        if (this.mChildView != null) {
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)this.mChildView);
            viewPropertyAnimatorCompat.setDuration(200L);
            viewPropertyAnimatorCompat.y(ViewCompat.getTranslationY((View)this.mChildView));
            viewPropertyAnimatorCompat.translationY(0.0f);
            viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
            viewPropertyAnimatorCompat.start();
        }
        this.isOpenMenu = false;
    }

    public void setHeaderView(final View headerView) {
        this.post(new Runnable(){

            @Override
            public void run() {
                PerseiLayout.this.mHeadLayout.addView(headerView);
            }
        });
    }

    public boolean canChildScrollUp() {
        if (this.mChildView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mChildView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mChildView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1) || this.mChildView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1);
    }
}

