/*
 * Decompiled with CFR 0.152.
 */
package com.cjj;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import com.cjj.MaterialHeadListener;
import com.cjj.MaterialHeadView;
import com.cjj.MaterialRefreshListener;
import com.cjj.MaterialWaveView;
import com.cjj.R;
import com.cjj.Util;

public class MaterialRefreshLayout
extends FrameLayout {
    public static final String Tag = "cjj_log";
    private MaterialHeadView materialHeadView;
    private boolean isOverlay;
    private int waveType;
    private int DEFAULT_WAVE_HEIGHT = 140;
    private int HIGHER_WAVE_HEIGHT = 180;
    private int DEFAULT_HEAD_HEIGHT = 70;
    private int hIGHER_HEAD_HEIGHT = 100;
    private int waveColor;
    protected float mWaveHeight;
    protected float mHeadHeight;
    private View mChildView;
    protected FrameLayout mHeadLayout;
    protected boolean isRefreshing;
    private float mTouchY;
    private float mCurrentY;
    private DecelerateInterpolator decelerateInterpolator;
    private MaterialHeadListener mMaterialHeadListener;
    private float headHeight;
    private float waveHeight;
    private int[] colorSchemeColors;
    private int colorsId;
    private int progressTextColor;
    private int progressValue;
    private int progressMax;
    private boolean showArrow;
    private int textType;
    private MaterialRefreshListener refreshListener;
    private boolean showProgressBg;
    private int progressBg;
    private boolean isShowWave;

    public MaterialRefreshLayout(Context context) {
        this(context, null, 0);
    }

    public MaterialRefreshLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaterialRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defstyleAttr) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.getChildCount() > 1) {
            throw new RuntimeException("can only have one child widget");
        }
        this.decelerateInterpolator = new DecelerateInterpolator(10.0f);
        TypedArray t = context.obtainStyledAttributes(attrs, R.styleable.MaterialRefreshLayout, defstyleAttr, 0);
        this.isOverlay = t.getBoolean(R.styleable.MaterialRefreshLayout_overlay, false);
        this.waveType = t.getInt(R.styleable.MaterialRefreshLayout_wave_height_type, 0);
        if (this.waveType == 0) {
            this.headHeight = this.DEFAULT_HEAD_HEIGHT;
            this.waveHeight = this.DEFAULT_WAVE_HEIGHT;
            MaterialWaveView.DefaulHeadHeight = this.DEFAULT_HEAD_HEIGHT;
            MaterialWaveView.DefaulWaveHeight = this.DEFAULT_WAVE_HEIGHT;
        } else {
            this.headHeight = this.hIGHER_HEAD_HEIGHT;
            this.waveHeight = this.HIGHER_WAVE_HEIGHT;
            MaterialWaveView.DefaulHeadHeight = this.hIGHER_HEAD_HEIGHT;
            MaterialWaveView.DefaulWaveHeight = this.HIGHER_WAVE_HEIGHT;
        }
        this.waveColor = t.getColor(R.styleable.MaterialRefreshLayout_wave_color, -1);
        this.isShowWave = t.getBoolean(R.styleable.MaterialRefreshLayout_wave_show, true);
        this.colorsId = t.getResourceId(R.styleable.MaterialRefreshLayout_progress_colors, R.array.material_colors);
        this.colorSchemeColors = context.getResources().getIntArray(this.colorsId);
        this.showArrow = t.getBoolean(R.styleable.MaterialRefreshLayout_progress_show_arrow, true);
        this.textType = t.getInt(R.styleable.MaterialRefreshLayout_progress_text_visibility, 1);
        this.progressTextColor = t.getColor(R.styleable.MaterialRefreshLayout_progress_text_color, -16777216);
        this.progressValue = t.getInteger(R.styleable.MaterialRefreshLayout_progress_value, 0);
        this.progressMax = t.getInteger(R.styleable.MaterialRefreshLayout_progress_max_value, 100);
        this.showProgressBg = t.getBoolean(R.styleable.MaterialRefreshLayout_progress_show_circle_backgroud, true);
        this.progressBg = t.getColor(R.styleable.MaterialRefreshLayout_progress_backgroud_color, -328966);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Context context = this.getContext();
        FrameLayout headViewLayout = new FrameLayout(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, 0);
        layoutParams.gravity = 48;
        headViewLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mHeadLayout = headViewLayout;
        this.addView((View)this.mHeadLayout);
        this.mChildView = this.getChildAt(0);
        if (this.mChildView == null) {
            return;
        }
        this.setWaveHeight(Util.dip2px(context, this.waveHeight));
        this.setHeaderHeight(Util.dip2px(context, this.headHeight));
        this.materialHeadView = new MaterialHeadView(context);
        this.materialHeadView.setWaveColor(this.isShowWave ? this.waveColor : -1);
        this.materialHeadView.showProgressArrow(this.showArrow);
        this.materialHeadView.setProgressColors(this.colorSchemeColors);
        this.materialHeadView.setProgressStokeWidth(3);
        this.materialHeadView.setTextType(this.textType);
        this.materialHeadView.setProgressTextColor(this.progressTextColor);
        this.materialHeadView.setProgressValue(this.progressValue);
        this.materialHeadView.setProgressValueMax(this.progressMax);
        this.materialHeadView.setIsProgressBg(this.showProgressBg);
        this.materialHeadView.setProgressBg(this.progressBg);
        this.setHeaderView((View)this.materialHeadView);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isRefreshing) {
            return true;
        }
        switch (ev.getAction()) {
            case 0: {
                this.mCurrentY = this.mTouchY = ev.getY();
                break;
            }
            case 2: {
                float currentY = ev.getY();
                float dy = currentY - this.mTouchY;
                if (!(dy > 0.0f) || this.canChildScrollUp()) break;
                if (this.materialHeadView != null) {
                    this.materialHeadView.onBegin(this);
                }
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent e) {
        if (this.isRefreshing) {
            return super.onTouchEvent(e);
        }
        switch (e.getAction()) {
            case 2: {
                this.mCurrentY = e.getY();
                float dy = this.mCurrentY - this.mTouchY;
                dy = Math.min(this.mWaveHeight * 2.0f, dy);
                dy = Math.max(0.0f, dy);
                if (this.mChildView != null) {
                    float offsetY = this.decelerateInterpolator.getInterpolation(dy / this.mWaveHeight / 2.0f) * dy / 2.0f;
                    float fraction = offsetY / this.mHeadHeight;
                    this.mHeadLayout.getLayoutParams().height = (int)offsetY;
                    this.mHeadLayout.requestLayout();
                    if (null != this.mMaterialHeadListener) {
                        this.mMaterialHeadListener.onPull(this, fraction);
                    }
                    if (this.materialHeadView != null) {
                        this.materialHeadView.onPull(this, fraction);
                    }
                    if (!this.isOverlay) {
                        ViewCompat.setTranslationY((View)this.mChildView, (float)offsetY);
                    }
                }
                return true;
            }
            case 1: 
            case 3: {
                if (this.mChildView != null) {
                    if (this.isOverlay) {
                        if ((float)this.mHeadLayout.getLayoutParams().height > this.mHeadHeight) {
                            this.updateListener();
                            this.mHeadLayout.getLayoutParams().height = (int)this.mHeadHeight;
                            this.mHeadLayout.requestLayout();
                        } else {
                            this.mHeadLayout.getLayoutParams().height = 0;
                            this.mHeadLayout.requestLayout();
                        }
                    } else if (ViewCompat.getTranslationY((View)this.mChildView) >= this.mHeadHeight) {
                        this.createAnimatorTranslationY(this.mChildView, this.mHeadHeight, this.mHeadLayout);
                        this.updateListener();
                    } else {
                        this.createAnimatorTranslationY(this.mChildView, 0.0f, this.mHeadLayout);
                        if (null != this.mMaterialHeadListener) {
                            // empty if block
                        }
                    }
                }
                return true;
            }
        }
        return super.onTouchEvent(e);
    }

    public void updateListener() {
        this.isRefreshing = true;
        if (this.materialHeadView != null) {
            this.materialHeadView.onRefreshing(this);
        }
        if (this.refreshListener != null) {
            this.refreshListener.onRefresh(this);
        }
        if (null != this.mMaterialHeadListener) {
            this.mMaterialHeadListener.onRefreshing(this);
        }
    }

    public void setProgressColors(int[] colors) {
        this.colorSchemeColors = colors;
    }

    public void setShowArrow(boolean showArrow) {
        this.showArrow = showArrow;
    }

    public void setShowProgressBg(boolean showProgressBg) {
        this.showProgressBg = showProgressBg;
    }

    public void setWaveColor(int waveColor) {
        this.waveColor = waveColor;
    }

    public void setWaveShow(boolean isShowWave) {
        this.isShowWave = isShowWave;
    }

    public void setIsOverLay(boolean isOverLay) {
        this.isOverlay = isOverLay;
    }

    public void setProgressValue(int progressValue) {
        this.progressValue = progressValue;
        this.materialHeadView.setProgressValue(progressValue);
    }

    public void createAnimatorTranslationY(final View v, float h, final FrameLayout fl) {
        ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)v);
        viewPropertyAnimatorCompat.setDuration(200L);
        viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
        viewPropertyAnimatorCompat.translationY(h);
        viewPropertyAnimatorCompat.start();
        viewPropertyAnimatorCompat.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

            public void onAnimationUpdate(View view) {
                float height = ViewCompat.getTranslationY((View)v);
                fl.getLayoutParams().height = (int)height;
                fl.requestLayout();
            }
        });
    }

    public boolean canChildScrollUp() {
        if (this.mChildView == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mChildView instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mChildView;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1) || this.mChildView.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mChildView, (int)-1);
    }

    public void setWaveHigher() {
        this.headHeight = this.hIGHER_HEAD_HEIGHT;
        this.waveHeight = this.HIGHER_WAVE_HEIGHT;
        MaterialWaveView.DefaulHeadHeight = this.hIGHER_HEAD_HEIGHT;
        MaterialWaveView.DefaulWaveHeight = this.HIGHER_WAVE_HEIGHT;
    }

    public void finishRefreshing() {
        if (this.mChildView != null) {
            ViewPropertyAnimatorCompat viewPropertyAnimatorCompat = ViewCompat.animate((View)this.mChildView);
            viewPropertyAnimatorCompat.setDuration(200L);
            viewPropertyAnimatorCompat.y(ViewCompat.getTranslationY((View)this.mChildView));
            viewPropertyAnimatorCompat.translationY(0.0f);
            viewPropertyAnimatorCompat.setInterpolator((Interpolator)new DecelerateInterpolator());
            viewPropertyAnimatorCompat.start();
            if (this.mMaterialHeadListener != null) {
                this.mMaterialHeadListener.onComlete(this);
            }
            if (this.materialHeadView != null) {
                this.materialHeadView.onComlete(this);
            }
            if (this.refreshListener != null) {
                this.refreshListener.onfinish();
            }
        }
        this.isRefreshing = false;
        this.progressValue = 0;
        this.setProgressValue(0);
    }

    public void finishRefresh() {
        this.post(new Runnable(){

            @Override
            public void run() {
                MaterialRefreshLayout.this.finishRefreshing();
            }
        });
    }

    public void setHeaderView(final View headerView) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MaterialRefreshLayout.this.mHeadLayout.addView(headerView);
            }
        });
    }

    public void setWaveHeight(float waveHeight) {
        this.mWaveHeight = waveHeight;
    }

    public void setHeaderHeight(float headHeight) {
        this.mHeadHeight = headHeight;
    }

    public void setBRHeadListener(MaterialHeadListener materialHeadListener) {
        this.mMaterialHeadListener = materialHeadListener;
    }

    public void setMaterialRefreshListener(MaterialRefreshListener refreshListener) {
        this.refreshListener = refreshListener;
    }
}

