package com.citrus.sdk.walletpg;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.payment.PaymentOption;
import com.google.gson.annotations.SerializedName;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by salil on 11/2/16.
 */
public class WalletConsumerProfile {

    /**
     * {
     * "merchantAccessKey":"F2VZD1HBS2VVXJPMWO77",
     * "username":null,
     * "amount":"1.0",
     * "currency":"INR",
     * "userDetails":{"firstName":"Vinay","lastName":"Setia","email":"vinay.setia@citruspay.com","mobile":"9987092676"},
     * "paymentOptionsList":[
     *                  {"paymentMode":"MVC","name":null,"savedCardToken":null,"cardNumber":null,"cardExpiryDate":null,"bank":null,"cardScheme":null,"issuerCode":null,"amount":"0","currency":"INR","selected":true,"shown":true,"defaultPaymentMode":false,"maxBalance":"0","campaignCode":"","cvv":null,"fingerPrint":null},
     *                  {"paymentMode":"PREPAID_CARD","name":"","savedCardToken":null,"cardNumber":null,"cardExpiryDate":null,"bank":null,"cardScheme":null,"issuerCode":null,"amount":"1.0","currency":"INR","selected":true,"shown":true,"defaultPaymentMode":false,"maxBalance":"24.0","campaignCode":null,"cvv":null,"fingerPrint":null},
     *                  {"paymentMode":"CREDIT_CARD","name":"Credit Card (1111)","savedCardToken":"cee50d09c70767ffa6e98b3dfda3c1d8","cardNumber":"XXXXXXXXXXXX1111","cardExpiryDate":"102017","bank":null,"cardScheme":"VISA","issuerCode":null,"amount":"0","currency":"","selected":false,"shown":false,"defaultPaymentMode":false,"maxBalance":null,"campaignCode":null,"cvv":null,"fingerPrint":"cee50d09c70767ffa6e98b3dfda3c1d8"}
     *                  ],
     * "statusMsg":"success"}
     * */

    @SerializedName( "userDetails" )
    private CitrusUser citrusUser;

    @SerializedName( "paymentOptionsList")
    private List<PaymentOption> paymentOptionList;

    public WalletConsumerProfile(CitrusUser citrusUser, List<PaymentOption> paymentOptionList) {
        this.citrusUser = citrusUser;
        this.paymentOptionList = paymentOptionList;
    }

    public CitrusUser getCitrusUser() {
        return citrusUser;
    }

    public List<PaymentOption> getPaymentOptionList() {
        return paymentOptionList;
    }

    public static WalletConsumerProfile fromJSON(String json) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        return fromJSONObject(jsonObject);
    }

    public static WalletConsumerProfile fromJSONObject(JSONObject jsonObject) {
        WalletConsumerProfile walletConsumerProfile = null;

        List<PaymentOption> paymentOptionList = null;
        JSONArray paymentOptionsArray = jsonObject.optJSONArray("paymentOptionsList");
        for (int i = 0; i < paymentOptionsArray.length(); i++) {
            JSONObject paymentOptionObject = paymentOptionsArray.optJSONObject(i);
            PaymentOption paymentOption = PaymentOption.fromJSONObject(paymentOptionObject, true);

            if (paymentOptionList == null) {
                paymentOptionList = new ArrayList<PaymentOption>();
            }

            paymentOptionList.add(paymentOption);
        }

        CitrusUser citrusUser = CitrusUser.fromJSONObject(jsonObject.optJSONObject("userDetails"));
        walletConsumerProfile = new WalletConsumerProfile(citrusUser, paymentOptionList);

        return walletConsumerProfile;
    }
}
