/*
 *
 *    Copyright 2014 Citrus Payment Solutions Pvt. Ltd.
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * /
 */

package com.citrus.sdk.response;

import android.os.Parcel;

import com.citrus.sdk.TransactionResponse;

/**
 * Created by salil on 12/5/15.
 */
public class CitrusError extends CitrusResponse {
    private final TransactionResponse transactionResponse;

    private int statusCode = -1 ;

    public CitrusError(String message, Status status) {
        super(message, status);
        transactionResponse = null;
    }

    public CitrusError(String message, Status status, TransactionResponse transactionResponse) {
        super(message, status);
        this.transactionResponse = transactionResponse;
    }

    public CitrusError(String message, String rawResponse, Status status, TransactionResponse transactionResponse) {
        super(message, rawResponse, status);
        this.transactionResponse = transactionResponse;
    }

    public TransactionResponse getTransactionResponse() {
        return transactionResponse;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable(this.transactionResponse, 0);
    }

    protected CitrusError(Parcel in) {
        super(in);
        this.transactionResponse = in.readParcelable(TransactionResponse.class.getClassLoader());
    }

    public static final Creator<CitrusError> CREATOR = new Creator<CitrusError>() {
        public CitrusError createFromParcel(Parcel source) {
            return new CitrusError(source);
        }

        public CitrusError[] newArray(int size) {
            return new CitrusError[size];
        }
    };


    public int getStatusCode() {
        return statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }
}
