package com.citrus.sdk.network.request;

import android.util.Log;

import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.HttpMethod;
import com.citrus.sdk.network.NetworkConstants;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

/**
 * Created by vinay on 22/4/16.
 */
public class ApiRequestBuilder {

    private final static String TAG = ApiRequestBuilder.class.getSimpleName() ;

    public static RequestBody buildStringRequestBody( final String stringBody ){
        return new RequestBody( REQUEST_BODY_TYPE.STRING , stringBody );
    }

    public static RequestBody buildJsonRequestBody( final JSONObject jsonObject ){
        return new RequestBody( REQUEST_BODY_TYPE.JSON , jsonObject );
    }

    public static RequestBody buildJsonRequestBody( final String jsonBody ){
        try {
            return new RequestBody( REQUEST_BODY_TYPE.JSON , new JSONObject(jsonBody));
        } catch (JSONException e) {
            e.printStackTrace();

            return null ;
        }
    }

    public static ApiRequest buildApi(final Api api , final Map<String, String> headers, final String authorizationToken,
                                      final Map<String, String> params, final RequestBody requestBody ){
        ApiRequest apiRequest = null ;
        Log.d( TAG, TAG +".buildApi(): building ApiRequest for "+api );

        if( api != null ){
            apiRequest = new ApiRequest() ;

            final HttpMethod httpMethod 		= api.getHttpMethod() ;
            final String bodyContentType 		= api.getBodyContentType() ;

            apiRequest.setName( api.name() );
            apiRequest.setHttpMethod( httpMethod );
            apiRequest.setRelativeUrl( api.getRelativeUrl() );
            apiRequest.setClazz( api.getClazz() );

            if( headers == null && authorizationToken == null ){
                Log.w( TAG, TAG +".buildApi(): WARNING: No headers for "+api.getRelativeUrl() );
            }else {
                if( authorizationToken != null ){
                    apiRequest.addHeader( NetworkConstants.BASE_AUTHORIZATION_HEADER_KEY , authorizationToken );
                }
                if( headers != null ){
                    apiRequest.addHeaders( headers );
                }
            }

            if( httpMethod != HttpMethod.GET ){
                if( bodyContentType == null ){
                    Log.w( TAG, TAG +".buildApi(): WARNING: bodyContentType is null for httpMethod "+httpMethod );
                }
                else{
                    apiRequest.setBodyContentType( bodyContentType ) ;

                    if( params == null && requestBody == null ){
                        Log.w( TAG, TAG +".buildApi(): WARNING: No body" );
                    }
                    else{
                        if( bodyContentType.equals( NetworkConstants.CONTENT_TYPE_FORM_ENCODED )){
                            if( params == null ){
                                Log.w( TAG, TAG +".buildApi(): WARNING: params null for bodyContentType "+bodyContentType );
                            }
                            else{
                                apiRequest.setParams( params );
                            }
                        }
                        else if( bodyContentType.equals( NetworkConstants.CONTENT_TYPE_JSON )){
                            if( requestBody == null ){
                                Log.w( TAG, TAG +".buildApi(): WARNING: body null for bodyContentType "+bodyContentType );
                            }
                            else{
                                apiRequest.setRequestBody( requestBody ) ;
                            }
                        }
                    }
                }
            }
        }
        return apiRequest ;
    }

    public static ApiRequest buildApi( final Api api , final Map<String, String> headers, final String authorizationToken,
                                       final Map<String, String> params, final RequestBody requestBody , final String... pathParams){
        final ApiRequest apiRequest = buildApi( api, headers, authorizationToken, params, requestBody ) ;

        if( api != null && pathParams != null ) {
            final String formattedRelativeUrl = String.format( api.getRelativeUrl(), pathParams );
            apiRequest.setRelativeUrl( formattedRelativeUrl );
        }
        return apiRequest ;
    }
}
