package com.citrus.sdk.network.request;

import com.citrus.sdk.network.HttpMethod;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by vinay on 1/4/16.
 */
public class ApiRequest {
    private String relativeUrl ;

    private RequestBody requestBody ;

    private Map<String, String> headers ;

    private HttpMethod httpMethod ;

    private String cancelTag ;

    private Map<String, String> params;

    private String bodyContentType ;

    private Class clazz ;

    private String name;

    ApiRequest() {
    }

    public String getRelativeUrl() { return relativeUrl; }

    public void setRelativeUrl(String relativeUrl) { this.relativeUrl = relativeUrl; }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void addHeaders(final Map<String, String> paramHeaders) {
        if( paramHeaders != null ) {
            if (headers == null) {
                headers = new HashMap<>() ;
            }
            headers.putAll(paramHeaders);
        }
    }

    public void addHeader( final String key, final String value) {
        if( key != null && value != null ){
            if (headers == null) {
                headers = new HashMap<>() ;
            }
            headers.put( key, value );
        }
    }

    public HttpMethod getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getCancelTag() { return cancelTag; }

    public void setCancelTag(String cancelTag) { this.cancelTag = cancelTag; }

    public Map<String, String> getParams() { return params; }

    public void setParams(Map<String, String> params) { this.params = params; }

    public String getBodyContentType() { return bodyContentType; }

    public void setBodyContentType(String bodyContentType) { this.bodyContentType = bodyContentType; }

    public Class getClazz() { return clazz; }

    public void setClazz(Class clazz) { this.clazz = clazz; }

    public RequestBody getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public void setName(String name) { this.name = name; }

    public String getName() { return name; }

    @Override
    public String toString() {
        return super.toString() + '|' +httpMethod+ '|' +relativeUrl + '|' +clazz ;
    }


}

