package com.citrus.sdk.network;

import android.text.TextUtils;
import android.util.Log;

import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.citrus.sdk.payment.PaymentOption;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import java.lang.reflect.Type;

/**
 * Created by vinay on 13/4/16.
 */
public class PaymentOptionAdapter implements JsonDeserializer<PaymentOption> {
    private final static String TAG = PaymentOptionAdapter.class.getSimpleName() ;

    @Override
    public PaymentOption deserialize(JsonElement jsonElement, Type typeOfT,
                                     JsonDeserializationContext context) throws JsonParseException {
        Log.i( TAG, TAG+".deserialize(): "+jsonElement+", typeOfT = "+typeOfT );

        final JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement typeJsonElement = jsonObject.get("type") ;
        if( typeJsonElement == null ){
            typeJsonElement = jsonObject.get("paymentMode") ;
        }
        final String type = typeJsonElement.getAsString() ;

        Log.i( TAG, TAG+".deserialize(): type = "+type );

        final Gson gson = new Gson() ;
        PaymentOption paymentOptionReturn = null ;
        if (TextUtils.equals("credit", type) || TextUtils.equals("CREDIT_CARD", type)) {

            CreditCardOption creditCardOption = gson.fromJson(jsonObject, CreditCardOption.class) ;
            paymentOptionReturn = creditCardOption ;

        } else if (TextUtils.equals("debit", type) || TextUtils.equals("DEBIT_CARD", type)) {
            DebitCardOption debitCardOption = gson.fromJson(jsonObject, DebitCardOption.class) ;
            paymentOptionReturn = debitCardOption ;

        } else if (TextUtils.equals("netbanking", type) || TextUtils.equals("NET_BANKING", type)) {
            NetbankingOption netbankingOption = gson.fromJson(jsonObject, NetbankingOption.class) ;
            paymentOptionReturn = netbankingOption ;

        } else if (TextUtils.equals("MVC", type)) {
            MVCOption mvcOption = gson.fromJson(jsonObject, MVCOption.class) ;
            paymentOptionReturn = mvcOption ;

        } else if (TextUtils.equals("PREPAID_CARD", type)) {
            CitrusCash citrusCash = gson.fromJson(jsonObject, CitrusCash.class) ;
            paymentOptionReturn = citrusCash ;

        }
        return paymentOptionReturn;
    }

}
