package com.citrus.sdk.network;


import com.citrus.sdk.AddCardResponse;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.AccessToken;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.BinServiceResponse;
import com.citrus.sdk.classes.CardBinDetails;
import com.citrus.sdk.classes.CashoutInfo;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.classes.CitrusUMResponse;
import com.citrus.sdk.classes.LinkUserExtendedResponse;
import com.citrus.sdk.classes.LinkUserResponse;
import com.citrus.sdk.classes.LinkUserVerifyEOTPUpdateMobile;
import com.citrus.sdk.classes.MemberInfo;
import com.citrus.sdk.classes.PGHealthResponse;
import com.citrus.sdk.classes.StructResponsePOJO;
import com.citrus.sdk.classes.UpdateMobileResponse;
import com.citrus.sdk.classes.UserBind;
import com.citrus.sdk.classes.VerifyMobileResponse;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.payment.MerchantPaymentOption;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.response.CitrusResponse;
import com.citrus.sdk.response.PaymentResponse;
import com.citrus.sdk.response.SubscriptionResponse;
import com.citrus.sdk.walletpg.WalletConsumerProfile;
import com.citrus.sdk.walletpg.WalletPGPaymentResponse;

/**
 * Created by vinay on 6/4/16.
 */

public enum Api {

    GET_BILL(   "",
                HttpMethod.GET,
                null,
                PaymentBill.class) ,


    PG_MOTO_REQUEST( "/service/moto/authorize/struct/payment" ,
                    HttpMethod.POST,
                    NetworkConstants.CONTENT_TYPE_JSON ,
                    StructResponsePOJO.class ) ,

    PG_SAVE_CARD(   "/service/v2/profile/me/newpayment",
                    HttpMethod.PUT,
                    NetworkConstants.CONTENT_TYPE_JSON ,
                    AddCardResponse.class )  ,

    /** @FormUrlEncoded
     @POST("/service/v1/merchant/pgsetting")
     Call<JsonElement> getMerchantPaymentOptions(@Field("vanity") String vanity); */
    PG_MERCHANT_PAYMENT (   "/service/v1/merchant/pgsetting",
                            HttpMethod.POST,
                            NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                            MerchantPaymentOption.class ) ,

    /** @Headers("Content-Type: application/json")
     @PUT( "/service/v2/profile/me/payment" )
     Call<CitrusResponse> setDefaultPaymentOption(@Header("Authorization") String header, @Body RequestBody body); */
    PG_SET_DEFAULT_PAYMENT_OPTION (     "/service/v2/profile/me/payment",
                                        HttpMethod.PUT,
                                        NetworkConstants.CONTENT_TYPE_JSON ,
                                        CitrusResponse.class ) ,

    /** @Headers("Content-Type: application/json")
     @PUT( "/service/v2/profile/me/payment" )
     Call<CitrusResponse> savePaymentOption(@Header("Authorization") String header, @Body RequestBody body); */
    PG_SAVE_PAYMENT_OPTION (    "/service/v2/profile/me/payment" ,
                                HttpMethod.PUT,
                                NetworkConstants.CONTENT_TYPE_JSON ,
                                CitrusResponse.class ) ,

    /** @DELETE( "/service/v2/profile/me/deletepayment/{token}" )
    Call<JsonElement> deletePaymentOption(@Header("Authorization") String header, @Path("token") String token); */
    PG_DELETE_PAYMENT_OPTION (  "/service/v2/profile/me/deletepayment/%s" ,
                                HttpMethod.DELETE ,
                                null ,
                                CitrusResponse.class ) ,

    /**       @GET( "/cards/metadata/{token}" )
    Call<JsonElement> getBinInfoUsingToken(@Path("token") String token);*/
    PG_GET_BIN_INFO_USING_TOKEN (   "/cards/metadata/%s" ,
                                    HttpMethod.GET ,
                                    null ,
                                    BinServiceResponse.class ) ,

    /** @GET( "/utility/{path}/merchantName" ) */
    PG_GET_MERCHANT_NAME (  "/utility/%s/merchantName" ,
                            HttpMethod.GET ,
                            null ,
                            null ) ,

    /**     @GET( "/binservice/v2/bin/{first6Digits}" )
    Call<JsonElement> getCardType(@Path("first6Digits") String first6Digits); */
    BIN_GET_CARD_TYPE(   "/binservice/v2/bin/%s" ,
                            HttpMethod.GET ,
                            null ,
                            CardBinDetails.class) ,

    /**@GET("/binservice/v2/bin/{first6Digits}")
    Call<JsonElement> getBinInfo(@Path("first6Digits") String first6Digits); */
    BIN_GET_INFO(    "/binservice/v2/bin/%s" ,
                        HttpMethod.GET ,
                        null ,
                        BinServiceResponse.class) ,


    /** @Headers("Content-Type: application/json")
     @POST( "/moto/makePayment" )
     Call<ResponseBody> newMakePayment(@Body RequestBody body); */
    CITRUSBASE_NEW_MAKE_PAYMENT (   "/moto/makePayment" ,
                                    HttpMethod.POST ,
                                    NetworkConstants.CONTENT_TYPE_JSON ,
                                    null) ,

    /** @FormUrlEncoded
     @POST( "/utility/{path}/pgHealth" )
     Call<PGHealthResponse> getPGHealth(@Path("path") String path, @Field("bankCode") String bankCode); */
    CITRUSBASE_GET_PG_HEALTH (  "/utility/%s/pgHealth" ,
                                HttpMethod.POST ,
                                NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                                PGHealthResponse.class) ,


    /** @Headers("Content-Type: application/json")
     @POST( "/{dp_path}/dynamicpricing/performDynamicPricing" )
     Call<JsonElement> performDynamicPricing(@Path("dp_path") String dpPath, @Body RequestBody body);
     */
    DYNAMIC_PRICING_PERFORM (  "/%s/dynamicpricing/performDynamicPricing",
                                HttpMethod.POST ,
                                NetworkConstants.CONTENT_TYPE_JSON ,
                                DynamicPricingResponse.class) ,


    /** @Headers("Content-Type: application/json")
     @POST( "/rest/v1/orangepocket/pay" )
     Call<ResponseBody> walletPGCharge(@Header("Authorization") String header, @Body RequestBody body); */
    WALLET_PG_CHARGE (  "/rest/v1/orangepocket/pay",
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_JSON ,
                        WalletPGPaymentResponse.class) ,

    /** @FormUrlEncoded
     @POST( "/wallet/v1/orangepocket/profile/fetchConsumerProfile" )
     Call<ResponseBody> fetchConsumerProfile(@Header("Authorization") String header,
     @Field("amount") String amount, @Field("currency") String currency);
     */
    WALLET_PG_FETCH_CONSUMER_PROFILE(  "/wallet/v1/orangepocket/profile/fetchConsumerProfile",
                                        HttpMethod.POST ,
                                        NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                                        WalletConsumerProfile.class) ,


    /** @FormUrlEncoded
     @POST( "/oauth/token" )
     Call<AccessToken> getSignUpToken(@Field("client_id") String client_ID,
     @Field("client_secret") String client_Secret,
     @Field("grant_type") String grantType); */
     GET_SIGNUP_TOKEN(  "/oauth/token" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                        AccessToken.class ) ,


    /** @FormUrlEncoded
     @POST( "/service/v2/identity/bind" )
     Call<UserBind> getBindResponse(@Header("Authorization") String header,
     @Field("email") String email,
     @Field("mobile") String mobile); */
     GET_BIND_RESPONSE(  "/service/v2/identity/bind" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                        UserBind.class ) ,

    /** @Headers("Content-Type: application/json")
     @POST("/service/um/profile/memberInfo")
     Call<JsonElement> getMemberInfo(@Header("Authorization") String header, @Body RequestBody body); */
    GET_MEMBER_INFO (  "/service/um/profile/memberInfo" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_JSON  ,
                        MemberInfo.class ) ,

    /** @FormUrlEncoded
     @POST( "/service/um/identity/bind/mobile" )
     Call<UserBind> bindUserByMobile(@Header("Authorization") String header,
     @Field("email") String email,
     @Field("mobile") String mobile); */
    UM_BIND_USER_BY_MOBILE (    "/service/um/identity/bind/mobile" ,
                                HttpMethod.POST ,
                                NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                                UserBind.class ) ,

    /** @FormUrlEncoded
     @POST("/service/v2/identity/passwords/reset")
     Call<JsonElement>  resetPassword(@Header("Authorization") String header, @Field("username") String username); */
    UM_RESET_PASSWORD (     "/service/v2/identity/passwords/reset" ,
                            HttpMethod.POST ,
                            NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                            UserBind.class ) ,


    /** @Headers("Content-Type: application/json")
     @POST( "/service/um/link/user" )
     Call<LinkUserResponse> linkUser(@Header("Authorization") String signUpToken, @Body RequestBody body); */
     UM_LINK_USER (     "/service/um/link/user" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_JSON  ,
                        LinkUserResponse.class ) ,
    /**    @FormUrlEncoded
     @PUT( "/service/v2/identity/me/password" )
     Call<ResponseBody> setPassword(@Header("Authorization") String header, @Field("old") String oldPassword, @Field("new") String newPassword);
     */
    UM_SET_PASSWORD (  "/service/v2/identity/me/password" ,
                       HttpMethod.PUT ,
                       NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                       UserBind.class ) ,

    /**     @Headers("Content-Type: application/json")
     @POST( "/service/um/mobileverification/sendCode" )
     Call<UpdateMobileResponse> updateMobile(@Header("Authorization") String accessToken, @Body RequestBody body); */
    UM_UPDATE_MOBILE (  "/service/um/mobileverification/sendCode" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_JSON  ,
                        UpdateMobileResponse.class ) ,

    /**  @Headers("Content-Type: application/json")
     @POST( "/service/um/mobileverification/verifyCode" )
     Call<VerifyMobileResponse> verifyMobile(@Header("Authorization") String accessToken, @Body RequestBody body);
     */
    UM_VERIFY_MOBILE (  "/service/um/mobileverification/verifyCode" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_JSON  ,
                        VerifyMobileResponse.class ) ,

    /** @GET( "/service/um/profile/profileInfo" )
     Call<JsonElement> getProfileInfo(@Header("Authorization") String token); */
    UM_GET_PROFILE_INFO (   "/service/um/profile/profileInfo" ,
                            HttpMethod.GET ,
                            null ,
                            CitrusUser.class ) ,


    /** @FormUrlEncoded
     @PUT( "/service/um/user/change/password" )
     Call<CitrusUMResponse>  changePassword(@Header("Authorization") String header,@Field("old") String oldPassword,
     @Field("new") String newPassword);
     */
    UM_CHANGE_PASSWORD (   "/service/um/user/change/password" ,
                            HttpMethod.PUT ,
                            NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                            CitrusUMResponse.class ),


    /**    @Headers("Content-Type: application/json")
     @PUT( "/service/um/profile/update" )
     Call<CitrusUMResponse>  updateUserProfileDetails(@Header("Authorization") String header, @Body RequestBody body);
     */
    UM_UPDATE_USER_PROFILE (   "/service/um/profile/update" ,
                                HttpMethod.PUT ,
                                NetworkConstants.CONTENT_TYPE_JSON  ,
                                CitrusUMResponse.class ),


    /**     @Headers("Content-Type: application/json")
     @POST( "/service/um/otp/generate" )
     Call<CitrusUMResponse>  sendOneTimePassword(@Body RequestBody body); */
    UM_SEND_ONE_TIME_PASSWORD (     "/service/um/otp/generate" ,
                                    HttpMethod.POST ,
                                    NetworkConstants.CONTENT_TYPE_JSON  ,
                                    CitrusUMResponse.class ),


    /**  @FormUrlEncoded
     @POST( "/service/um/user/reset/password" )
     Call<CitrusUMResponse> resetUMPassword(@Header("Authorization") String header, @Field("username") String username); */
    UM_RESET_USER_PASSWORD (    "/service/um/user/reset/password" ,
                                HttpMethod.POST ,
                                NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                                CitrusUMResponse.class ),


    /**  @FormUrlEncoded
     @POST( "/service/um/user/signup" )
     Call<CitrusUMResponse>  signUpUser(@Header("Authorization")
     String header,@Field("email") String email,        @Field("mobile") String mobile,         @Field("password") String password,
     @Field("firstName") String firstName,              @Field("lastName") String lastName,
     @Field("sourceType") String sourceType,
     @Field("markMobileVerified") String markMobileVerified, @Field("markEmailVerified") String markEmailVerified);
     */
    UM_SIGN_UP_USER (   "/service/um/user/signup" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                        CitrusUMResponse.class ),


    /**     @Headers("Content-Type: application/json")
     @POST( "/service/um/link/user/extended" )
     Call<JsonElement> linkUserExtended(@Header("Authorization") String signUpToken, @Body RequestBody body);
     */
    UM_LINK_USER_EXTENDED (  "/service/um/link/user/extended" ,
                            HttpMethod.POST ,
                            NetworkConstants.CONTENT_TYPE_JSON  ,
                            LinkUserExtendedResponse.class ),


    /** @FormUrlEncoded
     @POST( "/service/um/verifyEOTPAndUpdateMobile" )
     Call<LinkUserVerifyEOTPUpdateMobile> linkUserExtendedVerifyEOTPAndUpdateMobile(@Header("Authorization")
     String signUpToken,
     @Field("grant_type") String grant_type, @Field("client_id") String client_ID,
     @Field("client_secret") String client_Secret, @Field("username") String username, @Field("password")
     String password, @Field("requestedMobile") String requestedMobile);
     */
    UM_LINK_USER_EXTENDED_VERIFY_EOTP_AND_UPDATE_MOBILE (    "/service/um/verifyEOTPAndUpdateMobile" ,
                                                            HttpMethod.POST ,
                                                            NetworkConstants.CONTENT_TYPE_FORM_ENCODED  ,
                                                            LinkUserVerifyEOTPUpdateMobile.class ),


    /**     @Headers("Content-Type: application/json")
     @POST( "/service/um/verifyMobileAndSignIn" )
     Call<AccessToken> linkUserExtendedVerifyMobileAndSignIn(@Header("Authorization") String signUpToken, @Body RequestBody body);
     */
    UM_LINK_USER_EXTENDED_VERIFY_MOBILE_AND_SIGN_IN (   "/service/um/verifyMobileAndSignIn" ,
                                                        HttpMethod.POST ,
                                                        NetworkConstants.CONTENT_TYPE_JSON  ,
                                                        AccessToken.class ),


    /**   @GET( "/service/v2/token/validate" )
    Call<JsonElement> getPrepaymentTokenValidity(@Header("Authorization") String signupToken,
     @Header("OwnerAuthorization") String prepaymentToken,
     @Header("OwnerScope") String scope);
     */
    PREPAID_IS_PREPAID_TOKEN_VALID (    "/service/v2/token/validate" ,
                                        HttpMethod.GET ,
                                        null ,
                                        null) ,

    /** FormUrlEncoded
     @POST( "/service/v2/prepayment/load" )
     Call<CitrusPrepaidBill> getPrepaidBill(@Header("Authorization") String header, @Field("amount") String amount,
     @Field("currency") String currency, @Field("redirect") String redirectURL);
     */
    PREPAID_GET_PREPAID_BILL ( "/service/v2/prepayment/load" ,
                                HttpMethod.POST ,
                                NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                                CitrusPrepaidBill.class ),


    /**@POST( "/service/v2/mycard/balance" )
     @FormUrlEncoded
     Call<Amount> getBalance(@Header("Authorization") String header, @Field("dummy") String dummyObject); */
    PREPAID_GET_BALANCE (   "/service/v2/mycard/balance" ,
                            HttpMethod.POST ,
                            NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                            Amount.class ),


    /** @GET( "/service/v2/prepayment/balance" )
    Call<Amount> activatePrepaidUser(@Header("Authorization") String header);
     */
    PREPAID_ACTIVATE_PREPAID_USER(  "/service/v2/prepayment/balance" ,
                                    HttpMethod.GET ,
                                    null ,
                                    Amount.class ),

    /**  @Headers("Content-Type: application/json")
     @POST( "/service/v2/prepayment/prepaid_pay" )
     Call<JsonElement> newPrepaidPay(@Header("Authorization") String header, @Body RequestBody body);
     */
    PREPAID_NEW_PREPAID_PAY(    "/service/v2/prepayment/prepaid_pay" ,
                                HttpMethod.POST ,
                                NetworkConstants.CONTENT_TYPE_JSON ,
                                PaymentResponse.class ),


    /** @FormUrlEncoded
     @POST( "/service/v2/prepayment/transfer" )
     Call<PaymentResponse> sendMoneyByEmail(@Header("Authorization") String header, @Field("amount") String amount,
     @Field("currency") String currency, @Field("message") String message, @Field("to") String emailId);
     */
    PREPAID_SEND_MONEY_BY_EMAIL (   "/service/v2/prepayment/transfer",
                                    HttpMethod.POST ,
                                    NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                                    PaymentResponse.class ),


    /** @FormUrlEncoded
     @POST( "/service/v2/prepayment/transfer/extended" )
     Call<PaymentResponse> sendMoneyByMobile(@Header("Authorization") String header, @Field("amount") String amount,
     @Field("currency") String currency, @Field("message") String message, @Field("to") String mobileNo);
     */
    PREPAID_SEND_MONEY_BY_MOBILE (  "/service/v2/prepayment/transfer/extended",
                                    HttpMethod.POST ,
                                    NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                                    PaymentResponse.class ),


    /** @FormUrlEncoded
     @POST( "/service/v2/prepayment/cashout" )
     Call<PaymentResponse> cashout(@Header("Authorization") String header, @Field("amount") String amount,
     @Field("currency") String currency, @Field("owner") String owner,
     @Field("account") String accountNo, @Field("ifsc") String ifscCode);
     */
    PREPAID_CASHOUT (   "/service/v2/prepayment/cashout" ,
                        HttpMethod.POST ,
                        NetworkConstants.CONTENT_TYPE_FORM_ENCODED ,
                        PaymentResponse.class ),

    /**  @GET( "/service/v2/profile/me/prepaid" )
    Call<JsonElement> getCashoutInfo(@Header("Authorization") String header);
     */
    PREPAID_GET_CASHOUT_INFO (  "/service/v2/profile/me/prepaid" ,
                                HttpMethod.GET ,
                                null,
                                CashoutInfo.class ),


    /** @Headers("Content-Type: application/json")
     @PUT( "/service/v2/profile/me/prepaid" )
     {"cashoutAccount":{"owner":"Yadnesh Wankhede","branch":"HSBC0000123","number":"123456789987654"},"type":"prepaid","currency":"INR"}
     Call<JsonElement> saveCashoutInfo(@Header("Authorization") String header, @Body RequestBody body);
     */
    PREPAID_SAVE_CASHOUT_INFO ( "/service/v2/profile/me/prepaid" ,
                                HttpMethod.PUT ,
                                NetworkConstants.CONTENT_TYPE_JSON,
                                null ),

   /** @GET( "/service/v2/subscription/get?status=active" )
    void getActiveSubscription(@Header("Authorization") String header, Callback<List<SubscriptionResponse>> callback);*/
    PREPAID_GET_ACTIVE_SUBSCRIPTION (   "/service/v2/subscription/get?status=active",
                                        HttpMethod.GET ,
                                        null,
                                        null),   // Pass a Type instead of a Class.

    /** @FormUrlEncoded
     @PUT("/service/v2/subscription/update")
     void deActivateSubscription(@Header("Authorization") String header, @Field("subscriptionId") String subscriptionID,
     @Field( "status" ) String status, Callback<SubscriptionResponse> callback);
     */
    PREPAID_DEACTIVATE_SUBSCRIPTION (   "/service/v2/subscription/update",
                                        HttpMethod.PUT ,
                                        NetworkConstants.CONTENT_TYPE_FORM_ENCODED,
                                        SubscriptionResponse.class ),

    /** @FormUrlEncoded
     @POST( "/service/v2/subscription/create" )
     void createSubscriptionWithCard(@Header("Authorization") String header, @Field("pan") String pan, @Field("expiry") String expiry,
     @Field("holder") String holder, @Field("authRefId") String refID, @Field("thresholdAmount") String thresholdAmount,
     @Field("loadAmount") String loadAmount, @Field("type") String type,
     Callback<SubscriptionResponse> callback);
     */
    PREPAID_CREATE_SUBSCRIPTION (   "/service/v2/subscription/create" ,
                                    HttpMethod.POST ,
                                    NetworkConstants.CONTENT_TYPE_FORM_ENCODED,
                                    SubscriptionResponse.class ),

    /**  @FormUrlEncoded
     @POST( "/service/v2/subscription/create" )
     void createSubscriptionWithToken(@Header("Authorization") String header,
     @Field( "authRefId" ) String refID, @Field("thresholdAmount") String thresholdAmount,
     @Field( "loadAmount" ) String loadAmount, @Field("type") String type, @Field("token") String token, \
     Callback<SubscriptionResponse> callback);
     */
    /* Use same API PREPAID_CREATE_SUBSCRIPTION with different parameters */


    /** @FormUrlEncoded
     @PUT( "/service/v2/subscription/update" )
     void updateSubscriptiontoLowerValue(@Header("Authorization") String header, @Field("subscriptionId") String subscriptionID,
     @Field("thresholdAmount") String thresholdAmount, @Field("loadAmount") String loadAmount,
     Callback<SubscriptionResponse> callback);
     */
    PREPAID_UPDATE_SUBSCRIPTION (   "/service/v2/subscription/update" ,
                                    HttpMethod.PUT ,
                                    NetworkConstants.CONTENT_TYPE_FORM_ENCODED,
                                    SubscriptionResponse.class ) ;

    /**  @FormUrlEncoded
     @PUT("/service/v2/subscription/update")
     void updateSubscriptiontoHigherValue(@Header("Authorization") String header, @Field("subscriptionId") String subscriptionID,
     @Field("thresholdAmount") String thresholdAmount, @Field("loadAmount") String loadAmount,
     @Field("authRefId") String authRefID,
     Callback<SubscriptionResponse> callback);
      */
    /* Use same API PREPAID_UPDATE_SUBSCRIPTION with different parameters */

    private final String relativeUrl;
    private final HttpMethod httpMethod ;
    private final String bodyContentType ;
    private final Class clazz ;


    Api ( final String relativeUrl, final HttpMethod method,
          final String bodyContentType, final Class clazz) {
        this.relativeUrl 		= relativeUrl ;
        this.httpMethod  		= method ;
        this.bodyContentType 	= bodyContentType ;
        this.clazz				= clazz ;
    }

    public String getRelativeUrl() {
        return relativeUrl;
    }

    public HttpMethod getHttpMethod() {
        return httpMethod;
    }

    public String getBodyContentType() {
        return bodyContentType;
    }

    public Class getClazz() {
        return clazz;
    }

    /* public String getName() {
        return name;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public RequestBody getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public String getAuthorizationToken() {
        return authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }*/
}
