package com.citrus.sdk.login;

import com.citrus.sdk.classes.LinkUserSignInType;

/**
 * Created by salil on 10/5/16.
 */
public enum AvailableLoginType {

    LOGIN_WITH_OTP, LOGIN_WITH_PASSWORD, LOGIN_WITH_OTP_OR_PASSWORD, LOGIN_WITH_LIMITED_ACCESS, LOGIN_NONE;

    public static AvailableLoginType getAvailableLoginType(LinkUserSignInType linkUserSignInType) {
        switch (linkUserSignInType) {
            case SignInTypeMOtp:
                return LOGIN_WITH_OTP;

            case SignInTypePassword:
                return LOGIN_WITH_PASSWORD;

            case SignInTypeMOtpOrPassword:
                return LOGIN_WITH_OTP_OR_PASSWORD;

            case SignInTypeLimitedScope:
                return LOGIN_WITH_LIMITED_ACCESS;

            default:
                return LOGIN_NONE;
        }
    }
}
