package com.citrus.sdk.classes;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by vinay on 14/4/16.
 */
public class AllBanksHealth {

    private Map<String,PGHealth> pgHealthMap ;

    private static AllBanksHealth instance ;

    private AllBanksHealth() { }

    public static AllBanksHealth getInstance() {
        if( instance == null){
            instance = new AllBanksHealth() ;
            instance.clear();
        }

        return instance ;
    }

    public Map<String, PGHealth> getPgHealthMap() {
        return pgHealthMap;
    }

    public void setPgHealthMap(Map<String, PGHealth> pgHealthMap) {
        this.pgHealthMap = pgHealthMap;
    }

    public void addHealthForBank( final String bankCID, final PGHealth health ){
        if( pgHealthMap == null ){
            pgHealthMap = new  HashMap<String, PGHealth>() ;
        }

        pgHealthMap.put( bankCID, health );
    }

    public void clear( ){
        if( pgHealthMap != null ){
            pgHealthMap.clear() ;
        }
    }

    public PGHealth getHealth( final String bankCID){
        if( pgHealthMap != null ){
            return  pgHealthMap.get( bankCID ) ;
        }

        return null ;
    }

}
