/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.walletpg;

import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.TransactionResponse;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.PaymentOption;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WalletPGPaymentResponse {
    private String redirectUrl;
    private String responseCode;
    private TransactionResponse.TransactionStatus transactionStatus;
    private String description;
    private String transactionId;
    private CitrusUser citrusUser;
    private String signature;
    private Amount transactionAmount;
    private List<PaymentOption> listPaymentOptions;
    private String authIdCode;
    private String issuerRefNo;
    private String pgTxnId;
    private String pgRespCode;

    public WalletPGPaymentResponse(String redirectUrl, String responseCode, TransactionResponse.TransactionStatus transactionStatus, String description, String transactionId, CitrusUser citrusUser, String signature, Amount transactionAmount, List<PaymentOption> listPaymentOptions, String authIdCode, String issuerRefNo, String pgTxnId) {
        this.redirectUrl = redirectUrl;
        this.responseCode = responseCode;
        this.transactionStatus = transactionStatus;
        this.description = description;
        this.transactionId = transactionId;
        this.citrusUser = citrusUser;
        this.signature = signature;
        this.transactionAmount = transactionAmount;
        this.listPaymentOptions = listPaymentOptions;
        this.authIdCode = authIdCode;
        this.issuerRefNo = issuerRefNo;
        this.pgTxnId = pgTxnId;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public TransactionResponse.TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public String getSignature() {
        return this.signature;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public List<PaymentOption> getListPaymentOptions() {
        return this.listPaymentOptions;
    }

    public static WalletPGPaymentResponse fromJSON(String json) {
        WalletPGPaymentResponse walletPGPaymentResponse = null;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                String redirectUrl = jsonObject.optString("redirectUrl");
                String responseCode = jsonObject.optString("responseCode");
                String txnStatus = jsonObject.optString("txnStatus");
                TransactionResponse.TransactionStatus transactionStatus = TransactionResponse.TransactionStatus.getTransactionStatus(txnStatus);
                JSONObject txnMsg = jsonObject.optJSONObject("txnMsg");
                String description = txnMsg.optString("description");
                String transactionId = txnMsg.optString("merchantTransactionId");
                String amount = txnMsg.optString("amount");
                String currency = txnMsg.optString("currency");
                Amount transactionAmount = new Amount(amount, currency);
                String signature = txnMsg.optString("signature");
                JSONObject userDetails = txnMsg.optJSONObject("userDetails");
                CitrusUser citrusUser = CitrusUser.fromJSONObject(userDetails, false);
                JSONArray paymentDetailsArray = jsonObject.optJSONArray("paymentDetailsLst");
                ArrayList<CitrusCash> paymentOptionList = null;
                if (paymentDetailsArray != null) {
                    for (int i = 0; i < paymentDetailsArray.length(); ++i) {
                        JSONObject paymentOptionObject = paymentDetailsArray.optJSONObject(i);
                        String paymentMode = paymentOptionObject.optString("paymentMode");
                        String amountValue = paymentOptionObject.optString("amount");
                        String currencyValue = paymentOptionObject.optString("currency");
                        PaymentOption paymentOption = null;
                        if ("PREPAID_CARD".equalsIgnoreCase(paymentMode)) {
                            paymentOption = new CitrusCash(new Amount(amountValue, currencyValue));
                        } else if ("MVC".equalsIgnoreCase(paymentMode)) {
                            paymentOption = new MVCOption(new Amount(amountValue, currencyValue), null);
                        }
                        if (paymentOption == null) continue;
                        if (paymentOptionList == null) {
                            paymentOptionList = new ArrayList<CitrusCash>();
                        }
                        paymentOptionList.add((CitrusCash)paymentOption);
                    }
                }
                String authIdCode = txnMsg.optString("authIdCode");
                String issuerRefNo = txnMsg.optString("issuerRefNo");
                String pgTxnId = txnMsg.optString("pgTxnId");
                walletPGPaymentResponse = new WalletPGPaymentResponse(redirectUrl, responseCode, transactionStatus, description, transactionId, citrusUser, signature, transactionAmount, paymentOptionList, authIdCode, issuerRefNo, pgTxnId);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return walletPGPaymentResponse;
    }

    public final String getURLEncodedParams() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("pgTxnNo=");
        buffer.append(this.pgTxnId);
        buffer.append("&issuerRefNo=");
        buffer.append(this.issuerRefNo);
        buffer.append("&authIdCode=");
        buffer.append(this.authIdCode);
        buffer.append("&TxId=");
        buffer.append(this.getTransactionId());
        if (this.transactionAmount != null) {
            buffer.append("&amount=");
            buffer.append(this.transactionAmount.getValueAsDouble());
            buffer.append("&currency=");
            buffer.append(this.transactionAmount.getCurrency());
        }
        if (this.transactionStatus != null) {
            String status = "";
            String description = "";
            String pgRespCode = "";
            switch (this.transactionStatus) {
                case SUCCESSFUL: {
                    status = "Success";
                    description = "Transaction Successful";
                    pgRespCode = "0";
                    break;
                }
                case FAILED: {
                    status = "Fail";
                    description = "Transaction Failed";
                    pgRespCode = "1";
                    break;
                }
                case CANCELLED: {
                    status = "CANCELED";
                    description = "Transaction Cancelled By User";
                    pgRespCode = "3";
                }
            }
            buffer.append("&TxStatus=");
            buffer.append(status);
            buffer.append("&description=");
            buffer.append(description);
            buffer.append("&TxMsg=");
            buffer.append(description);
            buffer.append("&pgRespCode=");
            buffer.append(pgRespCode);
        }
        buffer.append("&signature=");
        buffer.append(this.signature);
        buffer.append("&paymentMode=WALLET");
        if (this.citrusUser != null) {
            buffer.append("&firstName=");
            buffer.append(this.citrusUser.getFirstName());
            buffer.append("&lastName=");
            buffer.append(this.citrusUser.getLastName());
            buffer.append("&email=");
            buffer.append(this.citrusUser.getEmailId());
            buffer.append("&mobileNo=");
            buffer.append(this.citrusUser.getMobileNo());
            CitrusUser.Address address = this.citrusUser.getAddress();
            if (address != null) {
                buffer.append("&addressStreet1=");
                buffer.append(address.getStreet1());
                buffer.append("&addressStreet2=");
                buffer.append(address.getStreet2());
                buffer.append("&mobileNo=");
                buffer.append(this.citrusUser.getMobileNo());
                buffer.append("&addressCity=");
                buffer.append(address.getCity());
                buffer.append("&addressCountry=");
                buffer.append(address.getCountry());
                buffer.append("&addressState=");
                buffer.append(address.getState());
                buffer.append("&addressZip=");
                buffer.append(address.getZip());
            }
        }
        return buffer.toString();
    }
}

