/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.walletpg;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.payment.PaymentOption;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WalletConsumerProfile {
    @SerializedName(value="userDetails")
    private CitrusUser citrusUser;
    @SerializedName(value="paymentOptionsList")
    private List<PaymentOption> paymentOptionList;

    public WalletConsumerProfile(CitrusUser citrusUser, List<PaymentOption> paymentOptionList) {
        this.citrusUser = citrusUser;
        this.paymentOptionList = paymentOptionList;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public List<PaymentOption> getPaymentOptionList() {
        return this.paymentOptionList;
    }

    public static WalletConsumerProfile fromJSON(String json) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        return WalletConsumerProfile.fromJSONObject(jsonObject);
    }

    public static WalletConsumerProfile fromJSONObject(JSONObject jsonObject) {
        WalletConsumerProfile walletConsumerProfile = null;
        ArrayList<PaymentOption> paymentOptionList = null;
        JSONArray paymentOptionsArray = jsonObject.optJSONArray("paymentOptionsList");
        for (int i = 0; i < paymentOptionsArray.length(); ++i) {
            JSONObject paymentOptionObject = paymentOptionsArray.optJSONObject(i);
            PaymentOption paymentOption = PaymentOption.fromJSONObject(paymentOptionObject, true);
            if (paymentOptionList == null) {
                paymentOptionList = new ArrayList<PaymentOption>();
            }
            paymentOptionList.add(paymentOption);
        }
        CitrusUser citrusUser = CitrusUser.fromJSONObject(jsonObject.optJSONObject("userDetails"));
        walletConsumerProfile = new WalletConsumerProfile(citrusUser, paymentOptionList);
        return walletConsumerProfile;
    }
}

