/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.views;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.CountDownTimer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

public class CitrusProgressBar
extends Dialog {
    private ProgressBar mProgressBar = null;
    private TextView mTextView = null;
    private Context mContext = null;
    private CountDownTimer mCountDownTimer = null;
    private int COUNTDOWN_TIME = 10000;

    public CitrusProgressBar(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public CitrusProgressBar(Context context, int themeResId, Context mContext) {
        super(context, themeResId);
        this.mContext = mContext;
        this.init();
    }

    public CitrusProgressBar(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener, Context mContext) {
        super(context, cancelable, cancelListener);
        this.mContext = mContext;
        this.init();
    }

    private void init() {
        this.mCountDownTimer = new CountDownTimer(this.COUNTDOWN_TIME, 100L){

            public void onTick(long millisUntilFinished) {
                CitrusProgressBar.this.setProgressBarColor(millisUntilFinished);
            }

            public void onFinish() {
                CitrusProgressBar.this.setProgressBarColor(0L);
            }
        };
        this.mProgressBar = new ProgressBar(this.mContext);
        this.mProgressBar.setIndeterminate(true);
        this.mProgressBar.setPadding(16, 16, 16, 16);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mTextView = new TextView(this.mContext);
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mTextView.setGravity(3);
        this.mTextView.setPadding(16, 16, 16, 16);
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setOrientation(0);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setPadding(16, 16, 0, 16);
        linearLayout.setGravity(16);
        linearLayout.addView((View)this.mProgressBar);
        linearLayout.addView((View)this.mTextView);
        this.requestWindowFeature(1);
        this.setContentView((View)linearLayout);
    }

    public void setMessage(String message) {
        this.mTextView.setText((CharSequence)message);
    }

    public void show() {
        super.show();
        this.startTimer();
    }

    public void hide() {
        super.hide();
        this.stopTimer();
    }

    private void startTimer() {
        this.mCountDownTimer.start();
    }

    private void stopTimer() {
        this.mCountDownTimer.cancel();
    }

    private void setProgressBarColor(long millisUntilFinished) {
        String colorCode = "#FF0080";
        switch ((int)(millisUntilFinished / 1000L)) {
            case 1: 
            case 6: {
                colorCode = "#0040FF";
                break;
            }
            case 2: 
            case 7: {
                colorCode = "#FF0000";
                break;
            }
            case 3: 
            case 8: {
                colorCode = "#AEB404";
                break;
            }
            case 4: 
            case 9: {
                colorCode = "#088A08";
                break;
            }
            case 0: 
            case 5: {
                colorCode = "#4000FF";
            }
        }
        this.mProgressBar.getIndeterminateDrawable().setColorFilter(Color.parseColor((String)colorCode), PorterDuff.Mode.MULTIPLY);
    }
}

