/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentType
implements Parcelable {
    protected Amount amount;
    protected String url;
    protected PaymentBill paymentBill = null;
    protected PaymentOption paymentOption = null;
    protected List<PaymentOption> paymentOptionList = null;
    protected CitrusUser citrusUser = null;

    protected PaymentType() {
    }

    protected PaymentType(PaymentBill paymentBill) {
        this.paymentBill = paymentBill;
        this.amount = paymentBill.getAmount();
    }

    public PaymentType(Amount amount, String url, PaymentOption paymentOption, CitrusUser citrusUser) {
        this.amount = amount;
        this.url = url;
        this.paymentOption = paymentOption;
        this.citrusUser = citrusUser;
    }

    public PaymentType(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser) {
        this(paymentBill);
        this.paymentOption = paymentOption;
        this.citrusUser = citrusUser;
    }

    public PaymentType(Amount amount, String url, List<PaymentOption> paymentOptionList) {
        this(amount, url, null, null);
        this.paymentOptionList = paymentOptionList;
    }

    public PaymentType(PaymentBill paymentBill, List<PaymentOption> paymentOptionList) {
        this(paymentBill, null, null);
        this.paymentOptionList = paymentOptionList;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getUrl() {
        return this.url;
    }

    public PaymentBill getPaymentBill() {
        return this.paymentBill;
    }

    public PaymentOption getPaymentOption() {
        return this.paymentOption;
    }

    public List<PaymentOption> getPaymentOptionList() {
        return this.paymentOptionList;
    }

    public CitrusUser getCitrusUser() {
        return this.citrusUser;
    }

    public abstract String getIntentAction();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.amount, 0);
        dest.writeString(this.url);
        dest.writeParcelable((Parcelable)this.paymentBill, 0);
        dest.writeParcelable((Parcelable)this.paymentOption, 0);
        dest.writeList(this.paymentOptionList);
        dest.writeParcelable((Parcelable)this.citrusUser, 0);
    }

    protected PaymentType(Parcel in) {
        this.amount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.url = in.readString();
        this.paymentBill = (PaymentBill)in.readParcelable(PaymentBill.class.getClassLoader());
        this.paymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
        this.paymentOptionList = in.readArrayList(PaymentOption.class.getClassLoader());
        this.citrusUser = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
    }

    public static class SplitPayment
    extends PaymentType {
        private boolean useMVC = false;
        private boolean useCitrusCash = false;
        public static final Parcelable.Creator<SplitPayment> CREATOR = new Parcelable.Creator<SplitPayment>(){

            public SplitPayment createFromParcel(Parcel source) {
                return new SplitPayment(source);
            }

            public SplitPayment[] newArray(int size) {
                return new SplitPayment[size];
            }
        };

        public SplitPayment(Amount totalTrannsactionAmount, String billUrl, PaymentOption paymentOption, boolean useCitrusCash, boolean useMVC) throws CitrusException {
            super(totalTrannsactionAmount, billUrl, paymentOption, null);
            this.useCitrusCash = useCitrusCash;
            this.useMVC = useMVC;
            if (totalTrannsactionAmount == null || TextUtils.isEmpty((CharSequence)totalTrannsactionAmount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(totalTrannsactionAmount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (billUrl == null) {
                throw new CitrusException("billUrl should be not null.");
            }
            if (!this.amount.isValidAmount()) {
                throw new CitrusException("Please enter amount upto 2 decimal points only.");
            }
        }

        public SplitPayment(PaymentBill paymentBill, PaymentOption paymentOption, boolean useCitrusCash, boolean useMVC) throws CitrusException {
            super(paymentBill, paymentOption, null);
            this.useCitrusCash = useCitrusCash;
            this.useMVC = useMVC;
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (!paymentBill.getAmount().isValidAmount()) {
                throw new CitrusException("Please enter amount upto 2 decimal points only.");
            }
        }

        public SplitPayment(PGPayment pgPayment) {
            if (pgPayment.getPaymentBill() != null) {
                this.paymentBill = pgPayment.getPaymentBill();
            } else {
                this.amount = pgPayment.getAmount();
                this.url = pgPayment.getUrl();
            }
            this.paymentOption = pgPayment.getPaymentOption();
            this.paymentOption.transactionAmount = pgPayment.getAmount();
        }

        public boolean isCitrusCashEnabled() {
            return this.useCitrusCash;
        }

        public boolean isMVCEnabled() {
            return this.useMVC;
        }

        @Override
        public String getIntentAction() {
            return "ACTION_WALLET_PG_PAYMENT";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte(this.useMVC ? (byte)1 : 0);
            dest.writeByte(this.useCitrusCash ? (byte)1 : 0);
        }

        protected SplitPayment(Parcel in) {
            super(in);
            this.useMVC = in.readByte() != 0;
            this.useCitrusCash = in.readByte() != 0;
        }
    }

    public static class PGPayment
    extends PaymentType
    implements Parcelable {
        private boolean isSingleHop = false;
        private boolean bDyanmicPricingRequest = false;
        private DynamicPricingResponse dynamicPricingResponse = null;
        public static final Parcelable.Creator<PGPayment> CREATOR = new Parcelable.Creator<PGPayment>(){

            public PGPayment createFromParcel(Parcel source) {
                return new PGPayment(source);
            }

            public PGPayment[] newArray(int size) {
                return new PGPayment[size];
            }
        };

        private PGPayment() {
        }

        public PGPayment(Amount amount, String billUrl, PaymentOption paymentOption, CitrusUser citrusUser) throws CitrusException {
            super(amount, billUrl, paymentOption, citrusUser);
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (billUrl == null) {
                throw new CitrusException("billUrl should be not null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
        }

        public PGPayment(DynamicPricingResponse dynamicPricingResponse) throws CitrusException {
            this(dynamicPricingResponse.getPaymentBill(), dynamicPricingResponse.getPaymentOption(), dynamicPricingResponse.getCitrusUser());
            this.bDyanmicPricingRequest = true;
            this.dynamicPricingResponse = dynamicPricingResponse;
        }

        public PGPayment(PaymentBill paymentBill, PaymentOption paymentOption) throws CitrusException {
            super(paymentBill);
            this.paymentOption = paymentOption;
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("paymentOption should not be null.");
            }
        }

        public PGPayment(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser) throws CitrusException {
            super(paymentBill, paymentOption, citrusUser);
            this.paymentOption = paymentOption;
            this.citrusUser = citrusUser;
            if (paymentBill == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentBill should not be null.");
            }
        }

        public PGPayment(SplitPayment splitPayment) throws CitrusException {
            if (splitPayment.getPaymentBill() != null) {
                this.paymentBill = splitPayment.getPaymentBill();
                this.amount = this.paymentBill.getAmount();
            } else {
                this.amount = splitPayment.getAmount();
                this.url = splitPayment.getUrl();
            }
            this.paymentOption = splitPayment.getPaymentOption();
        }

        public boolean isSingleHop() {
            return this.isSingleHop;
        }

        public void useSingleHop(boolean useSingleHop) {
            this.isSingleHop = useSingleHop;
        }

        public boolean isDyanmicPricingRequest() {
            return this.bDyanmicPricingRequest;
        }

        public DynamicPricingResponse getDynamicPricingResponse() {
            return this.dynamicPricingResponse;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_PG_PAYMENT";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.paymentOption, 0);
            dest.writeParcelable((Parcelable)this.citrusUser, 0);
            dest.writeParcelable((Parcelable)this.amount, 0);
            dest.writeString(this.url);
            dest.writeParcelable((Parcelable)this.paymentBill, 0);
        }

        private PGPayment(Parcel in) {
            this.paymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
            this.citrusUser = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
            this.amount = (Amount)in.readParcelable(Amount.class.getClassLoader());
            this.url = in.readString();
            this.paymentBill = (PaymentBill)in.readParcelable(PaymentBill.class.getClassLoader());
        }
    }

    public static class CitrusCash
    extends PaymentType
    implements Parcelable {
        public static final Parcelable.Creator<CitrusCash> CREATOR = new Parcelable.Creator<CitrusCash>(){

            public CitrusCash createFromParcel(Parcel source) {
                return new CitrusCash(source);
            }

            public CitrusCash[] newArray(int size) {
                return new CitrusCash[size];
            }
        };

        private CitrusCash() {
        }

        public CitrusCash(Amount amount, String billUrl) throws CitrusException {
            super(amount, billUrl, null, null);
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (billUrl == null) {
                throw new CitrusException("billUrl should be not null.");
            }
        }

        public CitrusCash(PaymentBill paymentBill) {
            super(paymentBill);
        }

        public final void setPaymentBill(PaymentBill paymentBill) {
            this.paymentBill = paymentBill;
        }

        public final void setCitrusUser(CitrusUser citrusUser) {
            this.citrusUser = citrusUser;
        }

        public final String getPaymentJSON() {
            String json = "";
            JSONObject jsonObject = PaymentBill.toJSONObject(this.paymentBill);
            if (jsonObject != null) {
                try {
                    jsonObject.put("userDetails", (Object)CitrusUser.toJSONObject(this.citrusUser, true));
                    jsonObject.put("requestOrigin", (Object)"MSDKW");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                json = jsonObject.toString();
            }
            return json;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_PAY_USING_CASH";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.amount, 0);
            dest.writeString(this.url);
            dest.writeParcelable((Parcelable)this.paymentBill, 0);
            dest.writeParcelable((Parcelable)this.paymentOption, 0);
            dest.writeParcelable((Parcelable)this.citrusUser, 0);
        }

        private CitrusCash(Parcel in) {
            this.amount = (Amount)in.readParcelable(Amount.class.getClassLoader());
            this.url = in.readString();
            this.paymentBill = (PaymentBill)in.readParcelable(PaymentBill.class.getClassLoader());
            this.paymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
            this.citrusUser = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
        }
    }

    public static class LoadMoney
    extends PaymentType
    implements Parcelable {
        private PaymentOption paymentOption = null;
        public static final Parcelable.Creator<LoadMoney> CREATOR = new Parcelable.Creator<LoadMoney>(){

            public LoadMoney createFromParcel(Parcel source) {
                return new LoadMoney(source);
            }

            public LoadMoney[] newArray(int size) {
                return new LoadMoney[size];
            }
        };

        private LoadMoney() {
        }

        public LoadMoney(Amount amount, String returnUrl, PaymentOption paymentOption) throws CitrusException {
            super(amount, returnUrl, paymentOption, null);
            this.paymentOption = paymentOption;
            if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
                throw new CitrusException("Amount should be not null or blank.");
            }
            if (!(amount.getValueAsDouble() > 0.0)) {
                throw new CitrusException("Amount should be greater than 0");
            }
            if (returnUrl == null) {
                throw new CitrusException("returnUrl should be not null.");
            }
            if (paymentOption == null) {
                throw new CitrusException("PaymentOption should be not null.");
            }
        }

        @Override
        public PaymentOption getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final String getIntentAction() {
            return "ACTION_LOAD_MONEY";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.paymentOption, 0);
            dest.writeParcelable((Parcelable)this.amount, 0);
            dest.writeString(this.url);
            dest.writeParcelable((Parcelable)this.paymentBill, 0);
            dest.writeParcelable((Parcelable)this.paymentOption, 0);
            dest.writeParcelable((Parcelable)this.citrusUser, 0);
        }

        private LoadMoney(Parcel in) {
            this.paymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
            this.amount = (Amount)in.readParcelable(Amount.class.getClassLoader());
            this.url = in.readString();
            this.paymentBill = (PaymentBill)in.readParcelable(PaymentBill.class.getClassLoader());
            this.paymentOption = (PaymentOption)in.readParcelable(PaymentOption.class.getClassLoader());
            this.citrusUser = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
        }
    }
}

