/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.CitrusCash;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.DebitCardOption;
import com.citrus.sdk.payment.MVCOption;
import com.citrus.sdk.payment.NetbankingOption;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PaymentOption
implements Parcelable {
    protected String name = null;
    protected String token = null;
    protected boolean savePaymentOption = false;
    protected Amount transactionAmount = null;
    protected PGHealth pgHealth = PGHealth.UNKNOWN;
    protected boolean defaultPaymentMode = false;
    protected boolean selected = false;
    protected boolean shown = false;
    protected String fingerPrint = null;
    private int amount;
    private String cvvText = "";

    PaymentOption() {
    }

    PaymentOption(String name, String token) {
        this.name = name;
        this.token = token;
    }

    PaymentOption(Amount transactionAmount, String name, String token) {
        this.transactionAmount = transactionAmount;
        this.name = name;
        this.token = token;
    }

    public static PaymentOption fromJSONObject(JSONObject walletObject) {
        return PaymentOption.fromJSONObject(walletObject, false);
    }

    public static PaymentOption fromJSONObject(JSONObject walletObject, boolean walletPGParsing) {
        String cardHolderName;
        String bankName;
        String fingerPrint;
        CardOption.CardScheme cardScheme;
        String cardNumber;
        String expiry;
        String token;
        String name;
        String type;
        PaymentOption paymentOption = null;
        String expiryMonth = "";
        String expiryYear = "";
        String amount = "";
        String campaignCode = "";
        String maxBalance = "";
        boolean defaultPaymentMode = false;
        if (walletPGParsing) {
            type = walletObject.optString("paymentMode");
            name = walletObject.optString("name");
            token = walletObject.optString("savedCardToken");
            expiry = walletObject.optString("cardExpiryDate");
            cardNumber = walletObject.optString("cardNumber");
            String cardSchemeStr = walletObject.optString("cardScheme");
            cardScheme = CardOption.CardScheme.getCardScheme(cardSchemeStr);
            fingerPrint = walletObject.optString("fingerPrint");
            bankName = walletObject.optString("bank");
            cardHolderName = "";
            amount = walletObject.optString("amount");
            campaignCode = walletObject.optString("campaignCode");
            maxBalance = walletObject.optString("maxBalance");
            defaultPaymentMode = walletObject.optBoolean("defaultPaymentMode", false);
        } else {
            type = walletObject.optString("type");
            name = walletObject.optString("name");
            token = walletObject.optString("token");
            cardHolderName = walletObject.optString("owner");
            expiry = walletObject.optString("expiryDate");
            cardNumber = walletObject.optString("number");
            String cardSchemeStr = walletObject.optString("scheme");
            cardScheme = CardOption.CardScheme.getCardScheme(cardSchemeStr);
            fingerPrint = walletObject.optString("fingerPrint");
            bankName = walletObject.optString("bank");
        }
        if (!TextUtils.isEmpty((CharSequence)expiry) && expiry.length() > 2) {
            expiryMonth = TextUtils.substring((CharSequence)expiry, (int)0, (int)2);
            expiryYear = TextUtils.substring((CharSequence)expiry, (int)2, (int)expiry.length());
        }
        if (TextUtils.equals((CharSequence)"credit", (CharSequence)type) || TextUtils.equals((CharSequence)"CREDIT_CARD", (CharSequence)type)) {
            paymentOption = new CreditCardOption(cardHolderName, cardNumber, null, Month.getMonth(expiryMonth), Year.getYear(expiryYear));
            super.setName(name);
            super.setToken(token);
            ((CardOption)paymentOption).setCardScheme(cardScheme);
        } else if (TextUtils.equals((CharSequence)"debit", (CharSequence)type) || TextUtils.equals((CharSequence)"DEBIT_CARD", (CharSequence)type)) {
            paymentOption = new DebitCardOption(cardHolderName, cardNumber, null, Month.getMonth(expiryMonth), Year.getYear(expiryYear));
            super.setName(name);
            super.setToken(token);
            ((DebitCardOption)paymentOption).setCardScheme(cardScheme);
        } else if (TextUtils.equals((CharSequence)"netbanking", (CharSequence)type) || TextUtils.equals((CharSequence)"NET_BANKING", (CharSequence)type)) {
            paymentOption = new NetbankingOption(name, token, bankName);
        } else if (TextUtils.equals((CharSequence)"MVC", (CharSequence)type)) {
            Amount maxBalanceAmount = new Amount(maxBalance);
            Amount transactionAmount = new Amount(amount);
            paymentOption = new MVCOption(transactionAmount, campaignCode, maxBalanceAmount);
        } else if (TextUtils.equals((CharSequence)"PREPAID_CARD", (CharSequence)type)) {
            Amount maxBalanceAmount = new Amount(maxBalance);
            Amount transactionAmount = new Amount(amount);
            paymentOption = new CitrusCash(transactionAmount, maxBalanceAmount);
        }
        paymentOption.setDefaultPaymentMode(defaultPaymentMode);
        if (!TextUtils.isEmpty((CharSequence)fingerPrint)) {
            paymentOption.setFingerPrint(fingerPrint);
        }
        return paymentOption;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getToken() {
        return this.token;
    }

    private void setToken(String token) {
        this.token = token;
    }

    public boolean isSavePaymentOption() {
        return this.savePaymentOption;
    }

    public void setSavePaymentOption(boolean savePaymentOption) {
        this.savePaymentOption = savePaymentOption;
    }

    public PGHealth getPgHealth() {
        return this.pgHealth;
    }

    protected void setPgHealth(PGHealth pgHealth) {
        this.pgHealth = pgHealth;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public boolean isDefaultPaymentMode() {
        return this.defaultPaymentMode;
    }

    void setDefaultPaymentMode(boolean defaultPaymentMode) {
        this.defaultPaymentMode = defaultPaymentMode;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isShown() {
        return this.shown;
    }

    public int getCashAmount() {
        return this.amount;
    }

    public void setCashAmount(int amount) {
        this.amount = amount;
    }

    public String getCvvText() {
        return this.cvvText;
    }

    public void setCvvText(String cvvText) {
        this.cvvText = cvvText;
    }

    public abstract String getSavePaymentOptionObject();

    public abstract String getSaveDefaultPaymentOptionObject();

    public abstract JSONObject getMOTOPaymentOptionObject() throws JSONException;

    public abstract JSONObject getWalletChargePaymentOptionObject() throws JSONException;

    public abstract Drawable getOptionIcon(Context var1);

    public abstract String getDynamicPricingPaymentMode();

    public String toString() {
        return "PaymentOption{name='" + this.name + '\'' + ", token='" + this.token + '\'' + ", defaultPaymentMode=" + this.defaultPaymentMode + ", selected=" + this.selected + '}';
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            PaymentOption paymentOption = (PaymentOption)object;
            if (this.name.equalsIgnoreCase(paymentOption.getName())) {
                result = true;
            }
        }
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.token);
        dest.writeByte(this.savePaymentOption ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
        dest.writeInt(this.pgHealth == null ? -1 : this.pgHealth.ordinal());
        dest.writeByte(this.defaultPaymentMode ? (byte)1 : 0);
        dest.writeByte(this.selected ? (byte)1 : 0);
        dest.writeByte(this.shown ? (byte)1 : 0);
        dest.writeString(this.fingerPrint);
        dest.writeInt(this.amount);
        dest.writeString(this.cvvText);
    }

    protected PaymentOption(Parcel in) {
        this.name = in.readString();
        this.token = in.readString();
        this.savePaymentOption = in.readByte() != 0;
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        int tmpPgHealth = in.readInt();
        this.pgHealth = tmpPgHealth == -1 ? null : PGHealth.values()[tmpPgHealth];
        this.defaultPaymentMode = in.readByte() != 0;
        this.selected = in.readByte() != 0;
        this.shown = in.readByte() != 0;
        this.fingerPrint = in.readString();
        this.amount = in.readInt();
        this.cvvText = in.readString();
    }

    public final boolean isTokenizedPayment() {
        return !TextUtils.isEmpty((CharSequence)this.token);
    }
}

