/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.CitrusPrepaidBill;
import com.citrus.sdk.dynamicPricing.DynamicPricingResponse;
import com.citrus.sdk.payment.PaymentBill;
import com.citrus.sdk.payment.PaymentOption;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentData {
    private PaymentBill paymentBill = null;
    private CitrusPrepaidBill prepaidBill = null;
    private PaymentOption paymentOption = null;
    private List<PaymentOption> listPaymentOptions = null;
    private CitrusUser citrusUser = null;
    private DynamicPricingResponse dynamicPricingResponse = null;

    public PaymentData(PaymentBill paymentBill, PaymentOption paymentOption, CitrusUser citrusUser, DynamicPricingResponse dynamicPricingResponse) {
        this.paymentBill = paymentBill;
        this.paymentOption = paymentOption;
        this.citrusUser = citrusUser;
        this.dynamicPricingResponse = dynamicPricingResponse;
    }

    public PaymentData(PaymentBill paymentBill, List<PaymentOption> listPaymentOptions, CitrusUser citrusUser, DynamicPricingResponse dynamicPricingResponse) {
        this.paymentBill = paymentBill;
        this.listPaymentOptions = listPaymentOptions;
        this.citrusUser = citrusUser;
        this.dynamicPricingResponse = dynamicPricingResponse;
    }

    public PaymentData(CitrusPrepaidBill prepaidBill, PaymentOption paymentOption, CitrusUser citrusUser) {
        this.prepaidBill = prepaidBill;
        this.paymentOption = paymentOption;
        this.citrusUser = citrusUser;
    }

    public String getPaymentJSON() {
        String json = null;
        try {
            JSONObject jsonObject = this.paymentBill != null ? PaymentBill.toJSONObject(this.paymentBill) : (this.prepaidBill != null ? CitrusPrepaidBill.toJSONObject(this.prepaidBill) : new JSONObject());
            if (this.dynamicPricingResponse != null) {
                jsonObject.put("offerToken", (Object)this.dynamicPricingResponse.getOfferToken());
            }
            jsonObject.put("userDetails", (Object)CitrusUser.toJSONObject(this.citrusUser, false));
            if (this.paymentOption != null) {
                JSONObject paymentToken = this.paymentOption.getMOTOPaymentOptionObject();
                jsonObject.put("paymentToken", (Object)paymentToken);
                if (this.paymentOption.isTokenizedPayment()) {
                    jsonObject.put("requestOrigin", (Object)"MSDKW");
                } else {
                    jsonObject.put("requestOrigin", (Object)"MSDKG");
                }
            }
            json = jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public String getWalletPGPaymentJSON() {
        String json = null;
        JSONObject jsonObject = null;
        try {
            if (this.paymentBill != null) {
                jsonObject = PaymentBill.toJSONObject(this.paymentBill, true);
                if (this.citrusUser != null) {
                    jsonObject.put("email", (Object)this.citrusUser.getEmailId());
                    jsonObject.put("mobile", (Object)this.citrusUser.getMobileNo());
                }
                if (this.dynamicPricingResponse != null) {
                    jsonObject.put("offerToken", (Object)this.dynamicPricingResponse.getOfferToken());
                }
                jsonObject.put("moto", (Object)"true");
                if (this.listPaymentOptions != null) {
                    JSONArray paymentOptionsArray = new JSONArray();
                    for (PaymentOption paymentOption : this.listPaymentOptions) {
                        JSONObject paymentMode = paymentOption.getWalletChargePaymentOptionObject();
                        paymentOptionsArray.put((Object)paymentMode);
                    }
                    jsonObject.put("paymentOptions", (Object)paymentOptionsArray);
                }
                json = jsonObject.toString();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public String getBCCancelJSON(String citrusTransacionID) {
        String json = this.getPaymentJSON();
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(json);
            jsonObject.put("citrusTransactionId", (Object)citrusTransacionID);
            json = jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }
}

