/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.CitrusException;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentBill
implements Parcelable {
    @SerializedName(value="amount")
    private Amount amount = null;
    @SerializedName(value="alteredAmount")
    private Amount alteredAmount = null;
    @SerializedName(value="requestSignature")
    private String requestSignature = null;
    @SerializedName(value="merchantTxnId")
    private String merchantTransactionId = null;
    @SerializedName(value="merchantAccessKey")
    private String merchantAccessKey = null;
    @SerializedName(value="returnUrl")
    private String returnUrl = null;
    @SerializedName(value="notifyUrl")
    private String notifyUrl = null;
    @SerializedName(value="dpSignature")
    private String dpSignature = null;
    @SerializedName(value="customParameters")
    private Map<String, String> customParametersMap = null;
    public static final Parcelable.Creator<PaymentBill> CREATOR = new Parcelable.Creator<PaymentBill>(){

        public PaymentBill createFromParcel(Parcel source) {
            return new PaymentBill(source);
        }

        public PaymentBill[] newArray(int size) {
            return new PaymentBill[size];
        }
    };

    public PaymentBill(Amount amount, Amount alteredAmount, String requestSignature, String merchantTransactionId, String merchantAccessKey, String returnUrl, String notifyUrl, String dpSignature, Map<String, String> customParametersMap) throws CitrusException {
        this.amount = amount;
        this.alteredAmount = alteredAmount;
        this.requestSignature = requestSignature;
        this.merchantTransactionId = merchantTransactionId;
        this.merchantAccessKey = merchantAccessKey;
        this.returnUrl = returnUrl;
        this.notifyUrl = notifyUrl;
        this.dpSignature = dpSignature;
        this.customParametersMap = customParametersMap;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)merchantTransactionId)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (merchantTransactionId.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)returnUrl)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)requestSignature)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)merchantAccessKey)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    public PaymentBill(Amount amount, String requestSignature, String merchantTransactionId, String merchantAccessKey, String returnUrl) throws CitrusException {
        this.amount = amount;
        this.requestSignature = requestSignature;
        this.merchantTransactionId = merchantTransactionId;
        this.merchantAccessKey = merchantAccessKey;
        this.returnUrl = returnUrl;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)merchantTransactionId)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (merchantTransactionId.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)returnUrl)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)requestSignature)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)merchantAccessKey)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    public PaymentBill(Amount amount, String requestSignature, String merchantTransactionId, String merchantAccessKey, String returnUrl, String notifyUrl, Map<String, String> customParametersMap) throws CitrusException {
        this.amount = amount;
        this.requestSignature = requestSignature;
        this.merchantTransactionId = merchantTransactionId;
        this.merchantAccessKey = merchantAccessKey;
        this.returnUrl = returnUrl;
        this.notifyUrl = notifyUrl;
        this.customParametersMap = customParametersMap;
        if (amount == null || TextUtils.isEmpty((CharSequence)amount.getValue())) {
            throw new CitrusException("Transaction Amount should not be null or empty.");
        }
        if (!(amount.getValueAsDouble() > 0.0)) {
            throw new CitrusException("Transaction Amount should be greater than 0");
        }
        if (TextUtils.isEmpty((CharSequence)merchantTransactionId)) {
            throw new CitrusException("merchantTransactionId should not be null or empty.");
        }
        if (merchantTransactionId.length() > 30) {
            throw new CitrusException("merchantTransactionId should not be more than 30 characters.");
        }
        if (TextUtils.isEmpty((CharSequence)returnUrl)) {
            throw new CitrusException("Return Url should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)requestSignature)) {
            throw new CitrusException("requestSignature should not be null or empty.");
        }
        if (TextUtils.isEmpty((CharSequence)merchantAccessKey)) {
            throw new CitrusException("merchantAccessKey should not be null or empty.");
        }
    }

    private PaymentBill() {
    }

    public Amount getAmount() {
        return this.amount;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public String getMerchantAccessKey() {
        return this.merchantAccessKey;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getDpSignature() {
        return this.dpSignature;
    }

    public Map<String, String> getCustomParametersMap() {
        return this.customParametersMap;
    }

    public static PaymentBill fromJSON(String json) {
        PaymentBill paymentBill = null;
        JSONObject billObject = null;
        if (json != null) {
            try {
                billObject = new JSONObject(json);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (billObject != null) {
                Amount amount = null;
                Amount alteredAmount = null;
                String requestSignature = null;
                String merchantTransactionId = null;
                String merchantAccessKey = null;
                String returnUrl = null;
                String notifyUrl = null;
                String dpSignature = null;
                HashMap<String, String> customParametersMap = null;
                amount = Amount.fromJSONObject(billObject.optJSONObject("amount"));
                alteredAmount = Amount.fromJSONObject(billObject.optJSONObject("alteredAmount"));
                requestSignature = billObject.optString("requestSignature");
                merchantTransactionId = billObject.optString("merchantTxnId");
                merchantAccessKey = billObject.optString("merchantAccessKey");
                returnUrl = billObject.optString("returnUrl");
                notifyUrl = billObject.optString("notifyUrl");
                dpSignature = billObject.optString("dpSignature");
                JSONObject customParamsObject = billObject.optJSONObject("customParameters");
                if (customParamsObject != null) {
                    customParametersMap = new HashMap<String, String>();
                    Iterator iter = customParamsObject.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        String value = customParamsObject.optString(key);
                        customParametersMap.put(key, value);
                    }
                }
                if (amount != null && requestSignature != null && returnUrl != null && merchantAccessKey != null && merchantTransactionId != null) {
                    try {
                        paymentBill = new PaymentBill(amount, alteredAmount, requestSignature, merchantTransactionId, merchantAccessKey, returnUrl, notifyUrl, dpSignature, customParametersMap);
                    }
                    catch (CitrusException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return paymentBill;
    }

    public static String toJSON(PaymentBill paymentBill) {
        JSONObject jsonObject = PaymentBill.toJSONObject(paymentBill);
        return paymentBill != null ? jsonObject.toString() : "";
    }

    public static JSONObject toJSONObject(PaymentBill paymentBill) {
        return PaymentBill.toJSONObject(paymentBill, false);
    }

    public static JSONObject toJSONObject(PaymentBill paymentBill, boolean walletPGResponseType) {
        JSONObject billObject = null;
        if (paymentBill != null) {
            Amount amount = paymentBill.getAmount();
            String merchantAccessKey = paymentBill.getMerchantAccessKey();
            String merchantTransactionId = paymentBill.getMerchantTransactionId();
            String requestSignature = paymentBill.getRequestSignature();
            String returnUrl = paymentBill.getReturnUrl();
            String notifyUrl = paymentBill.getNotifyUrl();
            Map<String, String> customParametersMap = paymentBill.getCustomParametersMap();
            if (amount != null && requestSignature != null && merchantAccessKey != null && merchantTransactionId != null && returnUrl != null) {
                try {
                    billObject = new JSONObject();
                    if (walletPGResponseType) {
                        billObject.put("amount", (Object)amount.getValueAsFormattedDouble("#.00"));
                        billObject.put("currency", (Object)amount.getCurrency());
                        billObject.put("merchantTransactionId", (Object)merchantTransactionId);
                        billObject.put("signature", (Object)requestSignature);
                    } else {
                        billObject.put("amount", (Object)Amount.toJSONObject(amount));
                        billObject.put("merchantTxnId", (Object)merchantTransactionId);
                        billObject.put("requestSignature", (Object)requestSignature);
                    }
                    billObject.put("merchantAccessKey", (Object)merchantAccessKey);
                    billObject.put("returnUrl", (Object)returnUrl);
                    if (!TextUtils.isEmpty((CharSequence)notifyUrl)) {
                        billObject.put("notifyUrl", (Object)notifyUrl);
                    }
                    if (!walletPGResponseType && customParametersMap != null && customParametersMap.size() > 0) {
                        JSONObject customParamsObj = new JSONObject();
                        for (Map.Entry<String, String> entry : customParametersMap.entrySet()) {
                            customParamsObj.put(entry.getKey(), (Object)entry.getValue());
                        }
                        billObject.put("customParameters", (Object)customParamsObj);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return billObject;
    }

    public String toString() {
        return "PaymentBill{amount=" + this.amount + ", requestSignature='" + this.requestSignature + '\'' + ", merchantTransactionId='" + this.merchantTransactionId + '\'' + ", merchantAccessKey='" + this.merchantAccessKey + '\'' + ", returnUrl='" + this.returnUrl + '\'' + ", notifyUrl='" + this.notifyUrl + '\'' + ", dpSignature='" + this.dpSignature + '\'' + ", customParametersMap=" + this.customParametersMap + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.amount, 0);
        dest.writeString(this.requestSignature);
        dest.writeString(this.merchantTransactionId);
        dest.writeString(this.merchantAccessKey);
        dest.writeString(this.returnUrl);
        dest.writeString(this.notifyUrl);
        dest.writeString(this.dpSignature);
        dest.writeMap(this.customParametersMap);
    }

    protected PaymentBill(Parcel in) {
        this.amount = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.requestSignature = in.readString();
        this.merchantTransactionId = in.readString();
        this.merchantAccessKey = in.readString();
        this.returnUrl = in.readString();
        this.notifyUrl = in.readString();
        this.dpSignature = in.readString();
        this.customParametersMap = in.readHashMap(String.class.getClassLoader());
    }
}

