/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.payment.PaymentOption;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class NetbankingOption
extends PaymentOption
implements Parcelable {
    private String bankName = null;
    private String bankCID = null;
    public static final Parcelable.Creator<NetbankingOption> CREATOR = new Parcelable.Creator<NetbankingOption>(){

        public NetbankingOption createFromParcel(Parcel source) {
            return new NetbankingOption(source);
        }

        public NetbankingOption[] newArray(int size) {
            return new NetbankingOption[size];
        }
    };

    private NetbankingOption() {
    }

    public NetbankingOption(String bankName, String bankCID) {
        this.bankName = bankName;
        this.bankCID = bankCID;
    }

    public NetbankingOption(Amount transactionAmount, String bankName, String bankCID) {
        this.transactionAmount = transactionAmount;
        this.bankName = bankName;
        this.bankCID = bankCID;
    }

    public NetbankingOption(String token) {
        super(null, token);
    }

    NetbankingOption(String name, String token, String bankName) {
        super(name, token);
        this.bankName = bankName;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setName(String bankName) {
        this.name = bankName;
    }

    public String getBankCID() {
        return this.bankCID;
    }

    @Override
    public void setPgHealth(PGHealth pgHealth) {
        super.setPgHealth(pgHealth);
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            return "CITRUS_WALLET";
        }
        return "NET_BANKING";
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        Drawable drawable2 = null;
        int resourceId = 0;
        resourceId = "AXIS Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("axis_bank", "drawable", context.getPackageName()) : ("Andhra Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("andhra_bank", "drawable", context.getPackageName()) : ("Bank of India".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("bank_of_india", "drawable", context.getPackageName()) : ("Bank Of Baroda".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("bank_of_baroda", "drawable", context.getPackageName()) : ("Bank of Maharashtra".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("bank_of_maharashtra", "drawable", context.getPackageName()) : ("Catholic Syrian Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("catholic_syrian", "drawable", context.getPackageName()) : ("Central Bank of India".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("central_bank_of_india", "drawable", context.getPackageName()) : ("Citibank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("citi_bank", "drawable", context.getPackageName()) : ("CITI Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("citi_bank", "drawable", context.getPackageName()) : ("Corporation Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("corporation_bank", "drawable", context.getPackageName()) : ("City Union Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("city_union_bank", "drawable", context.getPackageName()) : ("Canara Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("canara_bank", "drawable", context.getPackageName()) : ("Cosmos Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("cosmos_bank", "drawable", context.getPackageName()) : ("DEUTSCHE Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("deutsche_bank", "drawable", context.getPackageName()) : ("DCB Bank Personal".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("dcb_bank", "drawable", context.getPackageName()) : ("Federal Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("federal_bank", "drawable", context.getPackageName()) : ("HDFC Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("hdfc_bank", "drawable", context.getPackageName()) : ("ICICI Bank".equalsIgnoreCase(this.bankName) || "ICICI Corporate Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("icici_bank", "drawable", context.getPackageName()) : ("IDBI Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("idbi_bank", "drawable", context.getPackageName()) : ("Indian Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("indian_bank", "drawable", context.getPackageName()) : ("Indian Overseas Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("indian_overseas_bank", "drawable", context.getPackageName()) : ("IndusInd Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("indusind_bank", "drawable", context.getPackageName()) : ("ING VYSA".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("ing_vysa", "drawable", context.getPackageName()) : ("Kotak Mahindra Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("kotak_mahindra_bank", "drawable", context.getPackageName()) : ("ING Vysya Bank (now Kotak)".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("kotak_mahindra_bank", "drawable", context.getPackageName()) : ("Karur Vysya Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("karur_vyasa_bank", "drawable", context.getPackageName()) : ("Karnataka Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("karnataka_bank", "drawable", context.getPackageName()) : ("PNB Retail".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("punjab_national", "drawable", context.getPackageName()) : ("PNB Corporate".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("punjab_national", "drawable", context.getPackageName()) : ("SBI Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("sbi_bank", "drawable", context.getPackageName()) : ("State Bank of Bikaner and Jaipur".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("state_bank_of_bikaner_and_jaipur", "drawable", context.getPackageName()) : ("State Bank of Hyderabad".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("state_bank_of_hyderabad", "drawable", context.getPackageName()) : ("State Bank of Mysore".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("state_bank_of_mysore", "drawable", context.getPackageName()) : ("State Bank of Travancore".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("state_bank_of_travancore", "drawable", context.getPackageName()) : ("State Bank of Patiala".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("state_bank_of_patiala", "drawable", context.getPackageName()) : ("South Indian Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("south_indian_bank", "drawable", context.getPackageName()) : ("Union Bank Of India".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("union_bank", "drawable", context.getPackageName()) : ("Union Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("union_bank", "drawable", context.getPackageName()) : ("UCO Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("uco", "drawable", context.getPackageName()) : ("United Bank of India".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("united_bank_of_india", "drawable", context.getPackageName()) : ("Vijaya Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("vijaya_bank", "drawable", context.getPackageName()) : ("YES Bank".equalsIgnoreCase(this.bankName) ? context.getResources().getIdentifier("yes_bank", "drawable", context.getPackageName()) : context.getResources().getIdentifier("default_bank", "drawable", context.getPackageName()))))))))))))))))))))))))))))))))))))))))));
        if (resourceId == 0) {
            resourceId = context.getResources().getIdentifier("default_bank", "drawable", context.getPackageName());
        }
        if (resourceId != 0) {
            drawable2 = Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(resourceId, null) : context.getResources().getDrawable(resourceId);
        }
        return drawable2;
    }

    @Override
    public String getSavePaymentOptionObject() {
        JSONObject object = null;
        try {
            object = new JSONObject();
            JSONArray paymentOptions = new JSONArray();
            JSONObject option = new JSONObject();
            option.put("owner", (Object)"");
            option.put("bank", (Object)this.bankName);
            option.put("type", (Object)"netbanking");
            paymentOptions.put((Object)option);
            object.put("paymentOptions", (Object)paymentOptions);
            object.put("type", (Object)"payment");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        JSONObject object = null;
        try {
            object = new JSONObject();
            JSONArray paymentOptions = new JSONArray();
            JSONObject option = new JSONObject();
            option.put("owner", (Object)"");
            option.put("bank", (Object)this.bankName);
            option.put("type", (Object)"netbanking");
            option.put("number", (Object)"null");
            option.put("scheme", (Object)"null");
            option.put("expiryDate", (Object)"null");
            option.put("name", (Object)super.getName());
            paymentOptions.put((Object)option);
            object.put("paymentOptions", (Object)paymentOptions);
            object.put("type", (Object)"payment");
            object.put("defaultOption", (Object)super.getName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    @Override
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (this.isTokenizedPayment()) {
            jsonObject.put("type", (Object)"paymentOptionIdToken");
            jsonObject.put("id", (Object)this.token);
        } else {
            jsonObject.put("type", (Object)"paymentOptionToken");
            JSONObject paymentMode = new JSONObject();
            paymentMode.put("type", (Object)"netbanking");
            paymentMode.put("code", (Object)this.bankCID);
            jsonObject.put("paymentMode", (Object)paymentMode);
        }
        return jsonObject;
    }

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jsonObject = null;
        if (this.transactionAmount != null) {
            jsonObject = new JSONObject();
            jsonObject.put("paymentMode", (Object)"NET_BANKING");
            if (this.isTokenizedPayment()) {
                jsonObject.put("savedCardToken", (Object)this.token);
            } else {
                jsonObject.put("issuerCode", (Object)this.bankCID);
                jsonObject.put("bank", (Object)this.bankName);
            }
            jsonObject.put("name", (Object)"");
            jsonObject.put("cardNumber", (Object)"");
            jsonObject.put("cardExpiryDate", (Object)"");
            jsonObject.put("cardScheme", (Object)"");
            jsonObject.put("cvv", (Object)"");
            jsonObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jsonObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jsonObject;
    }

    @Override
    public String toString() {
        return this.bankName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetbankingOption that = (NetbankingOption)o;
        return this.bankName.equals(that.bankName);
    }

    public int hashCode() {
        return this.bankName.hashCode();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.bankName);
        dest.writeString(this.bankCID);
    }

    protected NetbankingOption(Parcel in) {
        super(in);
        this.bankName = in.readString();
        this.bankCID = in.readString();
    }
}

