/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.text.TextUtils;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.payment.CardOption;
import com.citrus.sdk.payment.NetbankingOption;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MerchantPaymentOption {
    private Set<CardOption.CardScheme> creditCardSchemeSet = null;
    private Set<CardOption.CardScheme> debitCardSchemeSet = null;
    private ArrayList<NetbankingOption> netbankingOptionList = null;
    private Set<String> bankCIDSet = null;

    private MerchantPaymentOption(Set<CardOption.CardScheme> creditCardSchemeSet, Set<CardOption.CardScheme> debitCardSchemeSet, ArrayList<NetbankingOption> netbankingOptionList, Set<String> bankCIDSet) {
        this.creditCardSchemeSet = creditCardSchemeSet;
        this.debitCardSchemeSet = debitCardSchemeSet;
        this.netbankingOptionList = netbankingOptionList;
        this.bankCIDSet = bankCIDSet;
    }

    public Set<CardOption.CardScheme> getCreditCardSchemeSet() {
        return this.creditCardSchemeSet;
    }

    public Set<CardOption.CardScheme> getDebitCardSchemeSet() {
        return this.debitCardSchemeSet;
    }

    public ArrayList<NetbankingOption> getNetbankingOptionList() {
        return this.netbankingOptionList;
    }

    public Set<String> getBankCIDSet() {
        return this.bankCIDSet;
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject merchantPaymentOptionsObj) {
        return MerchantPaymentOption.getMerchantPaymentOptions(merchantPaymentOptionsObj, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JsonObject merchantPaymentOptionsObj, Map<String, PGHealth> pgHealthMap) {
        String cardScheme;
        JsonElement element;
        int i;
        HashSet<CardOption.CardScheme> debitCardSchemeSet = null;
        HashSet<CardOption.CardScheme> creditCardSchemeSet = null;
        ArrayList<NetbankingOption> netbankingOptionList = null;
        HashSet<String> bankCIDSet = null;
        JsonArray bankArray = merchantPaymentOptionsObj.getAsJsonArray("netBanking");
        JsonArray creditCardArray = merchantPaymentOptionsObj.getAsJsonArray("creditCard");
        JsonArray debitCardArray = merchantPaymentOptionsObj.getAsJsonArray("debitCard");
        int size = -1;
        size = creditCardArray.size();
        for (i = 0; i < size; ++i) {
            element = creditCardArray.get(i);
            cardScheme = element.getAsString();
            if (creditCardSchemeSet == null) {
                creditCardSchemeSet = new HashSet<CardOption.CardScheme>();
            }
            if (CardOption.CardScheme.getCardScheme(cardScheme) == null) continue;
            creditCardSchemeSet.add(CardOption.CardScheme.getCardScheme(cardScheme));
        }
        size = debitCardArray.size();
        for (i = 0; i < size; ++i) {
            element = debitCardArray.get(i);
            cardScheme = element.getAsString();
            if (debitCardSchemeSet == null) {
                debitCardSchemeSet = new HashSet<CardOption.CardScheme>();
            }
            if (CardOption.CardScheme.getCardScheme(cardScheme) == null) continue;
            debitCardSchemeSet.add(CardOption.CardScheme.getCardScheme(cardScheme));
        }
        size = bankArray.size();
        for (i = 0; i < size; ++i) {
            element = bankArray.get(i);
            if (!element.isJsonObject()) continue;
            JsonObject bankOption = element.getAsJsonObject();
            element = bankOption.get("bankName");
            String bankName = element.getAsString();
            element = bankOption.get("issuerCode");
            String issuerCode = element.getAsString();
            if (TextUtils.isEmpty((CharSequence)bankName) || TextUtils.isEmpty((CharSequence)issuerCode)) continue;
            NetbankingOption netbankingOption = new NetbankingOption(bankName, issuerCode);
            if (pgHealthMap != null) {
                netbankingOption.setPgHealth(pgHealthMap.get(issuerCode));
            }
            if (netbankingOptionList == null) {
                netbankingOptionList = new ArrayList<NetbankingOption>();
            }
            if (bankCIDSet == null) {
                bankCIDSet = new HashSet<String>();
            }
            netbankingOptionList.add(netbankingOption);
            bankCIDSet.add(netbankingOption.getBankCID());
        }
        MerchantPaymentOption merchantPaymentOption = new MerchantPaymentOption(creditCardSchemeSet, debitCardSchemeSet, netbankingOptionList, bankCIDSet);
        return merchantPaymentOption;
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JSONObject merchantPaymentOptionsObj) {
        return MerchantPaymentOption.getMerchantPaymentOptions(merchantPaymentOptionsObj, null);
    }

    public static MerchantPaymentOption getMerchantPaymentOptions(JSONObject merchantPaymentOptionsObj, Map<String, PGHealth> pgHealthMap) {
        MerchantPaymentOption merchantPaymentOption = null;
        try {
            String cardScheme;
            int i;
            HashSet<CardOption.CardScheme> debitCardSchemeSet = null;
            HashSet<CardOption.CardScheme> creditCardSchemeSet = null;
            ArrayList<NetbankingOption> netbankingOptionList = null;
            HashSet<String> bankCIDSet = null;
            JSONArray bankArray = merchantPaymentOptionsObj.getJSONArray("netBanking");
            JSONArray creditCardArray = merchantPaymentOptionsObj.getJSONArray("creditCard");
            JSONArray debitCardArray = merchantPaymentOptionsObj.getJSONArray("debitCard");
            int size = -1;
            size = creditCardArray.length();
            try {
                for (i = 0; i < size; ++i) {
                    cardScheme = creditCardArray.getString(i);
                    if (creditCardSchemeSet == null) {
                        creditCardSchemeSet = new HashSet<CardOption.CardScheme>();
                    }
                    if (CardOption.CardScheme.getCardScheme(cardScheme) == null) continue;
                    creditCardSchemeSet.add(CardOption.CardScheme.getCardScheme(cardScheme));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            try {
                size = debitCardArray.length();
                for (i = 0; i < size; ++i) {
                    cardScheme = debitCardArray.getString(i);
                    if (debitCardSchemeSet == null) {
                        debitCardSchemeSet = new HashSet<CardOption.CardScheme>();
                    }
                    if (CardOption.CardScheme.getCardScheme(cardScheme) == null) continue;
                    debitCardSchemeSet.add(CardOption.CardScheme.getCardScheme(cardScheme));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            try {
                size = bankArray.length();
                for (int i2 = 0; i2 < size; ++i2) {
                    JSONObject bankOption = bankArray.getJSONObject(i2);
                    String bankName = bankOption.getString("bankName");
                    String issuerCode = bankOption.getString("issuerCode");
                    if (TextUtils.isEmpty((CharSequence)bankName) || TextUtils.isEmpty((CharSequence)issuerCode)) continue;
                    NetbankingOption netbankingOption = new NetbankingOption(bankName, issuerCode);
                    if (pgHealthMap != null) {
                        netbankingOption.setPgHealth(pgHealthMap.get(issuerCode));
                    }
                    if (netbankingOptionList == null) {
                        netbankingOptionList = new ArrayList<NetbankingOption>();
                    }
                    if (bankCIDSet == null) {
                        bankCIDSet = new HashSet<String>();
                    }
                    netbankingOptionList.add(netbankingOption);
                    bankCIDSet.add(netbankingOption.getBankCID());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            merchantPaymentOption = new MerchantPaymentOption(creditCardSchemeSet, debitCardSchemeSet, netbankingOptionList, bankCIDSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return merchantPaymentOption;
    }

    public String toString() {
        return "MerchantPaymentOption{creditCardSchemeSet=" + this.creditCardSchemeSet + ", debitCardSchemeSet=" + this.debitCardSchemeSet + ", netbankingOptionList=" + this.netbankingOptionList + '}';
    }
}

