/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;
import org.json.JSONException;
import org.json.JSONObject;

public class MVCOption
extends PaymentOption {
    private Amount maxBalance = null;
    private String campaignCode = null;
    public static final Parcelable.Creator<MVCOption> CREATOR = new Parcelable.Creator<MVCOption>(){

        public MVCOption createFromParcel(Parcel source) {
            return new MVCOption(source);
        }

        public MVCOption[] newArray(int size) {
            return new MVCOption[size];
        }
    };

    public MVCOption(Amount transactionAmount, String campaignCode) {
        this.transactionAmount = transactionAmount;
        this.campaignCode = campaignCode;
        this.name = "MVC Campaign " + campaignCode;
    }

    MVCOption(Amount transactionAmount, String campaignCode, Amount maxBalance) {
        this(transactionAmount, campaignCode);
        this.maxBalance = maxBalance;
        this.name = this.name + " Balance Amount: " + maxBalance.getValueAsDouble();
    }

    public Amount getMaxBalance() {
        return this.maxBalance;
    }

    public Amount getMaxBalanceRounded() {
        int value = (int)Math.floor(this.maxBalance.getValueAsDouble());
        return new Amount(String.valueOf(value));
    }

    @Override
    public String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        return null;
    }

    @Override
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        return null;
    }

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (this.transactionAmount != null) {
            jsonObject.put("paymentMode", (Object)"MVC");
            jsonObject.put("campaignCode", (Object)this.campaignCode);
            if (this.maxBalance != null) {
                jsonObject.put("maxBalance", (Object)String.valueOf(this.maxBalance.getValueAsDouble()));
            }
            jsonObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jsonObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jsonObject;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        return null;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        return "MVC";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.maxBalance, 0);
        dest.writeString(this.campaignCode);
    }

    protected MVCOption(Parcel in) {
        super(in);
        this.maxBalance = (Amount)in.readParcelable(Amount.class.getClassLoader());
        this.campaignCode = in.readString();
    }
}

