/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.payment.CardOption;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DebitCardOption
extends CardOption
implements Parcelable {
    public static final Parcelable.Creator<DebitCardOption> CREATOR = new Parcelable.Creator<DebitCardOption>(){

        public DebitCardOption createFromParcel(Parcel source) {
            return new DebitCardOption(source);
        }

        public DebitCardOption[] newArray(int size) {
            return new DebitCardOption[size];
        }
    };

    DebitCardOption() {
    }

    public DebitCardOption(String token, String cardCVV) {
        super(token, cardCVV);
    }

    public DebitCardOption(String cardHolderName, String cardNumber, String cardCVV, Month cardExpiryMonth, Year cardExpiryYear) {
        super(cardHolderName, cardNumber, cardCVV, cardExpiryMonth, cardExpiryYear);
    }

    public DebitCardOption(Amount transactionAmount, String cardHolderName, String cardNumber, String cardCVV, Month cardExpiryMonth, Year cardExpiryYear) {
        super(transactionAmount, cardHolderName, cardNumber, cardCVV, cardExpiryMonth, cardExpiryYear);
    }

    public DebitCardOption(String cardNumber, CardOption.CardScheme cardScheme) {
        super(cardNumber, cardScheme);
    }

    private DebitCardOption(Parcel in) {
        this.cardHolderName = in.readString();
        this.cardNumber = in.readString();
        this.cardCVV = in.readString();
        this.cardExpiry = in.readString();
        this.cardExpiryMonth = in.readString();
        this.cardExpiryYear = in.readString();
        this.cardScheme = (CardOption.CardScheme)((Object)in.readSerializable());
        this.name = in.readString();
        this.token = in.readString();
        this.savePaymentOption = in.readByte() != 0;
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
    }

    @Override
    public String getCardType() {
        if (this.cardScheme == CardOption.CardScheme.AMEX) {
            return CardOption.CardType.CREDIT.getCardType();
        }
        return CardOption.CardType.DEBIT.getCardType();
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            return "CITRUS_WALLET";
        }
        return "DEBIT_CARD";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.cardHolderName);
        dest.writeString(this.cardNumber);
        dest.writeString(this.cardCVV);
        dest.writeString(this.cardExpiry);
        dest.writeString(this.cardExpiryMonth);
        dest.writeString(this.cardExpiryYear);
        dest.writeSerializable((Serializable)((Object)this.cardScheme));
        dest.writeString(this.name);
        dest.writeString(this.token);
        dest.writeByte(this.savePaymentOption ? (byte)1 : 0);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        JSONObject object = null;
        try {
            object = new JSONObject();
            JSONArray paymentOptions = new JSONArray();
            JSONObject option = new JSONObject();
            option.put("owner", (Object)this.cardHolderName);
            option.put("bank", (Object)"null");
            option.put("type", (Object)"debit");
            option.put("number", (Object)this.cardNumber);
            option.put("scheme", (Object)this.cardScheme);
            option.put("expiryDate", (Object)this.cardExpiry);
            option.put("name", (Object)super.getName());
            paymentOptions.put((Object)option);
            object.put("paymentOptions", (Object)paymentOptions);
            object.put("type", (Object)"payment");
            object.put("defaultOption", (Object)super.getName());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }
}

