/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.citrus.sdk.CitrusUser;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.payment.PaymentOption;
import org.json.JSONException;
import org.json.JSONObject;

public final class CitrusCash
extends PaymentOption {
    private CitrusUser citrusUser = null;
    private Amount maxBalance = null;
    public static final Parcelable.Creator<CitrusCash> CREATOR = new Parcelable.Creator<CitrusCash>(){

        public CitrusCash createFromParcel(Parcel source) {
            return new CitrusCash(source);
        }

        public CitrusCash[] newArray(int size) {
            return new CitrusCash[size];
        }
    };

    public CitrusCash(String name, String token) {
        super(name, token);
    }

    public CitrusCash(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
        this.name = "Citrus Cash : \u20b9 " + transactionAmount.getValueAsDouble();
    }

    CitrusCash(Amount transactionAmount, Amount maxBalance) {
        this(transactionAmount);
        this.maxBalance = maxBalance;
        this.name = "Citrus Cash Balance : \u20b9 " + maxBalance.getValueAsDouble();
    }

    public CitrusCash(Amount transactionAmount, CitrusUser citrusUser) {
        this(transactionAmount);
        this.citrusUser = citrusUser;
    }

    public Amount getMaxBalance() {
        return this.maxBalance;
    }

    public Amount getMaxBalanceRounded() {
        int value = (int)Math.floor(this.maxBalance.getValueAsDouble());
        return new Amount(String.valueOf(value));
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName()), null);
        }
        int resourceId = context.getResources().getIdentifier("citrus_cash", "drawable", context.getPackageName());
        Drawable drawable2 = Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(resourceId, null) : context.getResources().getDrawable(resourceId);
        return drawable2;
    }

    @Override
    public String getSavePaymentOptionObject() {
        return null;
    }

    @Override
    public String getDynamicPricingPaymentMode() {
        return "PREPAID_CARD";
    }

    @Override
    public String getSaveDefaultPaymentOptionObject() {
        return null;
    }

    @Override
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"paymentOptionToken");
        JSONObject paymentMode = new JSONObject();
        if (this.citrusUser != null) {
            paymentMode.put("holder", (Object)this.citrusUser.getEmailId());
        } else {
            paymentMode.put("holder", (Object)"");
        }
        paymentMode.put("number", (Object)"1234561234561234");
        paymentMode.put("scheme", (Object)"CPAY");
        paymentMode.put("type", (Object)"prepaid");
        paymentMode.put("cvv", (Object)"000");
        paymentMode.put("expiry", (Object)"04/2030");
        jsonObject.put("paymentMode", (Object)paymentMode);
        return jsonObject;
    }

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (this.transactionAmount != null) {
            jsonObject.put("paymentMode", (Object)"PREPAID_CARD");
            jsonObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jsonObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jsonObject;
    }

    @Override
    public String toString() {
        return super.toString() + "CitrusCash{" + "Balance amount='" + this.maxBalance.getValueAsDouble() + '\'' + '}';
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.citrusUser, 0);
    }

    protected CitrusCash(Parcel in) {
        super(in);
        this.citrusUser = (CitrusUser)in.readParcelable(CitrusUser.class.getClassLoader());
    }
}

