/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.payment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.citrus.sdk.classes.Amount;
import com.citrus.sdk.classes.Month;
import com.citrus.sdk.classes.PGHealth;
import com.citrus.sdk.classes.Utils;
import com.citrus.sdk.classes.Year;
import com.citrus.sdk.payment.CreditCardOption;
import com.citrus.sdk.payment.PaymentOption;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CardOption
extends PaymentOption {
    protected String cardHolderName = null;
    protected String cardNumber = null;
    protected String cardCVV = null;
    protected String cardExpiry = null;
    protected String cardExpiryMonth = null;
    protected String cardExpiryYear = null;
    protected CardScheme cardScheme = null;
    protected String nickName = null;
    public static final Parcelable.Creator<CardOption> CREATOR = new Parcelable.Creator<CardOption>(){

        public CardOption createFromParcel(Parcel source) {
            return null;
        }

        public CardOption[] newArray(int size) {
            return new CardOption[size];
        }
    };

    CardOption(Amount transactionAmount, String cardHolderName, String cardNumber, String cardCVV, Month cardExpiryMonth, Year cardExpiryYear) {
        this(cardHolderName, cardNumber, cardCVV, cardExpiryMonth, cardExpiryYear);
        this.transactionAmount = transactionAmount;
    }

    CardOption(String cardHolderName, String cardNumber, String cardCVV, Month cardExpiryMonth, Year cardExpiryYear) {
        this.cardHolderName = !TextUtils.isEmpty((CharSequence)cardHolderName) ? Utils.removeSpecialCharacters(cardHolderName) : "Card Holder Name";
        this.cardNumber = CardOption.normalizeCardNumber(cardNumber);
        this.cardCVV = cardCVV;
        this.cardScheme = CardScheme.getCardSchemeUsingNumber(cardNumber);
        if (cardExpiryMonth != null) {
            this.cardExpiryMonth = cardExpiryMonth.toString();
        }
        if (cardExpiryYear != null) {
            this.cardExpiryYear = cardExpiryYear.toString();
        }
        if (!TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && !TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            this.cardExpiry = (Object)((Object)cardExpiryMonth) + "/" + (Object)((Object)cardExpiryYear);
        }
    }

    CardOption(String token, String cardCVV) {
        this.token = token;
        this.cardCVV = cardCVV;
    }

    CardOption(String cardNumber, CardScheme cardScheme) {
        this.cardNumber = cardNumber;
        this.cardScheme = cardScheme;
    }

    CardOption() {
    }

    public abstract String getCardType();

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public String getNickName() {
        String name = this.getName();
        if ("---".equalsIgnoreCase(name)) {
            name = String.format(this instanceof CreditCardOption ? "Credit Card (%s)" : "Debit Card (%s)", this.getLast4Digits());
        }
        return name;
    }

    public String getCardExpiryYear() {
        return this.cardExpiryYear;
    }

    public String getCardExpiry() {
        return this.cardExpiry;
    }

    public String getCardExpiryMonth() {
        return this.cardExpiryMonth;
    }

    public String getCardCVV() {
        return this.cardCVV;
    }

    public void setCardCVV(String cardCVV) {
        this.cardCVV = cardCVV;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public CardScheme getCardScheme() {
        return this.cardScheme;
    }

    public void setCardScheme(CardScheme cardScheme) {
        this.cardScheme = cardScheme;
    }

    public void setNickName(String nickName) {
        this.nickName = Utils.removeSpecialCharacters(nickName);
    }

    @Override
    public PGHealth getPgHealth() {
        return PGHealth.GOOD;
    }

    private static String normalizeCardNumber(String number) {
        if (number == null) {
            return null;
        }
        return number.trim().replaceAll("\\s+|-", "");
    }

    public String getLast4Digits() {
        int length;
        String last4Digits = null;
        if (!TextUtils.isEmpty((CharSequence)this.cardNumber) && (length = this.cardNumber.length()) - 4 > 0) {
            last4Digits = this.cardNumber.substring(length - 4, length);
        }
        return last4Digits;
    }

    @Override
    public Drawable getOptionIcon(Context context) {
        Drawable drawable2 = null;
        int resourceId = 0;
        if (this.cardScheme == CardScheme.VISA) {
            resourceId = context.getResources().getIdentifier("visa", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MASTER_CARD) {
            resourceId = context.getResources().getIdentifier("mcrd", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.MAESTRO) {
            resourceId = context.getResources().getIdentifier("mtro", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.DINERS) {
            resourceId = context.getResources().getIdentifier("dinerclub", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.JCB) {
            resourceId = context.getResources().getIdentifier("jcb", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.AMEX) {
            resourceId = context.getResources().getIdentifier("amex", "drawable", context.getPackageName());
        } else if (this.cardScheme == CardScheme.RPAY) {
            resourceId = context.getResources().getIdentifier("rupay", "drawable", context.getPackageName());
            if (resourceId == 0) {
                resourceId = context.getResources().getIdentifier("rpay", "drawable", context.getPackageName());
            }
        } else if (this.cardScheme == CardScheme.DISCOVER) {
            resourceId = context.getResources().getIdentifier("discover", "drawable", context.getPackageName());
        }
        if (resourceId == 0) {
            resourceId = context.getResources().getIdentifier("default_card", "drawable", context.getPackageName());
            if (resourceId != 0) {
                drawable2 = context.getResources().getDrawable(resourceId);
            }
        } else {
            drawable2 = context.getResources().getDrawable(resourceId);
        }
        return drawable2;
    }

    @Override
    public String toString() {
        return super.toString() + "CardOption{" + "cardHolderName='" + this.cardHolderName + '\'' + ", cardNumber='" + this.cardNumber + '\'' + ", cardCVV='" + this.cardCVV + '\'' + ", cardExpiry='" + this.cardExpiry + '\'' + ", cardExpiryMonth='" + this.cardExpiryMonth + '\'' + ", cardExpiryYear='" + this.cardExpiryYear + '\'' + ", cardScheme='" + (Object)((Object)this.cardScheme) + '\'' + '}';
    }

    public int getCVVLength() {
        int cvvLength = 3;
        if (this.cardScheme == CardScheme.AMEX) {
            cvvLength = 4;
        }
        return cvvLength;
    }

    public boolean validateCard() {
        if (!TextUtils.isEmpty((CharSequence)this.token) && this.cardScheme != CardScheme.MAESTRO) {
            return this.validateCVV();
        }
        if (this.cardScheme == CardScheme.MAESTRO) {
            if (TextUtils.isEmpty((CharSequence)this.token)) {
                if (!TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                    return this.cardCVV.length() == 3 && this.validateCardNumber();
                }
                return this.validateCardNumber();
            }
            if (!TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                return this.cardCVV.length() == 3;
            }
            return true;
        }
        return this.validateCardNumber() && this.validateExpiryDate() && this.validateCVV();
    }

    public boolean validateForSaveCard() {
        if (this.cardScheme == CardScheme.MAESTRO) {
            return this.validateCardNumber();
        }
        return this.validateCardNumber() && this.validateExpiryDate();
    }

    public boolean validateCardNumber() {
        if (TextUtils.isEmpty((CharSequence)this.cardNumber)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.cardNumber) || !TextUtils.isDigitsOnly((CharSequence)this.cardNumber) || !this.isValidLuhnNumber(this.cardNumber)) {
            return false;
        }
        return !(this.cardScheme == CardScheme.AMEX ? this.cardNumber.length() != 15 : (this.cardScheme == CardScheme.VISA ? this.cardNumber.length() != 13 && this.cardNumber.length() != 16 : (this.cardScheme != CardScheme.MAESTRO ? this.cardNumber.length() != 16 : this.cardNumber.length() < 12 || this.cardNumber.length() > 19)));
    }

    public boolean validateExpiryDate() {
        if (this.cardScheme == CardScheme.MAESTRO && TextUtils.isEmpty((CharSequence)this.cardExpiryMonth) && TextUtils.isEmpty((CharSequence)this.cardExpiryYear)) {
            return true;
        }
        if (!this.validateExpMonth()) {
            return false;
        }
        if (!this.validateExpYear()) {
            return false;
        }
        return !Utils.hasMonthPassed(Integer.valueOf(this.cardExpiryYear), Integer.valueOf(this.cardExpiryMonth));
    }

    private boolean validateExpMonth() {
        if (this.cardExpiryMonth == null) {
            return false;
        }
        return Integer.valueOf(this.cardExpiryMonth) >= 1 && Integer.valueOf(this.cardExpiryMonth) <= 12;
    }

    private boolean validateExpYear() {
        if (this.cardExpiryYear == null) {
            return false;
        }
        return !Utils.hasYearPassed(Integer.valueOf(this.cardExpiryYear));
    }

    public boolean validateCVV() {
        if (TextUtils.isEmpty((CharSequence)this.cardCVV)) {
            return false;
        }
        if (this.cardScheme == CardScheme.AMEX) {
            return this.cardCVV.length() == 4;
        }
        return this.cardCVV.length() == 3;
    }

    public String getCardValidityFailureReasonsForSaveCard() {
        String reason = null;
        if (!this.validateForSaveCard()) {
            StringBuilder builder = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                builder.append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                builder.append(" Invalid Expiry Date. ");
            }
            reason = builder.toString();
        }
        return reason;
    }

    public String getCardValidityFailureReasons() {
        String reason = null;
        if (!this.validateCard()) {
            StringBuilder builder = new StringBuilder();
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateCardNumber()) {
                builder.append(" Invalid Card Number. ");
            }
            if (TextUtils.isEmpty((CharSequence)this.token) && !this.validateExpiryDate()) {
                builder.append(" Invalid Expiry Date. ");
            }
            if (this.cardScheme == CardScheme.MAESTRO) {
                if (!TextUtils.isEmpty((CharSequence)this.cardCVV) && !this.validateCVV()) {
                    builder.append(" Invalid CVV. ");
                }
            } else if (!this.validateCVV()) {
                builder.append(" Invalid CVV. ");
            }
            reason = builder.toString();
        }
        return reason;
    }

    @Override
    public String getSavePaymentOptionObject() {
        JSONObject object = null;
        try {
            object = new JSONObject();
            JSONArray paymentOptions = new JSONArray();
            JSONObject option = new JSONObject();
            option.put("owner", (Object)this.cardHolderName);
            if (!TextUtils.isEmpty((CharSequence)this.nickName)) {
                option.put("name", (Object)this.nickName);
            }
            option.put("number", (Object)this.cardNumber);
            option.put("scheme", (Object)this.cardScheme.toString());
            if (TextUtils.isEmpty((CharSequence)this.cardExpiry) && this.cardScheme == CardScheme.MAESTRO) {
                option.put("expiryDate", (Object)"12/2049");
            } else {
                option.put("expiryDate", (Object)this.cardExpiry);
            }
            option.put("type", (Object)this.getCardType());
            paymentOptions.put((Object)option);
            object.put("paymentOptions", (Object)paymentOptions);
            object.put("type", (Object)"payment");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object.toString();
    }

    @Override
    public JSONObject getMOTOPaymentOptionObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (this.isTokenizedPayment()) {
            jsonObject.put("type", (Object)"paymentOptionIdToken");
            jsonObject.put("id", (Object)this.token);
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                jsonObject.put("cvv", (Object)"123");
            } else {
                jsonObject.put("cvv", (Object)this.cardCVV);
            }
        } else {
            jsonObject.put("type", (Object)"paymentOptionToken");
            JSONObject paymentMode = new JSONObject();
            paymentMode.put("holder", (Object)this.cardHolderName);
            paymentMode.put("number", (Object)this.cardNumber);
            paymentMode.put("scheme", (Object)this.cardScheme.getName().toUpperCase());
            paymentMode.put("type", (Object)this.getCardType());
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                paymentMode.put("cvv", (Object)"123");
            } else {
                paymentMode.put("cvv", (Object)this.cardCVV);
            }
            if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardExpiry)) {
                paymentMode.put("expiry", (Object)"11/2049");
            } else {
                paymentMode.put("expiry", (Object)this.cardExpiry);
            }
            jsonObject.put("paymentMode", (Object)paymentMode);
        }
        return jsonObject;
    }

    @Override
    public JSONObject getWalletChargePaymentOptionObject() throws JSONException {
        JSONObject jsonObject = null;
        if (this.transactionAmount != null) {
            jsonObject = new JSONObject();
            if (this instanceof CreditCardOption) {
                jsonObject.put("paymentMode", (Object)"CREDIT_CARD");
            } else {
                jsonObject.put("paymentMode", (Object)"DEBIT_CARD");
            }
            if (this.isTokenizedPayment()) {
                jsonObject.put("name", (Object)"");
                jsonObject.put("cardNumber", (Object)"");
                jsonObject.put("cardExpiryDate", (Object)"");
                jsonObject.put("cardScheme", (Object)"");
                jsonObject.put("cvv", (Object)this.cardCVV);
                jsonObject.put("savedCardToken", (Object)this.token);
            } else {
                jsonObject.put("name", (Object)this.cardHolderName);
                jsonObject.put("cardNumber", (Object)this.cardNumber);
                jsonObject.put("cardScheme", (Object)this.cardScheme.getName().toUpperCase());
                if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardExpiry)) {
                    jsonObject.put("cardExpiryDate", (Object)"11/2049");
                } else {
                    jsonObject.put("cardExpiryDate", (Object)this.cardExpiry);
                }
                if (CardScheme.MAESTRO == this.cardScheme && TextUtils.isEmpty((CharSequence)this.cardCVV)) {
                    jsonObject.put("cvv", (Object)"123");
                } else {
                    jsonObject.put("cvv", (Object)this.cardCVV);
                }
            }
            jsonObject.put("amount", (Object)String.valueOf(this.transactionAmount.getValueAsDouble()));
            jsonObject.put("currency", (Object)this.transactionAmount.getCurrency());
        }
        return jsonObject;
    }

    private boolean isValidLuhnNumber(String number) {
        boolean isOdd = true;
        int sum = 0;
        for (int index = number.length() - 1; index >= 0; --index) {
            char c = number.charAt(index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Integer.parseInt("" + c);
            boolean bl = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
        }
        return sum % 10 == 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.cardHolderName);
        dest.writeString(this.cardNumber);
        dest.writeString(this.cardCVV);
        dest.writeString(this.cardExpiry);
        dest.writeString(this.cardExpiryMonth);
        dest.writeString(this.cardExpiryYear);
        dest.writeInt(this.cardScheme == null ? -1 : this.cardScheme.ordinal());
        dest.writeString(this.nickName);
        dest.writeParcelable((Parcelable)this.transactionAmount, 0);
    }

    protected CardOption(Parcel in) {
        super(in);
        this.cardHolderName = in.readString();
        this.cardNumber = in.readString();
        this.cardCVV = in.readString();
        this.cardExpiry = in.readString();
        this.cardExpiryMonth = in.readString();
        this.cardExpiryYear = in.readString();
        int tmpCardScheme = in.readInt();
        this.cardScheme = tmpCardScheme == -1 ? null : CardScheme.values()[tmpCardScheme];
        this.nickName = in.readString();
        this.transactionAmount = (Amount)in.readParcelable(Amount.class.getClassLoader());
    }

    public static enum CardScheme {
        VISA(new String[]{"4"}){

            @Override
            public String getName() {
                return "visa";
            }
        }
        ,
        MASTER_CARD(new String[]{"5"}){

            @Override
            public String getName() {
                return "mcrd";
            }
        }
        ,
        MAESTRO(new String[]{"502260", "504433", "504434", "504435", "504437", "504645", "504681", "504753", "504775", "504809", "504817", "504834", "504848", "504884", "504973", "504993", "508125", "508126", "508159", "508192", "508227", "56", "600206", "603123", "603741", "603845", "622018", "67"}){

            @Override
            public String getName() {
                return "mtro";
            }
        }
        ,
        DINERS(new String[]{"30", "36", "38", "39"}){

            @Override
            public String getName() {
                return "DINERS";
            }
        }
        ,
        JCB(new String[]{"35"}){

            @Override
            public String getName() {
                return "jcb";
            }
        }
        ,
        AMEX(new String[]{"34", "37"}){

            @Override
            public String getName() {
                return "amex";
            }
        }
        ,
        RPAY(new String[]{"5085", "5086", "5087", "5088", "6069", "607", "6081", "6521", "6522", "6524"}){

            @Override
            public String getName() {
                return "RPAY";
            }
        }
        ,
        DISCOVER(new String[]{"60", "62", "64", "65"}){

            @Override
            public String getName() {
                return "DISCOVER";
            }
        }
        ,
        UNKNOWN(new String[]{"0"}){

            @Override
            public String getName() {
                return "UNKNOWN";
            }
        };

        private final String[] pattern;

        private CardScheme(String ... pattern) {
            this.pattern = pattern;
        }

        public abstract String getName();

        public String getIconName() {
            return this.getName().toLowerCase();
        }

        public static CardScheme getCardScheme(String cardScheme) {
            if ("visa".equalsIgnoreCase(cardScheme)) {
                return VISA;
            }
            if ("mcrd".equalsIgnoreCase(cardScheme) || "Master Card".equalsIgnoreCase(cardScheme)) {
                return MASTER_CARD;
            }
            if ("mtro".equalsIgnoreCase(cardScheme) || "Maestro Card".equalsIgnoreCase(cardScheme)) {
                return MAESTRO;
            }
            if ("DINERS".equalsIgnoreCase(cardScheme)) {
                return DINERS;
            }
            if ("jcb".equalsIgnoreCase(cardScheme)) {
                return JCB;
            }
            if ("amex".equalsIgnoreCase(cardScheme)) {
                return AMEX;
            }
            if ("DISCOVER".equalsIgnoreCase(cardScheme)) {
                return DISCOVER;
            }
            if ("RPAY".equalsIgnoreCase(cardScheme) || "RuPay".equalsIgnoreCase(cardScheme)) {
                return RPAY;
            }
            return null;
        }

        public static CardScheme getCardSchemeUsingNumber(String cardNumber) {
            CardScheme cardScheme = UNKNOWN;
            for (CardScheme scheme : CardScheme.values()) {
                if (!Utils.hasAnyPrefix(cardNumber, scheme.pattern)) continue;
                cardScheme = scheme;
                break;
            }
            return cardScheme;
        }

        public static int getCVVLength(String cardNumber) {
            CardScheme scheme = CardScheme.getCardSchemeUsingNumber(cardNumber);
            if (scheme == AMEX) {
                return 4;
            }
            return 3;
        }

        public static int getFilterLength(CardScheme scheme) {
            if (scheme == AMEX) {
                return 18;
            }
            if (scheme == MAESTRO) {
                return 23;
            }
            return 19;
        }
    }

    public static enum CardType {
        DEBIT{

            @Override
            public String getCardType() {
                return "debit";
            }
        }
        ,
        CREDIT{

            @Override
            public String getCardType() {
                return "credit";
            }
        };


        public abstract String getCardType();
    }
}

