/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network.request;

import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;

public class GsonRequest<T>
extends Request<T> {
    private static final String TAG = GsonRequest.class.getSimpleName();
    private final Gson gson = new Gson();
    private final Class<T> clazz;
    private final Type type;
    private final Map<String, String> headers;
    private final Response.Listener<T> listener;
    private final Map<String, String> params;
    private final String bodyContentResponseType;
    private final String mRequestBody;

    public GsonRequest(String url, Class<T> clazz, int method, Map<String, String> headers, Map<String, String> params, String bodyContentResponseType, Response.Listener<T> listener, Response.ErrorListener errorListener, String body) {
        super(method, url, errorListener);
        Log.i((String)TAG, (String)(TAG + ".GsonRequest(): class = " + clazz + ", " + url));
        this.type = null;
        this.clazz = clazz;
        this.headers = headers;
        this.listener = listener;
        this.params = params;
        this.bodyContentResponseType = bodyContentResponseType;
        this.mRequestBody = body;
    }

    public GsonRequest(String url, Type type, int method, Map<String, String> headers, Map<String, String> params, String bodyContentResponseType, Response.Listener<T> listener, Response.ErrorListener errorListener, String body) {
        super(method, url, errorListener);
        Log.i((String)TAG, (String)(TAG + ".GsonRequest(): type = " + type + ", " + url));
        this.type = type;
        this.clazz = null;
        this.headers = headers;
        this.listener = listener;
        this.params = params;
        this.bodyContentResponseType = bodyContentResponseType;
        this.mRequestBody = body;
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        Log.i((String)TAG, (String)(TAG + ".getHeaders(): headers = " + this.headers));
        return this.headers != null ? this.headers : super.getHeaders();
    }

    protected void deliverResponse(T response) {
        Log.i((String)TAG, (String)(TAG + ".deliverResponse(): response = " + response));
        this.listener.onResponse(response);
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        Log.i((String)TAG, (String)(TAG + ".parseNetworkResponse(): for " + super.getUrl()));
        Log.i((String)TAG, (String)(TAG + ".parseNetworkResponse(): response = " + response));
        Map responseHeaders = response.headers;
        if (responseHeaders != null) {
            Log.i((String)TAG, (String)(TAG + ".parseNetworkResponse(): total responseHeaders = " + responseHeaders.size() + " =>"));
            for (String key : responseHeaders.keySet()) {
                Log.i((String)TAG, (String)(TAG + ".parseNetworkResponse(): Header = " + key + ':' + (String)responseHeaders.get(key)));
            }
        }
        try {
            String json = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            Log.i((String)TAG, (String)(TAG + ".parseNetworkResponse(): json = " + json));
            if (this.clazz != null) {
                return Response.success((Object)this.gson.fromJson(json, this.clazz), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            if (this.type != null) {
                return Response.success((Object)this.gson.fromJson(json, this.type), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JsonSyntaxException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (Exception e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        return null;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        Log.i((String)TAG, (String)(TAG + ".getParams(): params = " + this.params));
        return this.params != null ? this.params : super.getParams();
    }

    public String getBodyContentType() {
        Log.i((String)TAG, (String)(TAG + ".getBodyContentType(): bodyContentResponseType = " + this.bodyContentResponseType));
        return this.bodyContentResponseType != null ? this.bodyContentResponseType : super.getBodyContentType();
    }

    public byte[] getBody() throws AuthFailureError {
        Log.i((String)TAG, (String)(TAG + ".getBody(): mRequestBody = " + this.mRequestBody + ", params = " + this.params));
        try {
            if (this.mRequestBody != null) {
                return this.mRequestBody.getBytes("utf-8");
            }
            if (this.params != null) {
                String body = "";
                for (String key : this.params.keySet()) {
                    body = body + "&" + key + "=" + this.params.get(key);
                }
                Log.i((String)TAG, (String)(TAG + ".getBody(): param body = " + body));
                return body.getBytes("utf-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, "utf-8"});
        }
        return null;
    }
}

