/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network.request;

import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomJsonRequest
extends Request<JSONObject> {
    private static final String TAG = CustomJsonRequest.class.getSimpleName();
    private Response.Listener<JSONObject> listener;
    private Map<String, String> params;
    private final String mRequestBody;
    private final Map<String, String> headers;
    private final String bodyContentResponseType;

    public CustomJsonRequest(int method, String url, Map<String, String> params, Response.Listener<JSONObject> reponseListener, Response.ErrorListener errorListener, String mRequestBody, Map<String, String> headers, String bodyContentResponseType) {
        super(method, url, errorListener);
        Log.d((String)TAG, (String)(TAG + ".CustomJsonRequest(): " + url));
        this.listener = reponseListener;
        this.params = params;
        this.mRequestBody = mRequestBody;
        this.headers = headers;
        this.bodyContentResponseType = bodyContentResponseType;
    }

    protected Map<String, String> getParams() throws AuthFailureError {
        Log.d((String)TAG, (String)(TAG + ".getParams(): params = " + this.params));
        return this.params != null ? this.params : super.getParams();
    }

    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
            return Response.success((Object)new JSONObject(jsonString), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        catch (JSONException je) {
            return Response.error((VolleyError)new ParseError((Throwable)je));
        }
    }

    protected void deliverResponse(JSONObject response) {
        this.listener.onResponse((Object)response);
    }

    public String getBodyContentType() {
        Log.d((String)TAG, (String)(TAG + ".getBodyContentType(): bodyContentResponseType = " + this.bodyContentResponseType));
        return this.bodyContentResponseType != null ? this.bodyContentResponseType : super.getBodyContentType();
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        Log.d((String)TAG, (String)(TAG + ".getHeaders(): headers = " + this.headers));
        return this.headers != null ? this.headers : super.getHeaders();
    }

    public byte[] getBody() throws AuthFailureError {
        Log.d((String)TAG, (String)(TAG + ".getBody(): mRequestBody = " + this.mRequestBody + ", params = " + this.params));
        try {
            if (this.mRequestBody != null) {
                return this.mRequestBody.getBytes("utf-8");
            }
            if (this.params != null) {
                String body = "";
                for (String key : this.params.keySet()) {
                    body = body + "&" + key + "=" + this.params.get(key);
                }
                Log.d((String)TAG, (String)(TAG + ".getBody(): param body = " + body));
                return body.getBytes("utf-8");
            }
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, "utf-8"});
        }
        return null;
    }
}

