/*
 * Decompiled with CFR 0.152.
 */
package com.citrus.sdk.network.request;

import android.util.Log;
import com.citrus.sdk.network.Api;
import com.citrus.sdk.network.HttpMethod;
import com.citrus.sdk.network.NetworkConstants;
import com.citrus.sdk.network.request.RequestBody;
import java.util.HashMap;
import java.util.Map;

public class ApiRequest {
    private static final String TAG = ApiRequest.class.getSimpleName();
    private String relativeUrl;
    private RequestBody requestBody;
    private Map<String, String> headers;
    private HttpMethod httpMethod;
    private String cancelTag;
    private Map<String, String> params;
    private String bodyContentType;
    private Class clazz;
    private String name;

    ApiRequest() {
    }

    public String getRelativeUrl() {
        return this.relativeUrl;
    }

    public void setRelativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeaders(Map<String, String> paramHeaders) {
        if (paramHeaders != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.putAll(paramHeaders);
        }
    }

    public void addHeader(String key, String value) {
        if (key != null && value != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
        }
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getCancelTag() {
        return this.cancelTag;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return super.toString() + '|' + (Object)((Object)this.httpMethod) + '|' + this.relativeUrl + '|' + this.clazz;
    }

    public static class Builder {
        private Api api;
        private String authorizationToken;
        private Map<String, String> headers;
        private Map<String, String> params;
        private RequestBody requestBody;
        private String[] pathParams;
        private String cancelTag;

        public Builder(Api api) {
            this.api = api;
        }

        public Builder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public Builder requestBody(RequestBody requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder params(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder cancelTag(String cancelTag) {
            this.cancelTag = cancelTag;
            return this;
        }

        public Builder pathParams(String ... pathParams) {
            this.pathParams = pathParams;
            return this;
        }

        public ApiRequest build() {
            ApiRequest apiRequest = null;
            if (this.api != null) {
                apiRequest = new ApiRequest();
                if (this.pathParams != null) {
                    String formattedRelativeUrl = String.format(this.api.getRelativeUrl(), this.pathParams);
                    apiRequest.setRelativeUrl(formattedRelativeUrl);
                }
                HttpMethod httpMethod = this.api.getHttpMethod();
                String bodyContentType = this.api.getBodyContentType();
                apiRequest.name = this.api.name();
                apiRequest.httpMethod = this.api.getHttpMethod();
                apiRequest.relativeUrl = this.api.getRelativeUrl();
                apiRequest.clazz = this.api.getClazz();
                if (this.headers == null && this.authorizationToken == null) {
                    Log.w((String)TAG, (String)(TAG + ".buildApi(): WARNING: No headers for " + this.api.getRelativeUrl()));
                } else {
                    if (this.authorizationToken != null) {
                        apiRequest.addHeader("Authorization", this.authorizationToken);
                    }
                    if (this.headers != null) {
                        apiRequest.addHeaders(this.headers);
                    }
                }
                if (httpMethod != HttpMethod.GET) {
                    if (bodyContentType == null) {
                        Log.w((String)TAG, (String)(TAG + ".buildApi(): WARNING: bodyContentType is null for httpMethod " + (Object)((Object)httpMethod)));
                    } else {
                        apiRequest.bodyContentType = bodyContentType;
                        if (this.params == null && this.requestBody == null) {
                            Log.w((String)TAG, (String)(TAG + ".buildApi(): WARNING: No body"));
                        } else if (bodyContentType.equals("application/x-www-form-urlencoded")) {
                            if (this.params == null) {
                                Log.w((String)TAG, (String)(TAG + ".buildApi(): WARNING: params null for bodyContentType " + bodyContentType));
                            } else {
                                apiRequest.params = this.params;
                            }
                        } else if (bodyContentType.equals(NetworkConstants.CONTENT_TYPE_JSON)) {
                            if (this.requestBody == null) {
                                Log.w((String)TAG, (String)(TAG + ".buildApi(): WARNING: body null for bodyContentType " + bodyContentType));
                            } else {
                                apiRequest.requestBody = this.requestBody;
                            }
                        }
                    }
                }
            }
            return apiRequest;
        }
    }
}

